/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.model.ConfigurableModelProperties;
import gov.va.med.fw.model.lookup.ModelPropertiesApplicationType;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.ModelPropertiesManager;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class ApplicationContextModelProperties
extends AbstractComponent
implements ModelPropertiesManager {
    private static final String GLOBAL_PER_DOMAIN_OBJECT = "global";
    private Map classModelProperties = new HashMap();
    private Map globalModelProperties = new HashMap();
    private String rootClassName;
    private boolean useTransients = false;

    @Override
    public void flushCache() {
        this.classModelProperties.clear();
    }

    @Override
    public List getIdentityProperties(Class clazz) {
        return this.getModelProperties(clazz, ModelPropertiesApplicationType.IDENTITY.getName());
    }

    @Override
    public List getCopyProperties(Class clazz) {
        return this.getModelProperties(clazz, ModelPropertiesApplicationType.COPY.getName());
    }

    @Override
    public List getMatchDomainValuesProperties(Class clazz) {
        return this.getModelProperties(clazz, ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName());
    }

    @Override
    public List getMatchDomainConceptProperties(Class clazz) {
        return this.getModelProperties(clazz, ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName());
    }

    @Override
    public List getModelProperties(Class clazz, String application) {
        String key = clazz.getName() + "." + application;
        List propertyNames = (List)this.classModelProperties.get(key);
        if (propertyNames == null) {
            propertyNames = this.initializeModelProperties(clazz, application);
            this.classModelProperties.put(key, propertyNames);
        }
        return propertyNames;
    }

    @Override
    public ConfigurableModelProperties getConfigurableModelProperties(Class clazz, String application) {
        ConfigurableModelProperties globalPerApplication;
        ConfigurableModelProperties globalPerDomainObject;
        ConfigurableModelProperties modelProperties = this.getModelPropertiesBean(clazz, application);
        if (modelProperties == null && !ModelPropertiesApplicationType.IDENTITY.getName().equals(application)) {
            modelProperties = this.getModelPropertiesBean(clazz, ModelPropertiesApplicationType.IDENTITY.getName());
        }
        if ((globalPerDomainObject = this.getModelPropertiesBean(clazz, GLOBAL_PER_DOMAIN_OBJECT)) != null) {
            if (modelProperties != null) {
                modelProperties.addInclusions(globalPerDomainObject.getInclusions());
                modelProperties.addExclusions(globalPerDomainObject.getExclusions());
            } else {
                modelProperties = globalPerDomainObject;
            }
        }
        if ((globalPerApplication = this.getGlobalModelPropertiesObject(application)) != null) {
            if (modelProperties != null) {
                modelProperties.setGlobalProperties(globalPerApplication);
            } else if (globalPerApplication != null) {
                modelProperties = new ConfigurableModelProperties(globalPerApplication);
            }
        }
        if (modelProperties == null) {
            modelProperties = new ConfigurableModelProperties();
            modelProperties.allowAllProperties();
        }
        return modelProperties;
    }

    private ConfigurableModelProperties getModelPropertiesBean(Class clazz, String application) {
        ConfigurableModelProperties modelProperties = null;
        try {
            modelProperties = (ConfigurableModelProperties)((Object)this.getApplicationContext().getBean(clazz.getName() + "." + application));
        }
        catch (NoSuchBeanDefinitionException e) {
        }
        catch (BeanNotOfRequiredTypeException e) {
            // empty catch block
        }
        return modelProperties;
    }

    private ConfigurableModelProperties getGlobalModelPropertiesObject(String application) {
        ConfigurableModelProperties modelProperties = (ConfigurableModelProperties)((Object)this.globalModelProperties.get(application));
        if (modelProperties == null) {
            modelProperties = new ConfigurableModelProperties();
            modelProperties.rejectAllProperties();
            this.globalModelProperties.put(application, modelProperties);
        }
        return modelProperties;
    }

    private List initializeModelProperties(Class clazz, String application) {
        ArrayList<Field> props = new ArrayList<Field>();
        ConfigurableModelProperties instanceModelProperties = this.getConfigurableModelProperties(clazz, application);
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(clazz);
        if (instanceModelProperties.isInheritAncestorsProperties()) {
            classes.addAll(ClassUtils.getAllSuperclasses((Class)clazz));
        }
        Iterator itrClasses = classes.iterator();
        Class targetClazz = null;
        boolean isDescendantOfRootClassName = false;
        String realizedRootClassName = this.rootClassName;
        ArrayList<AccessibleObject> candidateFields = new ArrayList<AccessibleObject>();
        AccessibleObject[] fields = null;
        while (itrClasses.hasNext()) {
            targetClazz = (Class)itrClasses.next();
            if (!isDescendantOfRootClassName) {
                isDescendantOfRootClassName = targetClazz.getName().equals(this.rootClassName);
            }
            fields = targetClazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; fields != null && i < fields.length; ++i) {
                if (((Field)fields[i]).getName().indexOf(36) != -1 || !this.useTransients && Modifier.isTransient(((Field)fields[i]).getModifiers()) || Modifier.isStatic(((Field)fields[i]).getModifiers())) continue;
                candidateFields.add(fields[i]);
            }
        }
        if (!isDescendantOfRootClassName) {
            realizedRootClassName = Object.class.getName();
        }
        Iterator itrFields = candidateFields.iterator();
        Field field = null;
        ConfigurableModelProperties targetClassModelProperties = null;
        block2: while (itrFields.hasNext()) {
            field = (Field)itrFields.next();
            itrClasses = classes.iterator();
            while (itrClasses.hasNext() && (targetClassModelProperties = (targetClazz = (Class)itrClasses.next()) == clazz ? instanceModelProperties : this.getConfigurableModelProperties(targetClazz, application)).shouldInclude(field.getName())) {
                if (!targetClassModelProperties.isPropertySpecified(field.getName()) && !targetClazz.getName().equals(realizedRootClassName)) continue;
                props.add(field);
                continue block2;
            }
        }
        return props;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public void setRootClassName(String rootClassName) {
        this.rootClassName = rootClassName;
    }

    public boolean isUseTransients() {
        return this.useTransients;
    }

    public void setUseTransients(boolean useTransients) {
        this.useTransients = useTransients;
    }

    public Map getGlobalModelProperties() {
        return this.globalModelProperties;
    }

    public void setGlobalModelProperties(Map globalModelProperties) {
        this.globalModelProperties = globalModelProperties;
    }
}

