/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.config.SingletonApplicationContext;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractTestCase
extends AbstractTransactionalDataSourceSpringContextTests {
    protected static final String DEFAULT_TEST_CONTEXT = "fw/test_components.xml";
    protected String[] configLocations = new String[]{"fw/test_components.xml"};

    public AbstractTestCase() {
    }

    public AbstractTestCase(String name) {
        this.setName(name);
    }

    public AbstractTestCase(String[] configFiles) {
        this.initConfigLocations(configFiles, null);
    }

    public AbstractTestCase(String name, String[] configFiles) {
        this(name);
        this.initConfigLocations(configFiles, null);
    }

    public AbstractTestCase(String[] configFiles, String[] parentConfigFiles) {
        this.initConfigLocations(configFiles, parentConfigFiles);
    }

    public AbstractTestCase(String name, String[] configFiles, String[] parentConfigFiles) {
        this(name);
        this.initConfigLocations(configFiles, parentConfigFiles);
    }

    public void onSetUpInTransaction() throws Exception {
        SingletonApplicationContext.getInstance().setSingletonContext((ApplicationContext)this.applicationContext);
        String name = TransactionSynchronizationManager.getCurrentTransactionName();
        if (TransactionSynchronizationManager.isActualTransactionActive() && name == null) {
            TransactionSynchronizationManager.setCurrentTransactionName((String)this.getName());
        }
        this.customSetUp();
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected void customSetUp() throws Exception {
    }

    public void onTearDownInTransaction() {
        try {
            this.customTearDown();
        }
        catch (Exception e) {
            this.fail("Unable to tear down data", e);
        }
    }

    protected boolean shouldTestCaseStartTransaction() {
        return true;
    }

    public void setTransactionManager(PlatformTransactionManager ptm) {
        if (this.shouldTestCaseStartTransaction()) {
            super.setTransactionManager(ptm);
        }
    }

    protected void customTearDown() throws Exception {
    }

    private void initConfigLocations(String[] configFiles, String[] parentConfigFiles) {
        System.setProperty("DSKey.store", "config/shared/caip/caipService.jks");
        System.setProperty("myCaipConfig.xml", "config/shared/caip/local/caipConfig.xml");
        System.setProperty("weblogic.Name", "JUnit");
        int parentConfigFilesLength = 0;
        int configFilesLength = 0;
        if (parentConfigFiles != null) {
            parentConfigFilesLength = parentConfigFiles.length;
        }
        if (configFiles != null) {
            configFilesLength = configFiles.length;
        }
        String[] completeSetOfConfigFiles = new String[parentConfigFilesLength + configFilesLength];
        int index = 0;
        int i = 0;
        while (i < parentConfigFilesLength) {
            completeSetOfConfigFiles[index++] = parentConfigFiles[i++];
        }
        i = 0;
        while (i < configFilesLength) {
            completeSetOfConfigFiles[index++] = configFiles[i++];
        }
        this.configLocations = completeSetOfConfigFiles;
    }

    protected void fail(String message, Exception e) {
        e.fillInStackTrace();
        StringBuffer trace = new StringBuffer();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            trace.append("******").append(cause.getMessage()).append(" ").append(cause);
        }
        AbstractTestCase.fail((String)(message + trace.toString()));
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }
}

