/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.ExceptionHandler;
import gov.va.med.fw.util.Reflector;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class AbstractExceptionHandler
extends AbstractComponent
implements ExceptionHandler {
    private boolean continueToHandle = false;
    protected static final String DEFAULT_HANDLER_METHOD_PREFIX = "handle";

    protected AbstractExceptionHandler() {
    }

    @Override
    public Throwable handleException(Throwable exception, String exceptionMessage, Object originator) {
        Throwable[] causes = ExceptionUtils.getThrowables((Throwable)exception);
        for (int i = 0; i < causes.length; ++i) {
            String exceptionName = ClassUtils.getShortClassName(causes[i].getClass());
            StringBuffer methodName = new StringBuffer(DEFAULT_HANDLER_METHOD_PREFIX);
            methodName.append(exceptionName);
            try {
                Reflector.invoke(this, methodName.toString(), new Object[]{exception, exceptionMessage, originator});
                if (this.isContinueToHandle()) continue;
                break;
            }
            catch (InvocationTargetException e) {
                if (this.isContinueToHandle()) continue;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return exception;
    }

    public boolean isContinueToHandle() {
        return this.continueToHandle;
    }

    public void setContinueToHandle(boolean continueToHandle) {
        this.continueToHandle = continueToHandle;
    }
}

