/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.util.GenericExceptionHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class AbstractChainExceptionHandler
extends GenericExceptionHandler {
    private String exceptionName = null;

    protected AbstractChainExceptionHandler() {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((String)this.exceptionName)) {
            throw new ServiceConfigurationException("Missing required exception name to handle");
        }
    }

    public Exception handleException(Exception exception, String message, Object originator) {
        Throwable[] causes = ExceptionUtils.getThrowables((Throwable)exception);
        for (int i = 0; i < causes.length; ++i) {
            Throwable cause = causes[i];
            if (!cause.getClass().getName().equals(this.getExceptionName())) continue;
            exception = this.processNestedException(cause, message, originator);
        }
        return exception;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public void setExceptionName(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    protected abstract Exception processNestedException(Throwable var1, String var2, Object var3);
}

