/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.valuelist;

import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.DefaultSelectableResult;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.SelectableResult;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;

public class SelectableSearchValueListAdapter
extends SearchValueListAdapter {
    private static final long serialVersionUID = -8607848154762326203L;
    public static final String SELECTED_REQUEST_ATTRIBUTE_KEY = "selected";

    @Override
    public ValueList getValueList(String name, ValueListInfo info) throws ValueListException, MaxRecordsExceededValueListException {
        Map filterMap = info.getFilters();
        HttpServletRequest request = (HttpServletRequest)filterMap.get(HTTP_REQUEST_KEY);
        HttpSession session = request.getSession();
        String action = SelectableSearchValueListAdapter.getAction(request);
        String RESULTS_SESSION_KEY = this.getResultsSessionKey(filterMap);
        List searchResults = SelectableSearchValueListAdapter.getResultsFromSession(session, RESULTS_SESSION_KEY);
        if ("singlePage".equals(this.getSearchOptimizationType()) && "actionSelect".equals(action)) {
            searchResults = SelectableSearchValueListAdapter.getResultsFromSession(session, this.getPrevPageDataSessionKey(filterMap));
        }
        this.updatePreviousPageSelectedItems(searchResults, action, request, this.getPrevPageSessionKey(filterMap));
        if (!"singlePage".equals(this.getSearchOptimizationType()) || !"actionSelect".equals(action)) {
            ValueList valueList = super.getValueList(name, info);
            searchResults = SelectableSearchValueListAdapter.getResultsFromSession(session, RESULTS_SESSION_KEY);
            this.updatedCurrentPageSelectedItems(info.getPagingPage(), searchResults, request);
            return valueList;
        }
        return null;
    }

    protected void updatePreviousPageSelectedItems(List results, String action, HttpServletRequest request, String prevPageSessionKey) {
        block4: {
            String[] selectedItems;
            HttpSession session;
            block5: {
                session = request.getSession();
                selectedItems = request.getParameterValues(SELECTED_REQUEST_ATTRIBUTE_KEY);
                if (selectedItems == null || results == null || StringUtils.isEmpty((String)action)) break block4;
                if (!action.equals("actionSort") && !action.equals("actionPage")) break block5;
                String checkedList = selectedItems[0];
                StringTokenizer strtok = new StringTokenizer(checkedList, ",");
                int prevPage = SelectableSearchValueListAdapter.getPrevPageFromSession(session, prevPageSessionKey);
                int maxLoop = prevPage * this.getNumberPerPage() > results.size() ? results.size() % this.getNumberPerPage() : this.getNumberPerPage();
                for (int i = 0; i < maxLoop && strtok.hasMoreTokens(); ++i) {
                    SelectableResult selectableResult = (SelectableResult)results.get((prevPage - 1) * this.getNumberPerPage() + i);
                    String isSelected = strtok.nextToken();
                    selectableResult.setSelected(isSelected != null && isSelected.equals("true"));
                }
                break block4;
            }
            if (!action.equals("actionSelect")) break block4;
            HashMap<Integer, String> selectedItemMap = new HashMap<Integer, String>();
            for (int i = 0; i < selectedItems.length; ++i) {
                String selectedItemIndex = selectedItems[i];
                selectedItemMap.put(new Integer(selectedItemIndex), "true");
            }
            int prevPage = SelectableSearchValueListAdapter.getPrevPageFromSession(session, prevPageSessionKey);
            if ("singlePage".equals(this.getSearchOptimizationType()) && "actionSelect".equals(action)) {
                prevPage = 1;
            }
            int maxLoop = prevPage * this.getNumberPerPage() > results.size() ? results.size() % this.getNumberPerPage() : this.getNumberPerPage();
            for (int i = 0; i < maxLoop; ++i) {
                SelectableResult selectableResult = (SelectableResult)results.get((prevPage - 1) * this.getNumberPerPage() + i);
                selectableResult.setSelected(selectedItemMap.get(new Integer(i)) != null);
            }
        }
    }

    protected void updatedCurrentPageSelectedItems(int currentPage, List results, HttpServletRequest request) {
        if (results != null) {
            ArrayList<String> newlySelectedItems = new ArrayList<String>();
            int maxLoop = currentPage * this.getNumberPerPage() > results.size() ? results.size() % this.getNumberPerPage() : this.getNumberPerPage();
            for (int i = 0; i < maxLoop; ++i) {
                SelectableResult selectableResult = (SelectableResult)results.get((currentPage - 1) * this.getNumberPerPage() + i);
                newlySelectedItems.add(selectableResult.isSelected() ? "checked" : "");
            }
            request.setAttribute(SELECTED_REQUEST_ATTRIBUTE_KEY, newlySelectedItems);
        }
    }

    @Override
    protected List performPostQueryProcessing(List results, SearchQueryInfo searchQueryInfo, ValueListInfo info) throws ValueListException {
        ArrayList<DefaultSelectableResult> selectableResults = new ArrayList<DefaultSelectableResult>();
        for (Object result : results) {
            DefaultSelectableResult selectableResult = new DefaultSelectableResult();
            selectableResult.setResult(result);
            selectableResult.setSelected(false);
            selectableResults.add(selectableResult);
        }
        return selectableResults;
    }
}

