/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.valuelist;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.InvalidArgumentException;
import gov.va.med.fw.service.MissingCapabilityException;
import gov.va.med.fw.service.TimeoutServiceException;
import gov.va.med.fw.service.pagination.PaginatedSearchService;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.UIConstants;
import gov.va.med.fw.ui.valuelist.InvalidArgumentValueListException;
import gov.va.med.fw.ui.valuelist.MaxRecordsExceededValueListException;
import gov.va.med.fw.ui.valuelist.MissingCapabilityValueListException;
import gov.va.med.fw.ui.valuelist.TimeoutValueListException;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.InvalidConfigurationException;
import gov.va.med.fw.util.SortElement;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.DefaultListBackedValueList;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListAdapter;
import net.mlw.vlh.ValueListInfo;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.struts.action.ActionForm;
import org.springframework.web.context.WebApplicationContext;

public class SearchValueListAdapter
extends AbstractEntity
implements ValueListAdapter,
UIConstants {
    private static final long serialVersionUID = -942293536461694530L;
    private InheritableThreadLocal adapterTypeThreadLocal = new InheritableThreadLocal();
    private static final String CLASS_NAME = SearchValueListAdapter.class.getName();
    public static final String FORM_KEY = CLASS_NAME + "formKey";
    public static final String HTTP_REQUEST_KEY = CLASS_NAME + "httpRequestKey";
    public static final String TABLE_ID_KEY = CLASS_NAME + "tableIdKey";
    public static final String SORT_ELEMENTS_KEY = CLASS_NAME + "sortElements";
    public static final String RESULTS_KEY = CLASS_NAME + "results";
    public static final String PREV_PAGE_KEY = CLASS_NAME + "prevPage";
    public static final String PREV_PAGE_RESULTS_KEY = CLASS_NAME + "prevPageResults";
    public String SEARCH_DATA_OPTIMIZED = "dataOptimized";
    public String SEARCH_READ_ALL = "readAll";
    public String SEARCH_SINGLE_PAGE = "singlePage";
    private String searchOptimizationType = this.SEARCH_DATA_OPTIMIZED;
    private int numberPerPage = Integer.MAX_VALUE;
    private int maxAllowedRecords = Integer.MAX_VALUE;
    private List defaultSortElements = null;
    private boolean caseSensitive = false;
    private boolean defaultActionSearch = true;
    private boolean removeEmptyStrings = false;
    private int maxInMemoryEstimatedResultsSizeInBytes = -1;
    private int maxSortColumns = 1;
    private PaginatedSearchService paginatedSearchService;
    private String searchQueryInfoBeanName = null;

    public ValueList getValueList(String name, ValueListInfo info) throws ValueListException, MaxRecordsExceededValueListException, MissingCapabilityValueListException, TimeoutValueListException, InvalidArgumentValueListException {
        try {
            Integer prevPage;
            String action;
            Log logger = this.getLogger();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting value list for adapter \"" + name + "\"."));
            }
            if (info.getPagingNumberPer() == Integer.MAX_VALUE || info.getPagingNumberPer() <= 0) {
                info.setPagingNumberPer(this.numberPerPage);
            }
            Map filterMap = info.getFilters();
            String SORT_ELEMENTS_SESSION_KEY = this.getSortElementsSessionKey(filterMap);
            String RESULTS_SESSION_KEY = this.getResultsSessionKey(filterMap);
            String PREV_PAGE_SESSION_KEY = this.getPrevPageSessionKey(filterMap);
            String PREV_PAGE_DATA_SESSION_KEY = this.getPrevPageDataSessionKey(filterMap);
            HttpServletRequest request = (HttpServletRequest)filterMap.get(HTTP_REQUEST_KEY);
            HttpSession session = request.getSession();
            String string = action = this.defaultActionSearch ? "actionSearch" : "actionNone";
            if (SearchValueListAdapter.getAction(request) != null) {
                action = SearchValueListAdapter.getAction(request);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performing action: \"" + action + "\"."));
            }
            if ((prevPage = SearchValueListAdapter.getPrevPageFromSession(session, PREV_PAGE_SESSION_KEY)) != null && !action.equals("actionSearch") && !action.equals("actionPage")) {
                info.setPagingPage(prevPage.intValue());
            }
            boolean resultsCached = false;
            List searchResults = SearchValueListAdapter.getResultsFromSession(session, RESULTS_SESSION_KEY);
            if (searchResults != null) {
                resultsCached = true;
                info.setTotalNumberOfEntries(searchResults.size());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Previous results found in cache flag: \"" + resultsCached + "\"."));
            }
            boolean inMemorySortRequired = false;
            List sortElements = this.getSortElements(info, session, SORT_ELEMENTS_SESSION_KEY);
            if (action.equals("actionSearch") || !resultsCached) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"We need to retrieve new data.");
                }
                ActionForm form = (ActionForm)filterMap.get(FORM_KEY);
                SearchQueryInfo searchQueryInfo = this.getSearchQueryInfo(request, info, form, action, sortElements);
                searchResults = this.paginatedSearchService.search(searchQueryInfo);
                searchResults = this.performPostQueryProcessing(searchResults, searchQueryInfo, info);
                if (!searchQueryInfo.getSortPerformed()) {
                    inMemorySortRequired = true;
                }
                info.setTotalNumberOfEntries(searchQueryInfo.getTotalNumberOfEntries());
                if (searchQueryInfo.getSearchTypePerformed() == null) {
                    throw new ValueListException("Paginated Search Service did not specify what type of search was performed.");
                }
                if (searchQueryInfo.getSearchTypePerformed().equals("readAll")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"All the results were retrieved so the data will be cached.");
                    }
                    SearchValueListAdapter.setResultsInSession(session, RESULTS_SESSION_KEY, searchResults);
                    resultsCached = true;
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"All the results were not retrieved so the data will NOT be cached.");
                    }
                    if ("singlePage".equals(this.getSearchOptimizationType())) {
                        SearchValueListAdapter.setResultsInSession(session, PREV_PAGE_DATA_SESSION_KEY, searchResults);
                    }
                    SearchValueListAdapter.setResultsInSession(session, RESULTS_SESSION_KEY, null);
                    resultsCached = false;
                }
            } else if (action.equals("actionSort")) {
                inMemorySortRequired = true;
            }
            if (inMemorySortRequired) {
                this.performSort(searchResults, sortElements);
            }
            this.setAdapterType(0);
            if (resultsCached) {
                this.setAdapterType(2);
            }
            ValueList returnValueList = SearchValueListAdapter.getListBackedValueList(info, searchResults);
            if (SORT_ELEMENTS_SESSION_KEY != null) {
                SearchValueListAdapter.setSortElementsInSession(session, SORT_ELEMENTS_SESSION_KEY, sortElements);
            }
            SearchValueListAdapter.setPrevPageInSession(session, PREV_PAGE_SESSION_KEY, new Integer(info.getPagingPage()));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Current Sort Order: " + sortElements));
                logger.debug((Object)("Finished getting value list for adapter \"" + name + "\"."));
            }
            return returnValueList;
        }
        catch (MaxRecordsExceededException ex) {
            throw new MaxRecordsExceededValueListException(ex.getTotalRecords(), ex.getRecordLimit(), ex.getMessage(), ex);
        }
        catch (MissingCapabilityException ex) {
            throw new MissingCapabilityValueListException(ex.getMessage(), ex.getMissingCapability(), ex);
        }
        catch (TimeoutServiceException ex) {
            throw new TimeoutValueListException(ex.getMessage(), ex);
        }
        catch (InvalidArgumentException ex) {
            throw new InvalidArgumentValueListException(ex.getMessage(), ex);
        }
        catch (Exception ex) {
            throw new ValueListException("An error occurred while attempting to get ValueList data.", ex);
        }
    }

    protected SearchQueryInfo getSearchQueryInfo(HttpServletRequest request, ValueListInfo valueListInfo, ActionForm form, String searchAction, List sortElements) throws ValueListException {
        WebApplicationContext ac = DelegatingActionUtils.findRequiredWebApplicationContext(request.getSession().getServletContext());
        Object beanComponent = ac.getBean(this.searchQueryInfoBeanName);
        if (!(beanComponent instanceof SearchQueryInfo)) {
            throw new ValueListException("The bean with name '" + this.searchQueryInfoBeanName + "' is of type '" + beanComponent.getClass().getName() + "' and must be of type '" + SearchQueryInfo.class.getName() + "'.");
        }
        SearchQueryInfo searchQueryInfo = (SearchQueryInfo)beanComponent;
        searchQueryInfo.setSearchOptimizationType(this.searchOptimizationType);
        searchQueryInfo.setNumberPerPage(this.numberPerPage);
        searchQueryInfo.setRemoveEmptyStrings(this.removeEmptyStrings);
        searchQueryInfo.setCaseSensitive(this.caseSensitive);
        searchQueryInfo.setPagingPage(valueListInfo.getPagingPage());
        searchQueryInfo.setSearchAction(searchAction);
        searchQueryInfo.setMaxInMemoryEstimatedResultsSizeInBytes(this.maxInMemoryEstimatedResultsSizeInBytes);
        searchQueryInfo.setMaxAllowedRecords(this.maxAllowedRecords);
        searchQueryInfo.setSortElements(sortElements);
        Map filterMap = valueListInfo.getFilters();
        searchQueryInfo.setResults((List)filterMap.get(RESULTS_KEY));
        this.populateFormAttributes(form, searchQueryInfo);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("SearchQueryInfo details: " + searchQueryInfo));
        }
        return searchQueryInfo;
    }

    protected void populateFormAttributes(ActionForm form, SearchQueryInfo searchQueryInfo) throws ValueListException {
        try {
            if (form != null) {
                BeanUtils.copyProperties((Object)searchQueryInfo, (Object)form);
            }
        }
        catch (Exception ex) {
            throw new ValueListException("Unable to copy properties from FormBean to SearchQueryInfo.", ex);
        }
    }

    protected List performPostQueryProcessing(List results, SearchQueryInfo searchQueryInfo, ValueListInfo info) throws ValueListException {
        return results;
    }

    protected List getSortElements(ValueListInfo valueListInfo, HttpSession session, String sessionKey) {
        List sortElements = this.getDefaultSortElements();
        if (sessionKey != null && SearchValueListAdapter.getSortElementsFromSession(session, sessionKey) != null) {
            sortElements = SearchValueListAdapter.getSortElementsFromSession(session, sessionKey);
        }
        if (valueListInfo.getSortingColumn() != null && valueListInfo.getSortingColumn().length() > 0) {
            sortElements = this.updateSortElement(sortElements, new SortElement(valueListInfo.getSortingColumn(), valueListInfo.getSortingDirection().equals(ValueListInfo.DESCENDING) ? "desc" : "asc"));
        }
        if (sortElements.size() > this.maxSortColumns) {
            for (int i = sortElements.size(); i > this.maxSortColumns; --i) {
                sortElements.remove(i - 1);
            }
        }
        return sortElements;
    }

    protected List updateSortElement(List sortElements, SortElement sortElement) {
        ArrayList<SortElement> updatedList = new ArrayList<SortElement>();
        updatedList.add(sortElement);
        for (SortElement holdSortElement : sortElements) {
            if (sortElement.hasSameSortColumn(holdSortElement)) continue;
            updatedList.add(holdSortElement);
        }
        return updatedList;
    }

    protected void performSort(List results, List sortElements) {
        if (sortElements != null && sortElements.size() > 0 && results != null && results.size() > 0) {
            ComparatorChain chain = new ComparatorChain();
            for (SortElement sortElement : sortElements) {
                chain.addComparator((Comparator)new BeanComparator(sortElement.getSortColumn(), (Comparator)new NullComparator()), sortElement.getSortDirection().equals("desc"));
            }
            Collections.sort(results, chain);
        }
    }

    public void afterPropertiesSet() throws InvalidConfigurationException {
        if (this.paginatedSearchService == null) {
            throw new InvalidConfigurationException("The paginated search service must be set.");
        }
        if (this.searchQueryInfoBeanName == null) {
            throw new InvalidConfigurationException("The search query info bean name must be set.");
        }
    }

    protected String getSortElementsSessionKey(Map filterMap) {
        return (String)filterMap.get(TABLE_ID_KEY) + SORT_ELEMENTS_KEY;
    }

    protected String getResultsSessionKey(Map filterMap) {
        return (String)filterMap.get(TABLE_ID_KEY) + RESULTS_KEY;
    }

    protected String getPrevPageSessionKey(Map filterMap) {
        return (String)filterMap.get(TABLE_ID_KEY) + PREV_PAGE_KEY;
    }

    protected String getPrevPageDataSessionKey(Map filterMap) {
        return (String)filterMap.get(TABLE_ID_KEY) + PREV_PAGE_RESULTS_KEY;
    }

    public static void setSortElementsInSession(HttpSession session, String sortElementsSessionKey, List sortElements) {
        session.setAttribute(sortElementsSessionKey, (Object)sortElements);
    }

    public static void setResultsInSession(HttpSession session, String resultsSessionKey, List results) {
        session.setAttribute(resultsSessionKey, null);
        session.setAttribute(resultsSessionKey, (Object)results);
    }

    public static void setPrevPageInSession(HttpSession session, String prevPageSessionKey, Integer prevPage) {
        session.setAttribute(prevPageSessionKey, (Object)prevPage);
    }

    public static List getSortElementsFromSession(HttpSession session, String sortElementsSessionKey) {
        return (List)session.getAttribute(sortElementsSessionKey);
    }

    public static List getResultsFromSession(HttpSession session, String resultsSessionKey) {
        return (List)session.getAttribute(resultsSessionKey);
    }

    public static Integer getPrevPageFromSession(HttpSession session, String prevPageSessionKey) {
        return (Integer)session.getAttribute(prevPageSessionKey);
    }

    public static String getAction(HttpServletRequest request) {
        String action = (String)request.getAttribute("callerKey");
        if (StringUtils.isEmpty((String)action)) {
            action = request.getParameter("callerKey");
        }
        return action;
    }

    public static void setAction(HttpServletRequest request, String action) {
        request.setAttribute("callerKey", (Object)action);
    }

    public static ValueList getListBackedValueList(ValueListInfo info, List list) {
        return new DefaultListBackedValueList(list, info);
    }

    public int getAdapterType() {
        Integer adapterTypeInteger = (Integer)this.adapterTypeThreadLocal.get();
        return adapterTypeInteger == null ? 0 : adapterTypeInteger;
    }

    public void setAdapterType(int adapterType) {
        this.adapterTypeThreadLocal.set(new Integer(adapterType));
    }

    public void setNumberPerPage(int numberPerPage) {
        this.numberPerPage = numberPerPage;
    }

    public int getNumberPerPage() {
        return this.numberPerPage;
    }

    public void setDefaultSortElements(List defaultSortElements) {
        this.defaultSortElements = defaultSortElements;
    }

    public List getDefaultSortElements() {
        if (this.defaultSortElements == null) {
            this.defaultSortElements = new ArrayList();
        }
        return this.defaultSortElements;
    }

    public boolean getRemoveEmptyStrings() {
        return this.removeEmptyStrings;
    }

    public void setRemoveEmptyStrings(boolean removeEmptyStrings) {
        this.removeEmptyStrings = removeEmptyStrings;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isDefaultActionSearch() {
        return this.defaultActionSearch;
    }

    public void setDefaultActionSearch(boolean defaultActionSearch) {
        this.defaultActionSearch = defaultActionSearch;
    }

    public void setSearchOptimizationType(String searchOptimizationType) {
        this.searchOptimizationType = searchOptimizationType;
    }

    public String getSearchOptimizationType() {
        return this.searchOptimizationType;
    }

    public void setMaxInMemoryEstimatedResultsSizeInBytes(int bytes) {
        this.maxInMemoryEstimatedResultsSizeInBytes = bytes;
    }

    public int getMaxInMemoryEstimatedResultsSizeInBytes() {
        return this.maxInMemoryEstimatedResultsSizeInBytes;
    }

    public void setPaginatedSearchService(PaginatedSearchService paginatedSearchService) {
        this.paginatedSearchService = paginatedSearchService;
    }

    public PaginatedSearchService getPaginatedSearchService() {
        return this.paginatedSearchService;
    }

    public void setSearchQueryInfoBeanName(String searchQueryInfoBeanName) {
        this.searchQueryInfoBeanName = searchQueryInfoBeanName;
    }

    public String getSearchQueryInfoBeanName() {
        return this.searchQueryInfoBeanName;
    }

    public int getMaxAllowedRecords() {
        return this.maxAllowedRecords;
    }

    public void setMaxAllowedRecords(int maxAllowedRecords) {
        this.maxAllowedRecords = maxAllowedRecords;
    }

    public int getMaxSortColumns() {
        return this.maxSortColumns;
    }

    public void setMaxSortColumns(int maxSortColumns) {
        this.maxSortColumns = maxSortColumns;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("adapterType", this.getAdapterType());
        builder.append("numberPerPage", this.getNumberPerPage());
        builder.append("defaultSortElements", (Object)this.getDefaultSortElements());
        builder.append("removeEmptyStrings", this.getRemoveEmptyStrings());
        builder.append("caseSensitive", this.getCaseSensitive());
        builder.append("searchOptimizationType", (Object)this.getSearchOptimizationType());
        builder.append("maxInMemoryEstimatedResultsSizeInBytes", this.getMaxInMemoryEstimatedResultsSizeInBytes());
        builder.append("paginatedSearchService", (Object)this.getPaginatedSearchService());
        builder.append("searchQueryInfoBeanName", (Object)this.getSearchQueryInfoBeanName());
        builder.append("maxAllowedRecords", this.getMaxAllowedRecords());
        builder.append("maxSortColumns", this.getMaxSortColumns());
    }
}

