/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.filter;

import gov.va.med.fw.security.EncryptionServiceException;
import gov.va.med.fw.security.KeyCache;
import gov.va.med.fw.ui.security.UIEncryptionService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DecryptedRequest
extends HttpServletRequestWrapper
implements KeyCache {
    public static final String SESSION_SECRET_KEY = "SESSION_SECRET_KEY";
    protected Map parameterMap;
    protected String queryString;
    protected Log logger = LogFactory.getLog(this.getClass());

    public DecryptedRequest(HttpServletRequest request) {
        super(request);
        this.queryString = super.getQueryString();
        this.parameterMap = super.getParameterMap();
    }

    public DecryptedRequest(HttpServletRequest request, UIEncryptionService encryptionService) throws EncryptionServiceException {
        super(request);
        this.queryString = request.getQueryString();
        this.parameterMap = super.getParameterMap();
        if (encryptionService != null && encryptionService.isEncryptionEnabled() && this.getKey() != null) {
            DecryptedRequest tmpRequest = new DecryptedRequest(request);
            this.parameterMap = this.decryptHiddenFields((HttpServletRequest)tmpRequest, encryptionService);
            String encryptedQueryString = request.getParameter("encry");
            if (StringUtils.isNotEmpty((String)encryptedQueryString)) {
                this.decryptQueryString((HttpServletRequest)tmpRequest, encryptedQueryString, this.parameterMap, encryptionService);
            }
        }
        if (this.parameterMap == null) {
            this.parameterMap = new Hashtable();
        }
        this.parameterMap = Collections.unmodifiableMap(this.parameterMap);
    }

    @Override
    public SecretKey getKey() {
        HttpSession session = this.getSession(true);
        return (SecretKey)session.getAttribute(SESSION_SECRET_KEY);
    }

    @Override
    public void setKey(SecretKey key) {
        HttpSession session = this.getSession(true);
        session.setAttribute(SESSION_SECRET_KEY, (Object)key);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getParameter(String name) {
        String value = null;
        try {
            String[] values = (String[])this.getParameterMap().get(name);
            if (values != null) {
                value = values[0];
            }
        }
        catch (Exception ignore) {
            value = null;
        }
        return value;
    }

    public Enumeration getParameterNames() {
        Map map = this.getParameterMap();
        if (map == null) {
            return null;
        }
        if (map instanceof Hashtable) {
            return ((Hashtable)map).keys();
        }
        return Collections.enumeration(map.keySet());
    }

    public String[] getParameterValues(String name) {
        try {
            return (String[])this.getParameterMap().get(name);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    private Map decryptHiddenFields(HttpServletRequest request, UIEncryptionService encryptionService) throws EncryptionServiceException {
        Map paramMap = request.getParameterMap();
        Hashtable<String, String[]> tmpMap = new Hashtable<String, String[]>();
        if (paramMap != null || !paramMap.isEmpty()) {
            for (String name : paramMap.keySet()) {
                String[] values = (String[])paramMap.get(name);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        String value = values[i];
                        if (!StringUtils.isNotEmpty((String)value) || !value.startsWith("encry:")) continue;
                        values[i] = value = encryptionService.decrypt((ServletRequest)request, StringUtils.substringAfter((String)value, (String)"encry:"));
                    }
                }
                tmpMap.put(name, values);
            }
        }
        return tmpMap;
    }

    private Map decryptQueryString(HttpServletRequest request, String encryptedQS, Map paramMap, UIEncryptionService encryptionService) throws EncryptionServiceException {
        String decryptedQueryString;
        if (paramMap == null) {
            paramMap = new Hashtable<String, String[]>();
        }
        if (StringUtils.isEmpty((String)(decryptedQueryString = encryptionService.decrypt((ServletRequest)request, encryptedQS)))) {
            throw new EncryptionServiceException("decrypted query string is null.");
        }
        try {
            String characterEncoding = request.getCharacterEncoding();
            if (StringUtils.isEmpty((String)characterEncoding)) {
                characterEncoding = encryptionService.getDefaultCharacterEncoding();
            }
            this.queryString = URLDecoder.decode(decryptedQueryString, characterEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new EncryptionServiceException("unsupported encoding error.", ex);
        }
        if (StringUtils.isEmpty((String)this.queryString)) {
            return paramMap;
        }
        String value = null;
        for (String pair : DecryptedRequest.getTokens(this.queryString)) {
            String[] valArray;
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException("Invalid query string");
            }
            String key = pair.substring(0, pos);
            value = pair.substring(pos + 1, pair.length());
            if (paramMap.containsKey(key)) {
                String[] oldVals = (String[])paramMap.get(key);
                valArray = new String[oldVals.length + 1];
                for (int i = 0; i < oldVals.length; ++i) {
                    valArray[i] = oldVals[i];
                }
                valArray[oldVals.length] = value;
            } else {
                valArray = new String[]{value};
            }
            paramMap.put(key, valArray);
        }
        return paramMap;
    }

    private static List getTokens(String queryString) {
        ArrayList<String> list = new ArrayList<String>();
        String[] tokens = queryString.split("&");
        for (int i = 0; i < tokens.length; ++i) {
            String pair = tokens[i];
            if (!list.isEmpty() && !StringUtils.contains((String)pair, (char)'=')) {
                int lastElementIndex = list.size() - 1;
                String previousPair = (String)list.get(lastElementIndex);
                list.set(lastElementIndex, previousPair + '&' + pair);
                continue;
            }
            list.add(pair);
        }
        return list;
    }
}

