/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.service.transaction.ConfigurableTransactionProxyFactoryBean;
import java.util.Properties;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.apache.commons.lang.Validate;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;

public class SynchronizableTransactionProxyFactoryBean
extends ConfigurableTransactionProxyFactoryBean {
    private static final long serialVersionUID = -5276223151452991790L;
    private Object[] configuredPostInterceptors;
    private NameMatchMethodPointcutAdvisor synchronizationAdvisor;
    private Advice transactionSynchronizationInitializer;

    @Override
    public void setTransactionAttributes(Properties transactionAttributes) {
        super.setTransactionAttributes(transactionAttributes);
        Set transactionalMethods = this.getMethodNamesThatInitiateTransactions();
        if (transactionalMethods.size() > 0) {
            this.synchronizationAdvisor = new NameMatchMethodPointcutAdvisor();
            this.synchronizationAdvisor.setAdvice(this.transactionSynchronizationInitializer);
            this.synchronizationAdvisor.setMappedNames(transactionalMethods.toArray(new String[transactionalMethods.size()]));
            this.initSynchronizationAdvisorAsPostInterceptor();
        }
    }

    private void initSynchronizationAdvisorAsPostInterceptor() {
        Object[] modifiedPostInterceptors = null;
        if (this.configuredPostInterceptors != null) {
            modifiedPostInterceptors = new Object[this.configuredPostInterceptors.length + 1];
            for (int i = 0; i < this.configuredPostInterceptors.length; ++i) {
                modifiedPostInterceptors[i] = this.configuredPostInterceptors[i];
            }
            modifiedPostInterceptors[modifiedPostInterceptors.length - 1] = this.synchronizationAdvisor;
        } else {
            modifiedPostInterceptors = new Object[]{this.synchronizationAdvisor};
        }
        super.setPostInterceptors(modifiedPostInterceptors);
    }

    public void setPostInterceptors(Object[] postInterceptors) {
        this.configuredPostInterceptors = postInterceptors;
        Object[] modifiedPostInterceptors = postInterceptors;
        if (this.synchronizationAdvisor != null) {
            modifiedPostInterceptors = new Object[postInterceptors.length + 1];
            for (int i = 0; i < postInterceptors.length; ++i) {
                modifiedPostInterceptors[i] = postInterceptors[i];
            }
            modifiedPostInterceptors[modifiedPostInterceptors.length - 1] = this.synchronizationAdvisor;
        }
        super.setPostInterceptors(modifiedPostInterceptors);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.transactionSynchronizationInitializer);
    }

    public Advice getTransactionSynchronizationInitializer() {
        return this.transactionSynchronizationInitializer;
    }

    public void setTransactionSynchronizationInitializer(Advice transactionSynchronizationInitializer) {
        this.transactionSynchronizationInitializer = transactionSynchronizationInitializer;
    }
}

