/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.service.AbstractComponent;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RollbackAdvice
extends AbstractComponent
implements MethodInterceptor {
    private Set bypassRollbackSet;

    public Object invoke(MethodInvocation arg0) throws Throwable {
        Object result = null;
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            result = arg0.proceed();
        } else {
            try {
                result = arg0.proceed();
            }
            catch (Throwable t) {
                String currentCallerClass = arg0.getMethod().getDeclaringClass().getName();
                String currentCallerMethod = arg0.getMethod().getName();
                StringBuffer name = new StringBuffer(currentCallerClass);
                name.append(".").append(currentCallerMethod);
                String txName = TransactionSynchronizationManager.getCurrentTransactionName();
                if (StringUtils.isBlank((String)txName) && this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("TransactionSynchronizationManager.isActualTransactionActive() states true, but TransactionSynchronizationManager.getCurrentTransactionName() returns null.  Current caller is: " + name));
                }
                if (name.toString().equalsIgnoreCase(txName) && !this.shouldBypassRollback(t)) {
                    this.rollback(t, txName);
                }
                throw t;
            }
        }
        return result;
    }

    private boolean shouldBypassRollback(Throwable t) {
        if (this.bypassRollbackSet == null) {
            return false;
        }
        Iterator itr = this.bypassRollbackSet.iterator();
        String exceptionClassName = null;
        Class<?> loadedExceptionClass = null;
        try {
            while (itr.hasNext()) {
                exceptionClassName = (String)itr.next();
                loadedExceptionClass = Class.forName(exceptionClassName);
                if (!loadedExceptionClass.isAssignableFrom(t.getClass())) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("Unable to load a class from its name in RollbackAdvice.bypassRollbackSet: " + exceptionClassName), (Throwable)e);
        }
        return false;
    }

    private void rollback(Throwable t, String txName) throws Throwable {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)("Rolling back application transaction named: " + txName));
        }
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
    }

    public Set getBypassRollbackSet() {
        return this.bypassRollbackSet;
    }

    public void setBypassRollbackSet(Set bypassRollbackSet) {
        this.bypassRollbackSet = bypassRollbackSet;
    }
}

