/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.Constants;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public class ConfigurableTransactionProxyFactoryBean
extends TransactionProxyFactoryBean {
    private static final long serialVersionUID = -1945956638456105718L;
    private static final Constants TX_CONSTANTS = new Constants(TransactionDefinition.class);
    private static final String TX_REQUIRED_CONSTANT = TX_CONSTANTS.toCode((Object)new Integer(0), "PROPAGATION");
    private static final String TX_REQUIRES_NEW_CONSTANT = TX_CONSTANTS.toCode((Object)new Integer(3), "PROPAGATION");
    private int transactionTimeout = -1;
    private Set methodNamesThatInitiateTransactions = new HashSet();

    public void setTransactionAttributes(Properties transactionAttributes) {
        this.preProcessTransactionMetadata(transactionAttributes);
        super.setTransactionAttributes(transactionAttributes);
    }

    protected Properties preProcessTransactionMetadata(Properties props) {
        Set<Object> methods = props.keySet();
        Object var3_3 = null;
        String metadata = null;
        for (String string : methods) {
            if (!this.shouldUpdateMetadataForTimeout(string, metadata = (String)props.get(string))) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("### Bean method [" + string + "] - applying tx timeout default of " + this.transactionTimeout));
            }
            metadata = metadata + "," + "timeout_" + this.transactionTimeout;
            props.put(string, metadata);
        }
        return props;
    }

    protected boolean shouldUpdateMetadataForTimeout(String methodName, String metadata) {
        boolean shouldUpdate = false;
        if (metadata != null && (metadata.indexOf(TX_REQUIRED_CONSTANT) >= 0 || metadata.indexOf(TX_REQUIRES_NEW_CONSTANT) >= 0)) {
            this.methodNamesThatInitiateTransactions.add(methodName);
            if (metadata.indexOf("timeout_") == -1) {
                shouldUpdate = true;
            }
        }
        return this.transactionTimeout != -1 ? shouldUpdate : false;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    protected Set getMethodNamesThatInitiateTransactions() {
        return this.methodNamesThatInitiateTransactions;
    }
}

