/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.AbstractMessageDescriptor;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;

public class QueueDescriptor
extends AbstractMessageDescriptor {
    private String queueName = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.queueName == null) {
            throw new ServiceException("Missing properties: factoryName, queueName, providerURL or contextName");
        }
    }

    public void setQueueName(String name) {
        this.queueName = name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public QueueConnectionFactory getConnectionFactory(String providerURL) throws ServiceException {
        return (QueueConnectionFactory)this.getConnectionFactory(providerURL, this.getFactoryName(), QueueConnectionFactory.class);
    }

    public Queue getQueue(String providerURL) throws ServiceException {
        return (Queue)this.getDestination(providerURL, this.getQueueName(), Queue.class);
    }

    public QueueConnection createQueueConnection(String providerURL) throws ServiceException {
        return this.createQueueConnection(this.getConnectionFactory(providerURL));
    }

    public QueueConnection createQueueConnection(QueueConnectionFactory factory) throws ServiceException {
        QueueConnection connection = null;
        try {
            connection = factory.createQueueConnection();
            connection.start();
        }
        catch (JMSException e) {
            throw new ServiceException("Failed to create a connection", e);
        }
        return connection;
    }

    public QueueSession createQueueSession(QueueConnection connection, boolean transacted, int mode) throws ServiceException {
        QueueSession session = null;
        try {
            session = connection.createQueueSession(transacted, mode);
        }
        catch (JMSException e) {
            throw new ServiceException("Failed to create a session", e);
        }
        return session;
    }

    public QueueSession createQueueSession(QueueConnection connection) throws ServiceException {
        return this.createQueueSession(connection, true, 1);
    }
}

