/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.builder.JMSMetaData;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserCredentials;
import gov.va.med.fw.service.ServiceDescriptor;
import gov.va.med.fw.service.jms.SecureMessageWrapper;
import gov.va.med.fw.util.ExceptionHandler;
import gov.va.med.fw.util.ExceptionHandlerFactory;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.lang.reflect.InvocationTargetException;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractMessageDrivenBean;

public class MessageDrivenService
extends AbstractMessageDrivenBean
implements MessageListener {
    private static final long serialVersionUID = 8095918876990648447L;
    public static final String FACTORY_LOCATOR_SELECTOR = "locatorFactorySelector";
    public static final String FACTORY_LOCATOR_KEY = "locatorFactoryKey";
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private LoginManager loginManager;

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        super.setMessageDrivenContext(ctx);
        this.setBeanFactoryLocator(ContextSingletonBeanFactoryLocator.getInstance((String)this.getEnvEntry(FACTORY_LOCATOR_SELECTOR)));
        this.setBeanFactoryLocatorKey(this.getEnvEntry(FACTORY_LOCATOR_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        boolean isLoggedIn = false;
        try {
            if (message.getJMSDeliveryMode() == 1 && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Received a non-persistent JMS Message...if a persistent JMS store is configured, advise sending system to set JMSDeliveryMode to DeliveryMode.PERSISTENT");
            }
            this.preProcessMessage(message);
            String msgType = this.getMessageType(message);
            BeanFactory factory = this.getBeanFactory();
            ServiceDescriptor desc = (ServiceDescriptor)factory.getBean(msgType, ServiceDescriptor.class);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Got a service descriptor " + desc + " to process message " + msgType));
            }
            Object builtPayload = this.processBuilder(desc.getBuilder(), message);
            UserCredentials initiater = null;
            if (builtPayload instanceof SecureMessageWrapper) {
                SecureMessageWrapper secureWrapper = (SecureMessageWrapper)builtPayload;
                builtPayload = secureWrapper.getPayload();
                initiater = secureWrapper.getUserCredentials();
            } else {
                initiater = new UserCredentials();
                initiater.setAnonymous(true);
                initiater.setLogicalID(this.getMessageInitiater(message));
            }
            this.processAuthenticate(initiater);
            isLoggedIn = true;
            this.processServiceInvocation(desc, message, builtPayload);
        }
        catch (Throwable e) {
            this.processException(e, message);
            if (this.shouldFailConsumption(e)) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Failed consumption of JMS Message with exception class: " + e.getClass().getName() + " and message: " + e.getMessage()));
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                if (isLoggedIn) {
                    this.getLoginManager().logout();
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)"MessageDrivenService received a Throwable in the finally clause", t);
            }
        }
    }

    protected boolean shouldFailConsumption(Throwable t) {
        return false;
    }

    private void processAuthenticate(UserCredentials cred) throws LoginException {
        SecurityContextHelper.initSecurityContextOnThread(this.getLoginManager(), cred);
    }

    private LoginManager getLoginManager() {
        if (this.loginManager == null) {
            this.loginManager = (LoginManager)this.getBeanFactory().getBean(ClassUtils.getShortClassName(LoginManager.class), LoginManager.class);
        }
        return this.loginManager;
    }

    public void onEjbRemove() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"In onEjbRemove method");
        }
    }

    public void onEjbCreate() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"In onEjbCreate method");
        }
    }

    protected void preProcessMessage(Message message) {
        if (message == null || !(message instanceof TextMessage) && !(message instanceof BytesMessage) && !(message instanceof ObjectMessage)) {
            this.processException(new InvalidMessageException("Invalid message"), message);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Incoming message: " + message));
        }
    }

    protected void processServiceInvocation(ServiceDescriptor desc, Message message, Object structuredMsg) throws Throwable {
        Object[] params = null;
        try {
            params = structuredMsg instanceof Object[] ? (Object[])structuredMsg : new Object[]{structuredMsg};
            String serviceName = desc.getServiceName();
            String methodName = desc.getMethodName();
            BeanFactory factory = this.getBeanFactory();
            Object service = factory.getBean(serviceName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking Service: " + service.getClass().getName()));
                this.logger.debug((Object)("Service name: " + serviceName));
                this.logger.debug((Object)("Method name: " + methodName));
            }
            Reflector.invoke(service, methodName, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    protected void processException(Throwable e, Object input) {
        block2: {
            try {
                BeanFactory factory = this.getBeanFactory();
                ExceptionHandlerFactory exceptionFactory = (ExceptionHandlerFactory)((Object)factory.getBean(ExceptionHandlerFactory.class.getName()));
                ExceptionHandler handler = exceptionFactory.getExceptionHandler(e.getClass().getName());
                handler.handleException(e, e.getMessage(), input);
            }
            catch (Throwable t) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)"Failed to get an exception handler to process exception ", t);
            }
        }
    }

    protected Object processBuilder(Builder builder, Message jmsMsg) throws IllegalArgumentException, BuilderException {
        if (builder == null || jmsMsg == null) {
            throw new IllegalArgumentException("Missing required parameters (builder/jms message)");
        }
        return builder.build(new JMSMetaData(jmsMsg));
    }

    protected String getMessageType(Message msg) throws InvalidMessageException {
        String type = null;
        try {
            type = msg.getStringProperty(this.getMessageTypeKey());
        }
        catch (JMSException e) {
            throw new InvalidMessageException("Failed to get a message type from a message", e);
        }
        return type;
    }

    protected String getMessageInitiater(Message msg) {
        String initiater;
        block2: {
            initiater = null;
            try {
                initiater = msg.getStringProperty(this.getMessageInitiaterKey());
            }
            catch (JMSException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)"DEFAULT_MESSAGE_INITIATER key is not transfered in a message");
            }
        }
        return initiater;
    }

    protected String getMessageTypeKey() {
        return "Message_Type";
    }

    protected String getMessageInitiaterKey() {
        return "Message_Initiater";
    }

    protected String getEnvEntry(String key) {
        String envEntry = null;
        try {
            InitialContext ctx = new InitialContext();
            envEntry = (String)ctx.lookup("java:comp/env/" + key);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get Environment Entry for: " + key, e);
        }
        return envEntry;
    }
}

