/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;

public class AbstractMessageDescriptor
extends AbstractComponent
implements InitializingBean {
    public static final String URL_PROTOCOL_HEADER = "t3://";
    private String contextName = null;
    private String factoryName = null;
    private Map providerURLtoJndiTemplate = new HashMap();
    private List providerURLs;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.factoryName == null || this.contextName == null || this.providerURLs == null || this.providerURLs.isEmpty()) {
            throw new ServiceException("Missing properties: factoryName, providerURLs or contextName");
        }
    }

    public void setContextName(String name) {
        this.contextName = name;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setFactoryName(String name) {
        this.factoryName = name;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected JndiTemplate getInitialContext(String providerURL) {
        JndiTemplate jndi = (JndiTemplate)this.providerURLtoJndiTemplate.get(providerURL);
        if (jndi == null) {
            Properties data = new Properties();
            data.put("java.naming.factory.initial", this.getContextName());
            data.put("java.naming.provider.url", providerURL);
            jndi = new JndiTemplate(data);
            this.providerURLtoJndiTemplate.put(providerURL, jndi);
        }
        return jndi;
    }

    protected ConnectionFactory getConnectionFactory(String providerURL, String name, Class factoryType) throws ServiceException {
        ConnectionFactory factory = null;
        try {
            factory = (ConnectionFactory)PortableRemoteObject.narrow((Object)this.getInitialContext(providerURL).lookup(name), (Class)factoryType);
        }
        catch (ClassCastException e) {
            throw new ServiceException("Invalid connection factory returned", e);
        }
        catch (NamingException e) {
            throw new ServiceException("Invalid factory name", e);
        }
        return factory;
    }

    protected Destination getDestination(String providerURL, String name, Class destinationType) throws ServiceException {
        Destination destination = null;
        try {
            destination = (Destination)PortableRemoteObject.narrow((Object)this.getInitialContext(providerURL).lookup(name), (Class)destinationType);
        }
        catch (ClassCastException e) {
            throw new ServiceException("Invalid destination returned", e);
        }
        catch (NamingException e) {
            throw new ServiceException("Invalid destination name", e);
        }
        return destination;
    }

    public List getProviderURLs() {
        return this.providerURLs;
    }

    public void setProviderURLs(List providerURLs) {
        this.providerURLs = providerURLs;
    }

    public String getPrimaryProviderURL() {
        return (String)this.providerURLs.get(0);
    }
}

