/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class SingletonApplicationContext {
    private static SingletonApplicationContext instance = null;
    private BeanFactory defaultFactory = null;

    protected SingletonApplicationContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SingletonApplicationContext getInstance() {
        if (instance != null) return instance;
        Class<SingletonApplicationContext> clazz = SingletonApplicationContext.class;
        synchronized (SingletonApplicationContext.class) {
            if (instance != null) return instance;
            instance = new SingletonApplicationContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSingletonContext(ApplicationContext context) {
        SingletonApplicationContext singletonApplicationContext = this;
        synchronized (singletonApplicationContext) {
            this.defaultFactory = context;
        }
    }

    public synchronized ApplicationContext getSingletonContext() throws BeansException {
        BeanFactory factory = this.getSingletonBeanFactory();
        return factory instanceof ApplicationContext ? (ApplicationContext)factory : null;
    }

    public synchronized BeanFactory getSingletonBeanFactory() throws BeansException {
        if (this.defaultFactory == null) {
            throw new NoSuchBeanDefinitionException("A default factory is not set");
        }
        return this.defaultFactory;
    }

    public ApplicationContext getSingletonContext(String selector, String key) throws BeansException {
        BeanFactory bf = this.getSingletonBeanFactory(selector, key);
        return bf instanceof ApplicationContext ? (ApplicationContext)bf : null;
    }

    public BeanFactory getSingletonBeanFactory(String selector, String key) throws BeansException {
        BeanFactoryLocator bl = ContextSingletonBeanFactoryLocator.getInstance((String)selector);
        BeanFactoryReference br = bl.useBeanFactory(key);
        return br.getFactory();
    }
}

