/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.ExceptionHandler;
import gov.va.med.fw.util.ExceptionHandlerFactory;
import org.apache.commons.lang.Validate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;

public abstract class AbstractComponent
extends ApplicationObjectSupport
implements BeanNameAware,
InitializingBean {
    private String name = null;

    protected AbstractComponent() {
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getBeanName() {
        return this.name;
    }

    public Object getComponent(String name) throws ServiceException {
        Object component = null;
        try {
            ApplicationContext context = this.getApplicationContext();
            component = context.getBean(name);
        }
        catch (BeansException e) {
            throw new ServiceException("Failed to get a component by name " + name, e);
        }
        return component;
    }

    public Object getComponent(String name, Class type) throws ServiceException {
        Object component = null;
        try {
            ApplicationContext context = this.getApplicationContext();
            component = context.getBean(name, type);
        }
        catch (BeansException e) {
            throw new ServiceException("Failed to get a component by name " + name + " and type " + type, e);
        }
        return component;
    }

    protected Throwable processException(Exception e, Object obj) {
        Throwable handled;
        block2: {
            handled = e;
            try {
                ExceptionHandlerFactory factory = (ExceptionHandlerFactory)((Object)this.getComponent(ExceptionHandlerFactory.class.getName()));
                ExceptionHandler handler = factory.getExceptionHandler(e.getClass().getName());
                handled = handler.handleException(e, e.getMessage(), obj);
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("failed to find an exeption handler to handle exception " + exception.getClass().getName()));
                this.logger.trace((Object)this, (Throwable)exception);
            }
        }
        return handled;
    }

    protected void finalize() throws Throwable {
        this.name = null;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.name, (String)"A bean name must not be null");
    }
}

