/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.scheduling.ClusterAwareJobDetailBean;
import gov.va.med.fw.scheduling.ImmutableInitTrigger;
import gov.va.med.fw.service.AbstractComponent;
import org.apache.commons.lang.Validate;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SchedulerConfigurator
extends AbstractComponent {
    private Scheduler scheduler = null;
    private Trigger[] triggers = null;
    private JobDetail[] jobDetails = null;
    private boolean overwriteExistingJobs = true;
    private PlatformTransactionManager transactionManager;

    public boolean isOverwriteExistingJobs() {
        return this.overwriteExistingJobs;
    }

    public void setOverwriteExistingJobs(boolean overwriteExistingJobs) {
        this.overwriteExistingJobs = overwriteExistingJobs;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setTriggers(Trigger[] triggers) {
        this.triggers = triggers;
    }

    public void setJobDetails(JobDetail[] jobDetails) {
        this.jobDetails = jobDetails;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.scheduler, (String)"A scheduler is required");
        TransactionStatus transactionStatus = null;
        if (this.transactionManager != null) {
            transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
        try {
            if (this.triggers != null && this.triggers.length > 0) {
                this.scheduleTriggers(this.triggers);
            }
            if (this.jobDetails != null && this.jobDetails.length > 0) {
                this.scheduleJobDetails(this.jobDetails);
            }
        }
        catch (Throwable ex) {
            if (transactionStatus != null) {
                try {
                    this.transactionManager.rollback(transactionStatus);
                }
                catch (TransactionException tex) {
                    this.logger.error((Object)"Job registration exception overridden by rollback exception", ex);
                    throw tex;
                }
            }
            if (ex instanceof SchedulerException) {
                throw (SchedulerException)ex;
            }
            if (ex instanceof Exception) {
                throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage(), (Exception)ex);
            }
            throw new SchedulerException("Registration of jobs and triggers failed: " + ex.getMessage());
        }
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
        }
    }

    protected void scheduleTriggers(Trigger[] triggers) throws SchedulerException {
        Trigger trigger = null;
        JobDetail jobDetail = null;
        for (int i = 0; i < triggers.length; ++i) {
            trigger = triggers[i];
            jobDetail = trigger instanceof JobDetailAwareTrigger ? ((JobDetailAwareTrigger)trigger).getJobDetail() : null;
            Trigger existingTrigger = this.scheduler.getTrigger(trigger.getName(), trigger.getGroup());
            int existingTriggerStatus = this.scheduler.getTriggerState(trigger.getName(), trigger.getGroup());
            if (existingTrigger == null) {
                if (jobDetail != null) {
                    this.addJobDetailToScheduler(jobDetail);
                }
                try {
                    this.scheduler.scheduleJob(trigger);
                }
                catch (JobPersistenceException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Unexpectedly found existing job, assumably due to cluster race condition", (Throwable)e);
                    }
                    if (!this.overwriteExistingJobs || trigger instanceof ImmutableInitTrigger) continue;
                    this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                }
                continue;
            }
            if (!this.overwriteExistingJobs || trigger instanceof ImmutableInitTrigger || existingTriggerStatus == 1) continue;
            if (jobDetail != null) {
                this.addJobDetailToScheduler(jobDetail);
            }
            this.scheduler.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
        }
    }

    protected void scheduleJobDetails(JobDetail[] jobDetails) throws SchedulerException {
        for (int i = 0; i < this.triggers.length; ++i) {
            this.addJobDetailToScheduler(jobDetails[i]);
        }
    }

    private void addJobDetailToScheduler(JobDetail job) throws SchedulerException {
        block6: {
            if (this.scheduler.getJobDetail(job.getName(), job.getGroup()) != null) {
                if (this.overwriteExistingJobs && !(job instanceof ClusterAwareJobDetailBean)) {
                    this.scheduler.addJob(job, this.overwriteExistingJobs);
                }
            } else {
                try {
                    boolean overwrite = !job.isDurable() ? true : job.isDurable();
                    this.scheduler.addJob(job, overwrite);
                }
                catch (SchedulerException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Unexpectedly found existing job, assumably due to cluster race condition", (Throwable)e);
                    }
                    if (!this.overwriteExistingJobs || job instanceof ClusterAwareJobDetailBean) break block6;
                    this.scheduler.addJob(job, true);
                }
            }
        }
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

