/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import java.util.Date;
import org.quartz.Calendar;
import org.springframework.scheduling.quartz.CronTriggerBean;

public class CustomCronTriggerBean
extends CronTriggerBean {
    private static final long serialVersionUID = 1766902112808867367L;
    private int MISFIRE_INSTRUCTION_SMART_POLICY_WITHIN_HOUR = 2001;
    private int MISFIRE_INSTRUCTION_SMART_POLICY_WITHIN_HALFTIME_OF_NEXT_FIRE = 2002;
    private int defaultMisfireInstuctionSmartPolicy = this.MISFIRE_INSTRUCTION_SMART_POLICY_WITHIN_HOUR;

    public void updateAfterMisfire(Calendar cal) {
        int instr = this.getMisfireInstruction();
        if (instr == 0) {
            instr = 2;
            Date now = new Date();
            Date fireTimeThatMisfired = super.getNextFireTime();
            if (this.defaultMisfireInstuctionSmartPolicy == this.MISFIRE_INSTRUCTION_SMART_POLICY_WITHIN_HALFTIME_OF_NEXT_FIRE) {
                Date nextFireTime = super.getFireTimeAfter(fireTimeThatMisfired);
                long spanTime = nextFireTime.getTime() - fireTimeThatMisfired.getTime();
                if ((double)spanTime / 2.0 > (double)(now.getTime() - fireTimeThatMisfired.getTime())) {
                    instr = 1;
                }
            } else if (this.defaultMisfireInstuctionSmartPolicy == this.MISFIRE_INSTRUCTION_SMART_POLICY_WITHIN_HOUR && now.getTime() - fireTimeThatMisfired.getTime() < 3600000L) {
                instr = 1;
            }
        }
        if (instr == 2) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.setNextFireTime(newFireTime);
        } else if (instr == 1) {
            this.setNextFireTime(new Date());
        }
    }

    public int getDefaultMisfireInstuctionSmartPolicy() {
        return this.defaultMisfireInstuctionSmartPolicy;
    }

    public void setDefaultMisfireInstuctionSmartPolicy(int defaultMisfireInstuctionSmartPolicy) {
        this.defaultMisfireInstuctionSmartPolicy = defaultMisfireInstuctionSmartPolicy;
    }
}

