/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import ilog.rules.engine.IlrExceptionHandler;
import ilog.rules.engine.IlrUserRuntimeException;
import java.lang.reflect.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleExceptionHandler
implements IlrExceptionHandler {
    private static final long serialVersionUID = 5121662021596048477L;
    protected Log logger = LogFactory.getLog(this.getClass());
    private String ruleFlowName = null;

    public boolean handleException(IlrUserRuntimeException e) {
        boolean handled = false;
        if (e.isInActions()) {
            this.processActionException(e);
        } else if (e.isInConditions()) {
            handled = this.processConditionException(e);
        } else {
            this.processInternalException(e);
        }
        return handled;
    }

    public String getRuleFlowName() {
        return this.ruleFlowName;
    }

    public void setRuleFlowName(String ruleFlowName) {
        this.ruleFlowName = ruleFlowName;
    }

    protected boolean processConditionException(IlrUserRuntimeException e) {
        this.logException(e);
        return false;
    }

    protected void processActionException(IlrUserRuntimeException e) {
        this.logException(e);
        throw e;
    }

    protected void processInternalException(IlrUserRuntimeException e) {
        this.logException(e);
        throw e;
    }

    protected void logException(IlrUserRuntimeException e) {
        if (this.logger.isDebugEnabled()) {
            Member member = e.getTargetMember();
            String name = member != null ? member.getName() : null;
            Throwable target = e.getTargetException();
            String targetName = target != null ? target.getClass().getName() : null;
            this.logger.debug((Object)("An exception occured in a rule flow: " + this.getRuleFlowName()));
            this.logger.debug((Object)("An exception occured in a rule: " + name));
            this.logger.debug((Object)("A root cause exception: " + targetName));
            this.logger.debug((Object)("Exception details: " + e.getMessage()), (Throwable)e);
        }
        throw e;
    }
}

