/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.AbstractRuleFlowAwareService;
import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.rule.RuleState;
import gov.va.med.fw.rule.RuleValidationException;
import gov.va.med.fw.rule.SimpleValidatableRule;
import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.Validatable;
import gov.va.med.fw.validation.ValidationFieldMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationService;

public abstract class AbstractRuleValidationService
extends AbstractRuleFlowAwareService
implements ValidationService {
    protected AbstractRuleValidationService() {
    }

    @Override
    public ValidationMessages validate(Validatable input) throws ServiceException {
        ValidationMessages messages = new ValidationMessages();
        if (input instanceof SimpleValidatableRule) {
            RuleParameters params = ((SimpleValidatableRule)input).getRuleParameters();
            RuleDataAware data = ((SimpleValidatableRule)input).getRuleDataAware();
            this.setExhaustiveMode(params, "EXHAUSTIVE".equals(input.getValidationMode()));
            RuleState state = params.getState();
            try {
                this.getRuleFlow().execute(params, data);
                if (state != null && state.isExhaustiveMode()) {
                    messages = state.getValidationMessages();
                }
            }
            catch (RuleConfigurationException e) {
                throw new ServiceConfigurationException("A validation rule flow was not configured properly", e);
            }
            catch (RuleException e) {
                if (e.getCause() instanceof RuleValidationException) {
                    String id = e.getMessageID();
                    Object field = e.getOriginator();
                    ValidationFieldMessage msg = new ValidationFieldMessage(field != null ? field.toString() : null, id);
                    msg.setCreateWkList(((RuleValidationException)e).isCreateWkList());
                    messages.add(msg);
                }
                throw new ServiceException("An unexpected error occurred", e);
            }
        }
        return messages;
    }
}

