/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.jasperreport.data;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.report.data.ReportDataIterator;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import org.apache.commons.beanutils.PropertyUtils;

public class JasperReportDataSource
extends JRAbstractBeanDataSource
implements Serializable {
    private static final long serialVersionUID = -6932405518646356851L;
    private ReportDataIterator dataIterator = null;
    private int index = 0;
    private Object bean = null;
    private Map metaData = null;
    private ReportConfiguration configuration = null;
    private boolean useFieldDescription = false;

    public JasperReportDataSource(ReportDataIterator iterator, Map metaData, ReportConfiguration config) {
        this(iterator, metaData, config, false);
    }

    public JasperReportDataSource(ReportDataIterator dataIterator, Map metaData, ReportConfiguration config, boolean useFieldDescription) {
        super(useFieldDescription);
        this.metaData = metaData;
        this.dataIterator = dataIterator;
        this.useFieldDescription = useFieldDescription;
        this.configuration = config;
    }

    public JasperReportDataSource getSubDataSource(Object key, Object data) {
        QueryCriteria criteria;
        JasperReportDataSource subDataSource = null;
        QueryCriteria queryCriteria = criteria = this.configuration != null ? this.configuration.getQueryCriteria() : null;
        if (criteria != null) {
            QueryCriteria subCriteria = new QueryCriteria();
            subCriteria.addCriterion(key, data);
            criteria.setSubReportCriteria(subCriteria);
            ReportDataIterator iterator = new ReportDataIterator(this.dataIterator.getReportDAO(), this.configuration);
            subDataSource = new JasperReportDataSource(iterator, this.metaData, this.configuration, this.useFieldDescription);
        }
        return subDataSource;
    }

    public boolean next() throws JRException {
        try {
            this.bean = this.dataIterator.getRecord(this.index++);
            return this.bean != null;
        }
        catch (ReportDataException e) {
            throw new JRException("Failed to check for a next record", (Throwable)e);
        }
    }

    public void moveFirst() throws JRException {
        try {
            this.index = 0;
            this.bean = this.dataIterator.getRecord(this.index);
        }
        catch (ReportDataException e) {
            throw new JRException("Failed to set to a first record", (Throwable)e);
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value;
        block12: {
            value = null;
            if (this.bean != null) {
                String propertyName = this.getPropertyNameByField(field);
                try {
                    if (this.bean instanceof Map) {
                        value = ((Map)this.bean).get(propertyName);
                    } else if (this.bean instanceof Object[]) {
                        Integer index;
                        if (this.metaData == null || this.metaData.isEmpty()) {
                            throw new JRException("Missing a meta data map to retrieve value for property: " + propertyName);
                        }
                        Object meta = this.metaData.get(propertyName);
                        Integer n = index = meta instanceof Integer ? (Integer)meta : null;
                        if (index != null) {
                            value = ((Object[])this.bean)[index];
                        }
                    } else {
                        value = PropertyUtils.getProperty((Object)this.bean, (String)propertyName);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw new JRException("Error retrieving field value from bean : " + propertyName, (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().startsWith("Null property value for ")) break block12;
                    throw e;
                }
            }
        }
        return value;
    }

    private String getPropertyNameByField(JRField field) {
        return this.useFieldDescription ? field.getDescription() : field.getName();
    }
}

