/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.data;

import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.PostProcessedList;
import gov.va.med.fw.report.data.ReportDataDAO;
import gov.va.med.fw.report.data.ReportDataException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ReportDataIterator
implements Serializable {
    private static final long serialVersionUID = -4365696853678795611L;
    private static final int PAGE_SIZE = 50;
    private ReportConfiguration reportConfig = null;
    private ReportDataDAO reportDAO = null;
    private List resultPage = null;
    private int pageStart = Integer.MAX_VALUE;
    private int pageEnd = Integer.MIN_VALUE;
    private int pageSize = 50;
    private int resultPageDelta = 0;

    public ReportDataIterator(ReportDataDAO dao, ReportConfiguration config) {
        this(dao, config, 50);
    }

    public ReportDataIterator(ReportDataDAO dao, ReportConfiguration config, int pageSize) {
        this.reportDAO = dao;
        this.reportConfig = config;
        this.pageSize = pageSize;
    }

    public final Object getRecord(int index) throws ReportDataException {
        if (this.resultPage == null || index < this.pageStart || index > this.pageEnd) {
            this.resultPage = this.getRecords(index, this.pageSize);
        }
        Object result = null;
        int pos = index - this.pageStart;
        if (this.resultPage != null && this.resultPage.size() > pos) {
            result = this.resultPage.get(pos);
        }
        return result;
    }

    public List getRecords(int firstRecord, int maxRecords) throws ReportDataException {
        List queryResults = this.getReportDAO().getRecords(this.getReportConfiguration(), firstRecord + this.resultPageDelta, maxRecords);
        if (this.resultPage == null) {
            this.resultPage = new ArrayList(queryResults.size());
        }
        this.resultPage.clear();
        for (int i = 0; i < queryResults.size(); ++i) {
            this.resultPage.add(queryResults.get(i));
        }
        this.resultPageDelta = queryResults instanceof PostProcessedList ? ((PostProcessedList)queryResults).getDeltaInSize() : 0;
        this.pageStart = firstRecord;
        this.pageEnd = firstRecord + queryResults.size() - 1;
        return this.resultPage;
    }

    public ReportDataDAO getReportDAO() {
        return this.reportDAO;
    }

    public ReportConfiguration getReportConfiguration() {
        return this.reportConfig;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

