/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.security.UserPrincipal;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ReportConfiguration
implements Serializable {
    public static final String DEFAULT_REPORT_TITLE = "Enrollment System Report";
    private static final long serialVersionUID = 7728613580938640380L;
    private ReportExportedType.Code reportOutputType = null;
    private String reportTitle = null;
    private String reportName = null;
    private String reportID = null;
    private String reportOutputName = null;
    private Map resourceMapping = null;
    private QueryCriteria queryCriteria = null;
    private UserPrincipal reportUser = null;

    public ReportConfiguration(String name, String ID) throws IOException {
        this(name, ID, ReportExportedType.PDF);
    }

    public ReportConfiguration(String name, String ID, ReportExportedType.Code type) throws IOException {
        this(name, ID, type, ReportConfiguration.getDefaultOutputFileName(name, ID, type));
    }

    public ReportConfiguration(String name, String ID, ReportExportedType.Code type, String output) throws IOException {
        Validate.notNull((Object)name, (String)"A report name must not be NULL");
        Validate.notNull((Object)ID, (String)"A report ID must not be NULL");
        Validate.notNull((Object)((Object)type), (String)"A report type must not be NULL");
        Validate.notNull((Object)output, (String)"A report output stream must not be NULL");
        this.reportName = name;
        this.reportID = ID;
        this.reportOutputType = type;
        this.reportOutputName = output;
    }

    public UserPrincipal getReportUser() {
        return this.reportUser;
    }

    public void setReportUser(UserPrincipal reportUser) {
        this.reportUser = reportUser;
    }

    public ReportExportedType.Code getReportOutputType() {
        return this.reportOutputType;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportID() {
        return this.reportID;
    }

    public Map getResourceMapping() {
        return this.resourceMapping;
    }

    public void setResourceMapping(Map resourceMapping) {
        this.resourceMapping = resourceMapping;
    }

    public void addResourceMapping(Object key, Object value) {
        if (this.resourceMapping == null) {
            this.resourceMapping = new HashMap();
        }
        this.resourceMapping.put(key, value);
    }

    public QueryCriteria getQueryCriteria() {
        return this.queryCriteria;
    }

    public void setQueryCriteria(QueryCriteria queryCriteria) {
        this.queryCriteria = queryCriteria;
    }

    public String getReportOutputName() {
        return this.reportOutputName;
    }

    public String toString() {
        StringBuffer info = new StringBuffer();
        info.append("Report Name: ").append(this.reportName).append("Report ID: ").append(this.reportID).append("Generated report name: ").append(this.reportOutputName).append("Report Format ").append(this.reportOutputType.getAlias());
        return info.toString();
    }

    protected void finalize() throws Throwable {
        this.queryCriteria = null;
        this.reportOutputType = null;
        this.reportID = null;
        this.reportName = null;
        if (this.resourceMapping != null) {
            this.resourceMapping.clear();
        }
        this.resourceMapping = null;
    }

    private static String getDefaultOutputFileName(String name, String ID, ReportExportedType.Code type) {
        Validate.notNull((Object)name, (String)"A report name must not be NULL");
        Validate.notNull((Object)ID, (String)"A report ID must not be NULL");
        Validate.notNull((Object)((Object)type), (String)"A report type must not be NULL");
        return ID + "-" + name + "." + type.getAlias().toLowerCase();
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }
}

