/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report;

import gov.va.med.fw.report.ReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.report.ReportExporter;
import gov.va.med.fw.report.ReportTemplate;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ConfigurableReportBuilder
extends AbstractComponent
implements ReportBuilder {
    public static final String DATA_SERVICE_TAG = ".dataService";
    public static final String REPORT_TEMPLATE_TAG = ".reportTemplate";
    private static final long serialVersionUID = 8201546777696454757L;
    private Map reportTemplates = null;
    private Map reportDataServices = null;

    public void setReportDataServices(Map reportDataServices) {
        this.reportDataServices = reportDataServices;
    }

    public void setReportTemplates(Map reportTemplates) {
        this.reportTemplates = reportTemplates;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notEmpty((Map)this.reportDataServices, (String)"A report data service map must be configured");
        Validate.notEmpty((Map)this.reportTemplates, (String)"A report template map must be configured");
    }

    @Override
    public void buildReport(ReportConfiguration configuration) throws ReportException {
        this.buildReport(configuration, this.doRequestData(configuration));
    }

    @Override
    public void buildReport(ReportConfiguration configuration, ReportData data) throws ReportException {
        this.doBuildReport(configuration, data);
    }

    protected ReportData doRequestData(ReportConfiguration configuration) throws ReportException {
        ReportDataService service = this.getReportDataService(configuration);
        ReportData data = service != null ? service.requestReportData(configuration) : null;
        return data;
    }

    protected void doBuildReport(ReportConfiguration configuration, ReportData data) throws ReportException {
        ReportExporter exporter = this.getReportExporter(configuration.getReportOutputType());
        exporter.exportReport(configuration, data, this.getReportTemplate(configuration));
    }

    protected ReportExporter getReportExporter(ReportExportedType.Code type) throws ReportException {
        Validate.notNull((Object)((Object)type), (String)"A report output type must not be NULL");
        ReportExporter exporter = null;
        try {
            exporter = (ReportExporter)this.getComponent(type.getAlias(), ReportExporter.class);
        }
        catch (Exception e) {
            throw new ReportException("Failed to obtain a report exporter ", e);
        }
        return exporter;
    }

    protected ReportDataService getReportDataService(ReportConfiguration config) throws ReportException {
        String name = config.getReportName();
        if (!this.reportDataServices.containsKey(name)) {
            throw new ReportException("A report data service service is missing for report: " + name);
        }
        Object componentName = this.reportDataServices.get(name);
        return this.getReportDataService((String)componentName);
    }

    protected ReportDataService getReportDataService(String name) throws ReportException {
        ReportDataService service = null;
        try {
            Object tmp = this.getComponent(name);
            service = tmp instanceof ReportDataService ? (ReportDataService)tmp : null;
        }
        catch (Exception e) {
            throw new ReportException("A report data service " + name + " is not defined", e);
        }
        return service;
    }

    protected ReportTemplate getReportTemplate(ReportConfiguration config) throws ReportException {
        String name = config.getReportName();
        if (!this.reportTemplates.containsKey(name)) {
            throw new ReportException("A report template is missing for report: " + name);
        }
        return this.getReportTemplate((String)this.reportTemplates.get(name));
    }

    protected ReportTemplate getReportTemplate(String name) throws ReportException {
        ReportTemplate tpl = null;
        try {
            Object tmp = this.getComponent(name);
            tpl = tmp instanceof ReportTemplate ? (ReportTemplate)tmp : null;
        }
        catch (Exception e) {
            throw new ReportException("A report tpl " + name + " is not defined", e);
        }
        return tpl;
    }
}

