/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.ObjectUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;

public class PaginatedQueryExecutor
extends AbstractEntity {
    private static final long serialVersionUID = 5245502870107943655L;
    private Query countQuery;
    private Query dataQuery;
    private Criteria countCriteria;
    private Criteria dataCriteria;
    private SearchQueryInfo searchQueryInfo;
    private boolean sortPerformed = false;

    public PaginatedQueryExecutor(Query countQuery, Query dataQuery, SearchQueryInfo searchQueryInfo) {
        this.countQuery = countQuery;
        this.dataQuery = dataQuery;
        this.searchQueryInfo = searchQueryInfo;
    }

    public PaginatedQueryExecutor(Criteria countCriteria, Criteria dataCriteria, SearchQueryInfo searchQueryInfo, boolean sortPerformed) {
        this.countCriteria = countCriteria;
        this.dataCriteria = dataCriteria;
        this.searchQueryInfo = searchQueryInfo;
        this.sortPerformed = sortPerformed;
    }

    public List executeQuery() throws HibernateException, MaxRecordsExceededException {
        List results = new ArrayList();
        Log logger = this.getLogger();
        int numResults = this.executeCountQuery();
        this.searchQueryInfo.setTotalNumberOfEntries(numResults);
        if (numResults == 0) {
            this.searchQueryInfo.setSearchTypePerformed("readAll");
            return results;
        }
        this.checkMaxRecordsExceeded(numResults);
        String action = this.searchQueryInfo.getSearchAction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Action is \"" + action + "\"."));
        }
        boolean sortPerformed = this.getSortPerformed();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Data query is performing sort flag: \"" + sortPerformed + "\"."));
        }
        this.searchQueryInfo.setSortPerformed(sortPerformed);
        if (this.searchQueryInfo.getSortElements() != null && this.searchQueryInfo.getSortElements().size() > 0 && !sortPerformed) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("A requested GUI sort column is not supported within the database.  SortColumnMap: " + this.searchQueryInfo.getSortElements()));
            }
            this.searchQueryInfo.setSortColumnNotSupported(true);
            return this.performFullSearch();
        }
        if (action.equals("actionPage") || action.equals("actionSort")) {
            return this.performSinglePageSearch();
        }
        String searchOptimizationType = this.searchQueryInfo.getSearchOptimizationType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Search Optimization Type is \"" + searchOptimizationType + "\"."));
        }
        if (searchOptimizationType.equals("singlePage")) {
            return this.performSinglePageSearch();
        }
        if (searchOptimizationType.equals("readAll")) {
            return this.performFullSearch();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Retrieving the first pages worth of data.");
        }
        if ((results = this.executeSinglePageQuery(1)).size() < this.searchQueryInfo.getNumberPerPage() && this.searchQueryInfo.getPagingPage() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("All " + this.searchQueryInfo.getTotalNumberOfEntries() + " records have been retrieved."));
            }
            this.searchQueryInfo.setSearchTypePerformed("readAll");
            return results;
        }
        int firstPageSize = ObjectUtils.getObjectSize(results);
        int totalEstimatedSize = firstPageSize / this.searchQueryInfo.getNumberPerPage() * numResults;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The size of the first page is " + firstPageSize + " bytes and the total number of " + "records is " + numResults + " so the total estimated size is " + totalEstimatedSize + " bytes."));
        }
        if (totalEstimatedSize > this.searchQueryInfo.getMaxInMemoryEstimatedResultsSizeInBytes()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Since the estimated size of " + totalEstimatedSize + " bytes is > " + "the maximum allowed of " + this.searchQueryInfo.getMaxInMemoryEstimatedResultsSizeInBytes() + ", we will fetch only 1 pages worth of data."));
            }
            if (this.searchQueryInfo.getPagingPage() != 1) {
                results = this.executeSinglePageQuery(this.searchQueryInfo.getPagingPage());
            }
            this.searchQueryInfo.setSearchTypePerformed("singlePage");
            return results;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Since the estimated size of " + totalEstimatedSize + " bytes is <= " + "the maximum allowed of " + this.searchQueryInfo.getMaxInMemoryEstimatedResultsSizeInBytes() + ", we will perform a full search."));
        }
        return this.performFullSearch();
    }

    private boolean getSortPerformed() {
        if (this.dataQuery != null) {
            return this.dataQuery.getQueryString().indexOf("ORDER BY") != -1;
        }
        return this.sortPerformed;
    }

    protected List performSinglePageSearch() throws HibernateException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Performing a single page search of page " + this.searchQueryInfo.getPagingPage() + "."));
        }
        List results = this.executeSinglePageQuery(this.searchQueryInfo.getPagingPage());
        this.searchQueryInfo.setSearchTypePerformed("singlePage");
        return results;
    }

    protected List performFullSearch() throws HibernateException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Performing a full search.");
        }
        List results = this.executeFullQuery();
        this.searchQueryInfo.setSearchTypePerformed("readAll");
        return results;
    }

    protected int executeCountQuery() throws HibernateException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Retrieving the total number of records in the search.");
        }
        List results = this.countQuery != null ? this.countQuery.list() : this.countCriteria.list();
        int count = 0;
        if (results.size() > 0) {
            Object resultCount = results.get(0);
            count = BigDecimal.class.isAssignableFrom(resultCount.getClass()) ? ((BigDecimal)resultCount).intValue() : ((Integer)resultCount).intValue();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Total number of entries in search: " + count + "."));
        }
        return count;
    }

    protected List executeSinglePageQuery(int pageNumber) throws HibernateException {
        int numberPerPage = this.searchQueryInfo.getNumberPerPage();
        int firstRowNum = (pageNumber - 1) * numberPerPage;
        if (this.dataQuery != null) {
            this.dataQuery.setFirstResult(firstRowNum);
            this.dataQuery.setMaxResults(numberPerPage);
            return this.dataQuery.list();
        }
        this.dataCriteria.setFirstResult(firstRowNum);
        this.dataCriteria.setMaxResults(numberPerPage);
        return this.dataCriteria.list();
    }

    protected List executeFullQuery() throws HibernateException {
        if (this.dataQuery != null) {
            this.dataQuery.setFirstResult(0);
            this.dataQuery.setMaxResults(Integer.MAX_VALUE);
            return this.dataQuery.list();
        }
        this.dataCriteria.setFirstResult(0);
        this.dataCriteria.setMaxResults(Integer.MAX_VALUE);
        return this.dataCriteria.list();
    }

    protected void checkMaxRecordsExceeded(int totalResults) throws MaxRecordsExceededException {
        if (totalResults > this.searchQueryInfo.getMaxAllowedRecords()) {
            throw new MaxRecordsExceededException(totalResults, this.searchQueryInfo.getMaxAllowedRecords(), totalResults + " records match the search criteria which exceeds the configured maximum of " + this.searchQueryInfo.getMaxAllowedRecords() + ".");
        }
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("countQuery", (Object)this.countQuery);
        builder.append("dataQuery", (Object)this.dataQuery);
        builder.append("searchQueryInfo", (Object)this.searchQueryInfo);
        builder.append("countCriteria", (Object)this.countCriteria);
        builder.append("dataCriteria", (Object)this.dataCriteria);
    }
}

