/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.model.BaseEntityKey;
import gov.va.med.fw.model.EntityKey;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.PropertiesHelper;

public class BigSequenceGenerator
implements IdentifierGenerator,
Configurable {
    public static final String SEQUENCE = "sequence";
    private String sequenceName;
    private Type type;
    private String sql;
    private static final Log log = LogFactory.getLog(BigSequenceGenerator.class);

    protected EntityKey getEntityKey(BigDecimal val, Class targetClass) {
        return new BaseEntityKey(val, targetClass);
    }

    private Serializable get(ResultSet rs, Type type, SessionImplementor session, Object owner) throws SQLException, IdentifierGenerationException {
        Class clazz = type.getReturnedClass();
        if (clazz == BigDecimal.class) {
            return rs.getBigDecimal(1);
        }
        if (clazz == Long.class) {
            return new Long(rs.getLong(1));
        }
        if (clazz == Integer.class) {
            return new Integer(rs.getInt(1));
        }
        if (clazz == Short.class) {
            return new Short(rs.getShort(1));
        }
        if (EntityKey.class.isAssignableFrom(clazz)) {
            return this.getEntityKey(rs.getBigDecimal(1), owner.getClass());
        }
        throw new IdentifierGenerationException("this id generator generates BigDecimal, Long, Integer, Short, EntityKey.  It was handed a type: " + clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        PreparedStatement st = null;
        HibernateException cause = null;
        try {
            Serializable result;
            st = session.getBatcher().prepareStatement(this.sql);
            ResultSet rs = st.executeQuery();
            try {
                rs.next();
                result = this.get(rs, this.type, session, obj);
            }
            finally {
                rs.close();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sequence identifier generated: " + result));
            }
            Serializable serializable = result;
            return serializable;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions((SQLException)sqle);
            cause = new HibernateException((Throwable)sqle);
            throw cause;
        }
        finally {
            try {
                session.getBatcher().closeStatement(st);
            }
            catch (SQLException e) {
                log.error((Object)"Exception when closing statement");
                if (cause != null) {
                    throw cause;
                }
                throw new HibernateException((Throwable)e);
            }
        }
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.sequenceName = PropertiesHelper.getString((String)SEQUENCE, (Properties)params, (String)"hibernate_sequence");
        this.type = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }
}

