/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.TransactionType;
import gov.va.med.fw.security.Principal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractVersionedEntity
extends AbstractEntity {
    private static final long serialVersionUID = -7758974447945480434L;
    private Principal createdBy = null;
    private Date createdOn = null;
    private Principal modifiedBy = null;
    private Date modifiedOn = null;
    private Integer version = null;
    private TransactionType transactionType = null;
    private AbstractVersionedEntity previousVersion;
    private Serializable historyId;

    protected AbstractVersionedEntity() {
    }

    public AbstractVersionedEntity(Date createdOn, Date modifiedOn, Integer version) {
        this.createdOn = createdOn;
        this.modifiedOn = modifiedOn;
        this.version = version;
    }

    public Principal getCreatedBy() {
        return this.createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    private void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Principal getModifiedBy() {
        return this.modifiedBy;
    }

    public Date getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(Date modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public Integer getVersion() {
        return this.version;
    }

    private void setVersion(Integer version) {
        this.version = version;
    }

    public void setCreatedBy(Principal createdBy) {
        this.createdBy = createdBy;
    }

    public void setModifiedBy(Principal modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public AbstractVersionedEntity getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(AbstractVersionedEntity previousVersion) {
        this.previousVersion = previousVersion;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    private void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public Serializable getHistoryId() {
        return this.historyId;
    }

    private void setHistoryId(Serializable historyId) {
        this.historyId = historyId;
    }

    public Boolean isDeleted() {
        return this.transactionType == null ? Boolean.FALSE : this.transactionType.isDeleted();
    }

    public Iterator versions() {
        ArrayList<AbstractVersionedEntity> orderedVersions = new ArrayList<AbstractVersionedEntity>();
        for (AbstractVersionedEntity current = this; current != null; current = current.getPreviousVersion()) {
            orderedVersions.add(current);
        }
        return orderedVersions.iterator();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.createdBy = null;
        this.modifiedBy = null;
        this.modifiedOn = null;
        this.setVersion(null);
        this.setTransactionType(null);
        this.setHistoryId(null);
        this.setCreatedOn(null);
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("createdBy", (Object)this.createdBy);
        builder.append("createdOn", (Object)this.createdOn);
        builder.append("modifiedBy", (Object)this.modifiedBy);
        builder.append("modifiedOn", (Object)this.modifiedOn);
        builder.append("version", (Object)this.version);
        builder.append("historyId", (Object)this.historyId);
    }
}

