/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model;

import gov.va.med.fw.model.lookup.ModelPropertiesApplicationType;
import gov.va.med.fw.service.config.SingletonApplicationContext;
import gov.va.med.fw.util.ModelPropertiesManager;
import gov.va.med.fw.util.builder.AbstractEntityEqualsBuilder;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5480146452774529239L;
    private transient Log logger;
    private static ModelPropertiesManager modelPropertiesService;

    protected AbstractEntity() {
    }

    protected Log getLogger() {
        if (this.logger == null) {
            this.logger = LogFactory.getLog(this.getClass());
        }
        return this.logger;
    }

    protected abstract void buildToString(ToStringBuilder var1);

    public boolean equals(Object o) {
        return this.isModelPropertiesEqual(o, ModelPropertiesApplicationType.IDENTITY.getName());
    }

    public boolean matchesDomainValues(Object o) {
        return this.isModelPropertiesEqual(o, ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName());
    }

    public boolean matchesDomainConcept(Object o) {
        return this.isModelPropertiesEqual(o, ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName());
    }

    public int hashCode() {
        Object[] myProps = this.getPropertyValueMap(ModelPropertiesApplicationType.IDENTITY.getName()).values().toArray();
        if (myProps == null) {
            throw new IllegalStateException(this.getClass().getName() + " contains no IdentityProperties for hashCode calculation");
        }
        return new HashCodeBuilder().append(myProps).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        this.buildToString(builder);
        return builder.toString();
    }

    public Object clone() {
        return SerializationUtils.clone((Serializable)this);
    }

    public boolean isModelPropertiesEqual(Object o, String modelPropertiesApplication) {
        return o instanceof AbstractEntity && this.isModelPropertiesEqual((AbstractEntity)o, modelPropertiesApplication);
    }

    private boolean isModelPropertiesEqual(AbstractEntity entity, String modelPropertiesApplication) {
        try {
            if (this == entity) {
                return true;
            }
            if (entity == null || !this.getClass().equals(entity.getClass())) {
                return false;
            }
            OrderedMap namesToValues = this.getPropertyValueMap(modelPropertiesApplication);
            OrderedMap otherNamesToValues = entity.getPropertyValueMap(modelPropertiesApplication);
            if (namesToValues.isEmpty()) {
                throw new IllegalStateException(this.getClass().getName() + " (this) contains no Model Properties for application: " + modelPropertiesApplication);
            }
            if (otherNamesToValues == null) {
                throw new IllegalStateException(entity.getClass().getName() + " (other) contains no Model Properties for application: " + modelPropertiesApplication);
            }
            AbstractEntityEqualsBuilder equalsBuilder = new AbstractEntityEqualsBuilder(modelPropertiesApplication).append(namesToValues, otherNamesToValues);
            this.logNotEqualsDebugMessage(equalsBuilder, modelPropertiesApplication);
            return equalsBuilder.isEquals();
        }
        catch (StackOverflowError e) {
            this.getLogger().error((Object)("Received a stack overflow in isModelPropertiesEqual for application: " + modelPropertiesApplication + " and instance class: " + this.getClass().getName()));
            throw e;
        }
    }

    protected void logNotEqualsDebugMessage(AbstractEntityEqualsBuilder equalsBuilder, String modelPropertiesApplication) {
        if (!equalsBuilder.isEquals() && !ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(modelPropertiesApplication) && !ModelPropertiesApplicationType.IDENTITY.getName().equals(modelPropertiesApplication) && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Model Properties are not equal for Entity: " + this.getClass().getName() + ",  Property: " + equalsBuilder.getNotEqualsProperty() + ", LHS: " + equalsBuilder.getNotEqualsLhs() + ", RHS: " + equalsBuilder.getNotEqualsRhs() + "."));
        }
    }

    public static boolean equals(AbstractEntity entity1, AbstractEntity entity2) {
        return entity1 == null ? entity2 == null : entity1.equals(entity2);
    }

    public static boolean matchesDomainConcept(AbstractEntity entity1, AbstractEntity entity2) {
        return entity1 == null ? entity2 == null : entity1.matchesDomainConcept(entity2);
    }

    public static boolean matchesDomainValues(AbstractEntity entity1, AbstractEntity entity2) {
        return entity1 == null ? entity2 == null : entity1.matchesDomainValues(entity2);
    }

    public static boolean equals(Collection collection1, Collection collection2) {
        return AbstractEntity.isModelPropertiesEqual(collection1, collection2, ModelPropertiesApplicationType.IDENTITY.getName());
    }

    public static boolean matchesDomainConcept(Collection collection1, Collection collection2) {
        return AbstractEntity.isModelPropertiesEqual(collection1, collection2, ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName());
    }

    public static boolean matchesDomainValues(Collection collection1, Collection collection2) {
        return AbstractEntity.isModelPropertiesEqual(collection1, collection2, ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName());
    }

    protected static boolean isModelPropertiesEqual(Collection collection1, Collection collection2, String modelPropertiesApplication) {
        if (collection1 == null || collection2 == null) {
            return collection1 == null && collection2 == null;
        }
        ArrayList list1 = new ArrayList(collection1);
        ArrayList list2 = new ArrayList(collection2);
        if (list1.size() != list2.size()) {
            return false;
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            return true;
        }
        if (!AbstractEntity.class.isAssignableFrom(list1.get(0).getClass())) {
            return ((Object)list1).equals(list2);
        }
        ArrayList<AbstractEntity> orderedList2 = new ArrayList<AbstractEntity>();
        for (AbstractEntity entity1 : list1) {
            AbstractEntity matchingEntity = null;
            for (int i = 0; matchingEntity == null && i < list2.size(); ++i) {
                AbstractEntity entity2 = (AbstractEntity)list2.get(i);
                boolean matches = false;
                matches = ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(modelPropertiesApplication) || ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName().equals(modelPropertiesApplication) ? entity1.matchesDomainConcept(entity2) : entity1.equals(entity2);
                if (!matches) continue;
                matchingEntity = entity2;
                list2.remove(i);
            }
            if (matchingEntity == null) {
                return false;
            }
            orderedList2.add(matchingEntity);
        }
        if (ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName().equals(modelPropertiesApplication)) {
            for (int i = 0; i < list1.size(); ++i) {
                AbstractEntity entity2;
                AbstractEntity entity1;
                entity1 = (AbstractEntity)list1.get(i);
                if (AbstractEntity.matchesDomainValues(entity1, entity2 = (AbstractEntity)orderedList2.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isModelPropertiesEqual(Map mapParam1, Map mapParam2, String modelPropertiesApplication) {
        HashMap map1 = new HashMap(mapParam1);
        HashMap map2 = new HashMap(mapParam2);
        if (map1 == null || map2 == null) {
            return map1 == null && map2 == null;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        if (!((Object)map1.keySet()).equals(map2.keySet())) {
            return false;
        }
        return AbstractEntity.isModelPropertiesEqual(map1.values(), map2.values(), modelPropertiesApplication);
    }

    protected OrderedMap getPropertyValueMap(String modelPropertiesApplication) {
        if (ModelPropertiesApplicationType.IDENTITY.getName().equals(modelPropertiesApplication)) {
            return this.getPropertyValueMapForIdentity();
        }
        if (ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(modelPropertiesApplication)) {
            return this.getPropertyValueMapForMatchDomainConcept();
        }
        if (ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName().equals(modelPropertiesApplication)) {
            return this.getPropertyValueMapForMatchDomainValues();
        }
        return this.doGetPropertyValueMap(modelPropertiesApplication);
    }

    protected OrderedMap getPropertyValueMapForIdentity() {
        return this.doGetPropertyValueMap(ModelPropertiesApplicationType.IDENTITY.getName());
    }

    protected OrderedMap getPropertyValueMapForMatchDomainConcept() {
        return this.doGetPropertyValueMap(ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName());
    }

    protected OrderedMap getPropertyValueMapForMatchDomainValues() {
        return this.doGetPropertyValueMap(ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName());
    }

    private final OrderedMap doGetPropertyValueMap(String modelPropertiesApplication) {
        ListOrderedMap data = new ListOrderedMap();
        List propertyFields = this.getPropertyFields(modelPropertiesApplication);
        try {
            Iterator itr = propertyFields != null ? propertyFields.iterator() : null;
            Field fld = null;
            while (itr != null && itr.hasNext()) {
                fld = (Field)itr.next();
                data.put((Object)fld.getName(), fld.get(this));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve model property values from object " + this.getClass().getName(), e);
        }
        return data;
    }

    protected List getPropertyFields(String modelPropertiesApplication) {
        if (ModelPropertiesApplicationType.IDENTITY.getName().equals(modelPropertiesApplication)) {
            return this.getPropertyFieldsForIdentity();
        }
        if (ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(modelPropertiesApplication)) {
            return this.getPropertyFieldsForMatchDomainConcept();
        }
        if (ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName().equals(modelPropertiesApplication)) {
            return this.getPropertyFieldsForMatchDomainValues();
        }
        return this.getModelPropertiesService().getModelProperties(this.getClass(), modelPropertiesApplication);
    }

    protected List getPropertyFieldsForIdentity() {
        return this.getModelPropertiesService().getModelProperties(this.getClass(), ModelPropertiesApplicationType.IDENTITY.getName());
    }

    protected List getPropertyFieldsForMatchDomainValues() {
        return this.getModelPropertiesService().getModelProperties(this.getClass(), ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName());
    }

    protected List getPropertyFieldsForMatchDomainConcept() {
        return this.getModelPropertiesService().getModelProperties(this.getClass(), ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName());
    }

    private ModelPropertiesManager getModelPropertiesService() {
        if (modelPropertiesService == null) {
            SingletonApplicationContext locator = SingletonApplicationContext.getInstance();
            ApplicationContext ctx = locator.getSingletonContext();
            modelPropertiesService = (ModelPropertiesManager)ctx.getBean(ModelPropertiesManager.CONFIG_SERVICE_KEY, ModelPropertiesManager.class);
        }
        return modelPropertiesService;
    }
}

