/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io.writer;

import com.infomata.data.DataFile;
import com.infomata.data.DataRow;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.DataFormat;
import gov.va.med.fw.io.DelimitedFormat;
import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.io.FileFieldMetaData;
import gov.va.med.fw.io.FileNameAppender;
import gov.va.med.fw.io.FixedWidthFormat;
import gov.va.med.fw.io.RawFileDataContainer;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.io.SimpleDelimiterFormat;
import gov.va.med.fw.io.writer.DateFieldTransformer;
import gov.va.med.fw.io.writer.OutputFileFieldMetaData;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.InvalidConfigurationException;
import gov.va.med.fw.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.FileSystemResource;

public class FormattedFileWriter
extends AbstractComponent {
    private static String DEFAULT_DELIMITER = "^";
    private String fileLocation;
    private String delimiter;
    private boolean extraCarriageReturnAfterEachDataWrite = true;
    private DataFormat dataFormat;
    private List classMappings;
    private Map classMappingsMap = new HashMap();
    private boolean failOnUnmappedInstances = true;
    private boolean shouldConvertLookups = true;
    private FileNameAppender fileNameAppender;
    private int maxLineSize;
    private DateFieldTransformer globalDateTransformer;
    private FieldTransformer globalTransformer;
    private String fileEncoding;
    private String bulletinToList;

    public synchronized boolean appendData(List data) {
        DataFile writer = DataFile.createWriter((String)this.fileEncoding, (boolean)true);
        writer.setDataFormat((com.infomata.data.DataFormat)this.dataFormat);
        return this.writeData(writer, data, null);
    }

    public synchronized boolean appendData(List data, Object fileNameSuffixData) {
        DataFile writer = DataFile.createWriter((String)this.fileEncoding, (boolean)true);
        writer.setDataFormat((com.infomata.data.DataFormat)this.dataFormat);
        return this.writeData(writer, data, fileNameSuffixData);
    }

    public synchronized boolean writeData(List data) {
        DataFile writer = DataFile.createWriter((String)this.fileEncoding, (boolean)false);
        writer.setDataFormat((com.infomata.data.DataFormat)this.dataFormat);
        return this.writeData(writer, data, null);
    }

    public synchronized boolean writeData(List data, Object fileNameSuffixData) {
        DataFile writer = DataFile.createWriter((String)this.fileEncoding, (boolean)false);
        writer.setDataFormat((com.infomata.data.DataFormat)this.dataFormat);
        return this.writeData(writer, data, fileNameSuffixData);
    }

    public void changeFileExtensions(String fromExtn, String toExtn) throws IOException {
        String directoryPath = this.getIVMFilePath();
        RawFileDataContainerUtils.changeFileExtensions(fromExtn, toExtn, directoryPath);
    }

    public String getIVMFilePath() {
        String filePath = this.fileLocation;
        if (this.fileLocation != null && !this.fileLocation.endsWith("/")) {
            int index = this.fileLocation.lastIndexOf("/");
            index = index == -1 ? this.fileLocation.lastIndexOf("\\") : index;
            filePath = this.fileLocation.substring(0, index + 1);
        }
        return filePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean writeData(DataFile writer, List data, Object fileNameSuffixData) {
        DataRow row;
        boolean success;
        block31: {
            if (data == null) {
                return true;
            }
            success = false;
            FileSystemResource resource = null;
            row = null;
            try {
                resource = this.getFileSystemResource(fileNameSuffixData);
                writer.open(resource.getFile());
                Iterator itr = data.iterator();
                Object obj = null;
                OutputFileFieldMetaData meta = null;
                Iterator fieldsItr = null;
                Object value = null;
                int currentLineSize = 0;
                int delimiterSize = this.dataFormat instanceof DelimitedFormat ? ((DelimitedFormat)((Object)this.dataFormat)).getDelimiter().length() : 0;
                ClassMapping targetClassMapping = null;
                while (itr.hasNext()) {
                    obj = itr.next();
                    row = writer.next();
                    currentLineSize = 0;
                    if (obj instanceof RawFileDataContainer) {
                        OrderedMap rowData = ((RawFileDataContainer)obj).getRawFileData();
                        MapIterator fieldDataItr = rowData != null ? rowData.mapIterator() : null;
                        String elementName = null;
                        Object elementValue = null;
                        FileFieldMetaData metaForTransform = null;
                        while (fieldDataItr != null && fieldDataItr.hasNext()) {
                            elementName = (String)fieldDataItr.next();
                            elementValue = fieldDataItr.getValue();
                            targetClassMapping = this.getTargetClassMapping(obj, false);
                            elementValue = this.applyGlobalTransforms(elementName, elementValue);
                            if (targetClassMapping != null && targetClassMapping.hasFieldsMetaData() && (metaForTransform = targetClassMapping.getFieldMetaData(elementName)) != null) {
                                Object transformed = metaForTransform.transform(elementValue);
                                elementValue = transformed != null ? transformed.toString() : null;
                            }
                            currentLineSize = this.addDataToRow(writer, row, elementValue, currentLineSize, delimiterSize, (Iterator)fieldDataItr);
                        }
                        continue;
                    }
                    targetClassMapping = this.getTargetClassMapping(obj, this.failOnUnmappedInstances);
                    if (targetClassMapping == null || !targetClassMapping.hasFieldsMetaData()) {
                        currentLineSize = this.addDataToRow(writer, row, obj, currentLineSize, delimiterSize, null);
                        continue;
                    }
                    fieldsItr = targetClassMapping.getFieldsMetaData().iterator();
                    while (fieldsItr.hasNext()) {
                        meta = (OutputFileFieldMetaData)((Object)fieldsItr.next());
                        if (meta.isSectionHeaderField()) {
                            row.add(meta.getSectionHeader());
                            if (!targetClassMapping.isSectionHeaderOnSeparateLine()) continue;
                            row = writer.next();
                            continue;
                        }
                        if (meta.isBeginNewLine()) {
                            if (this.dataFormat instanceof DelimitedFormat) {
                                row.add("");
                            }
                            row = writer.next();
                        }
                        if (meta.isFillerField()) {
                            value = meta.getFillerValue();
                        } else {
                            try {
                                value = PropertyUtils.getProperty(obj, (String)meta.getName());
                            }
                            catch (NullPointerException e) {
                                value = "";
                            }
                            value = this.applyGlobalTransforms(meta.getName(), value);
                            value = meta.transform(value);
                        }
                        currentLineSize = this.addDataToRow(writer, row, value, currentLineSize, delimiterSize, fieldsItr);
                    }
                }
                success = true;
                if (!this.extraCarriageReturnAfterEachDataWrite && row != null) break block31;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Unable to write to " + resource.getFilename(), e);
                }
                catch (Throwable throwable) {
                    if (this.extraCarriageReturnAfterEachDataWrite || row == null) {
                        writer.close();
                        throw throwable;
                    }
                    PrintWriter writerOut2 = this.getPrintWriter(writer);
                    try {
                        writerOut2.print(this.dataFormat.format(row));
                        throw throwable;
                    }
                    catch (Exception e2) {
                        IllegalStateException e22 = new IllegalStateException("Custom workaround for DataFile shortcoming not working....perhaps assumes different version");
                        e22.initCause(e2);
                        throw e22;
                    }
                    finally {
                        if (writerOut2 != null) {
                            writerOut2.close();
                        }
                    }
                }
            }
            writer.close();
            return success;
        }
        PrintWriter writerOut = this.getPrintWriter(writer);
        try {
            writerOut.print(this.dataFormat.format(row));
            return success;
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Custom workaround for DataFile shortcoming not working....perhaps assumes different version");
            e2.initCause(e);
            throw e2;
        }
        finally {
            if (writerOut != null) {
                writerOut.close();
            }
        }
    }

    private PrintWriter getPrintWriter(DataFile writer) {
        try {
            Field outField = writer.getClass().getDeclaredField("out");
            outField.setAccessible(true);
            return (PrintWriter)outField.get(writer);
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Unable to get PrintWriter member variable from DataFile instance");
            e2.initCause(e);
            throw e2;
        }
    }

    public void println(Object fileNameSuffixData) {
        DataFile writer = DataFile.createWriter((String)this.fileEncoding, (boolean)true);
        FileSystemResource resource = this.getFileSystemResource(fileNameSuffixData);
        PrintWriter writerOut = null;
        try {
            writer.open(resource.getFile());
            writerOut = this.getPrintWriter(writer);
            writerOut.println();
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Unable to println to DataFile");
            e2.initCause(e);
            throw e2;
        }
        finally {
            if (writerOut != null) {
                writerOut.close();
            }
        }
    }

    public FileSystemResource getFileSystemResource(Object fileNameSuffixData) {
        String targetFileLocation = this.fileNameAppender == null ? this.fileLocation : this.fileLocation.concat(this.fileNameAppender.getFileNameSuffix(fileNameSuffixData));
        return new FileSystemResource(targetFileLocation);
    }

    private Object applyGlobalTransforms(String fieldName, Object data) throws Exception {
        Object result = data;
        if (data instanceof Lookup && this.shouldConvertLookups) {
            result = ((Lookup)data).getCode();
        } else if (data instanceof Date && this.globalDateTransformer != null) {
            result = this.globalDateTransformer.transformData(fieldName, data);
        } else if (this.globalTransformer != null) {
            result = this.globalTransformer.transformData(fieldName, data);
        }
        return result;
    }

    private int addDataToRow(DataFile writer, DataRow row, Object value, int currentLineSize, int delimiterSize, Iterator fieldItr) throws Exception {
        String currentStringValue;
        String string = currentStringValue = value == null ? "" : value.toString();
        if (this.maxLineSize != 0) {
            currentLineSize = currentLineSize + currentStringValue.length() + delimiterSize;
            if (row.size() != 0 && currentLineSize > this.maxLineSize && (currentStringValue.length() != 0 || fieldItr == null || fieldItr.hasNext())) {
                row.add("");
                row = writer.next();
                currentLineSize = currentStringValue.length() + delimiterSize;
            }
        }
        row.add(currentStringValue);
        return currentLineSize;
    }

    private ClassMapping getTargetClassMapping(Object obj, boolean shouldFailIfNotFound) {
        ClassMapping cm = (ClassMapping)((Object)this.classMappingsMap.get(obj.getClass()));
        if (cm == null) {
            Iterator itr = this.classMappingsMap.keySet().iterator();
            Class clazz = null;
            while (itr.hasNext()) {
                clazz = (Class)itr.next();
                if (!clazz.isAssignableFrom(obj.getClass())) continue;
                return (ClassMapping)((Object)this.classMappingsMap.get(clazz));
            }
        }
        if (cm == null && shouldFailIfNotFound) {
            throw new IllegalStateException("Unable to find ClassMapping for: " + obj.getClass());
        }
        return cm;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = !StringUtils.isEmpty((String)fileEncoding) ? fileEncoding : null;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.fileLocation, (String)"fileLocation is needed");
        int[] fieldWidths = null;
        boolean isFixedFieldFormatter = false;
        Iterator itr = null;
        ClassMapping classMapping2 = null;
        if (this.classMappings != null && this.classMappings.size() == 1) {
            classMapping2 = (ClassMapping)((Object)this.classMappings.get(0));
            itr = classMapping2.getFieldsMetaData().iterator();
            OutputFileFieldMetaData metaData = null;
            fieldWidths = new int[classMapping2.getFieldsMetaData().size()];
            int i = 0;
            while (itr.hasNext()) {
                metaData = (OutputFileFieldMetaData)((Object)itr.next());
                if (metaData.getFixedFieldWidth() != 0) {
                    isFixedFieldFormatter = true;
                }
                fieldWidths[i++] = metaData.getFixedFieldWidth();
            }
        }
        if (isFixedFieldFormatter) {
            this.dataFormat = new FixedWidthFormat(fieldWidths);
        } else if (!StringUtils.isEmpty((String)this.delimiter)) {
            this.dataFormat = new SimpleDelimiterFormat(this.delimiter);
        }
        if (this.dataFormat == null) {
            this.dataFormat = new SimpleDelimiterFormat(DEFAULT_DELIMITER);
        }
        if (this.classMappings != null) {
            for (ClassMapping classMapping2 : this.classMappings) {
                this.classMappingsMap.put(classMapping2.getTargetClass(), classMapping2);
            }
        }
        if (!this.classMappingsMap.containsKey(String.class)) {
            this.classMappingsMap.put(String.class, new ClassMapping());
        }
        if (!(this.dataFormat instanceof DelimitedFormat) && this.maxLineSize != 0) {
            throw new InvalidConfigurationException("Line wrapping is currently only available for instances of DelimitedFormat.");
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public List getClassMappings() {
        return this.classMappings;
    }

    public void setClassMappings(List classMappings) {
        this.classMappings = classMappings;
    }

    public boolean isFailOnUnmappedInstances() {
        return this.failOnUnmappedInstances;
    }

    public void setFailOnUnmappedInstances(boolean failOnUnmappedInstances) {
        this.failOnUnmappedInstances = failOnUnmappedInstances;
    }

    public FileNameAppender getFileNameAppender() {
        return this.fileNameAppender;
    }

    public void setFileNameAppender(FileNameAppender fileNameAppender) {
        this.fileNameAppender = fileNameAppender;
    }

    public int getMaxLineSize() {
        return this.maxLineSize;
    }

    public void setMaxLineSize(int maxLineSize) {
        this.maxLineSize = maxLineSize;
    }

    public boolean isShouldConvertLookups() {
        return this.shouldConvertLookups;
    }

    public void setShouldConvertLookups(boolean shouldConvertLookups) {
        this.shouldConvertLookups = shouldConvertLookups;
    }

    public DateFieldTransformer getGlobalDateTransformer() {
        return this.globalDateTransformer;
    }

    public void setGlobalDateTransformer(DateFieldTransformer globalDateTransformer) {
        this.globalDateTransformer = globalDateTransformer;
    }

    public FieldTransformer getGlobalTransformer() {
        return this.globalTransformer;
    }

    public void setGlobalTransformer(FieldTransformer globalTransformer) {
        this.globalTransformer = globalTransformer;
    }

    public boolean isExtraCarriageReturnAfterEachDataWrite() {
        return this.extraCarriageReturnAfterEachDataWrite;
    }

    public void setExtraCarriageReturnAfterEachDataWrite(boolean extraCarriageReturnAfterEachDataWrite) {
        this.extraCarriageReturnAfterEachDataWrite = extraCarriageReturnAfterEachDataWrite;
    }

    public String getBulletinToList() {
        return this.bulletinToList;
    }

    public void setBulletinToList(String bulletinToList) {
        this.bulletinToList = bulletinToList;
    }
}

