/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.HL7SegmentParser;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZSP;

public class HL7MessageUtils
extends HL7SegmentParser {
    public static String getUnsolicitedType(Message message) throws InvalidMessageException {
        MSH msh = HL7SegmentParser.getMSHSegment(message);
        return msh != null ? msh.getSendingApplication() : null;
    }

    public static Integer getCombinedPercentage(Message message) throws InvalidMessageException {
        ZSP zsp = HL7SegmentParser.getZSPSegment(message);
        return zsp == null || zsp.getServiceConnectedPercentage() == null ? null : new Integer(zsp.getServiceConnectedPercentage());
    }

    public static String getEntitlementCode(Message message) throws InvalidMessageException {
        ZEL zel = HL7SegmentParser.getZELSegment(message);
        return zel != null ? zel.getEligibilityCode() : null;
    }

    public static String getErrorText(Message message) throws InvalidMessageException {
        MSA msa = HL7SegmentParser.getMSASegment(message);
        return msa != null ? msa.getTextMessage() : null;
    }

    public static String getErrorMessage(Message message) throws InvalidMessageException {
        String errorMessage;
        MSA msa = HL7SegmentParser.getMSASegment(message);
        String string = errorMessage = msa != null ? msa.getTextMessage() : null;
        if (errorMessage != null) {
            if (errorMessage.indexOf("-") > 0) {
                errorMessage = errorMessage.substring(0, errorMessage.indexOf("-"));
            }
            return errorMessage.trim().toUpperCase();
        }
        return "";
    }

    public static String getMessageID(Message message) throws InvalidMessageException {
        MSA msa = HL7SegmentParser.getMSASegment(message);
        return msa != null ? msa.getMessageControlID() : null;
    }

    public static String getTransmissionDate(Message message) throws InvalidMessageException {
        MSH msh;
        BHS bhs;
        String date = null;
        date = message instanceof BatchMessage ? ((bhs = HL7SegmentParser.getBHSSegment(message)) != null ? bhs.getCreationDate() : null) : ((msh = HL7SegmentParser.getMSHSegment(message)) != null ? msh.getCreationDate() : null);
        return date;
    }

    public static boolean isAck(Message message) throws InvalidMessageException {
        boolean isAck = message.getMessageType().equals("ACK");
        if (!isAck && message.getSegment("BHS") != null) {
            String nameIDType = ((BHS)message.getSegment("BHS")).getNameIDType();
            isAck = nameIDType != null && nameIDType.indexOf("ACK") > -1;
        }
        return isAck;
    }
}

