/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.util.StringUtils;
import java.util.List;

public class AckMessage
extends HL7Message {
    private static final long serialVersionUID = 2053766024217320499L;

    public AckMessage(Message message) {
        super(message);
    }

    public AckMessage(String data) throws InvalidMessageException {
        super(data);
    }

    public AckMessage(String data, String type) throws InvalidMessageException {
        super(data, type);
    }

    public AckMessage(List segments) throws InvalidMessageException {
        super(segments);
    }

    public AckMessage(List segments, String type) throws InvalidMessageException {
        super(segments, type);
    }

    public boolean isBatch() throws InvalidMessageException {
        return this.getBHSSegment() != null;
    }

    public boolean isQueryResponse() throws InvalidMessageException {
        return this.getMSHSegment().getMessageType().indexOf("ORF") > -1;
    }

    public BatchMessage getAsBatch() throws InvalidMessageException {
        String messageType = this.getMessageType();
        if (this.isQueryResponse()) {
            messageType = StringUtils.replace((String)this.getMSHSegment().getMessageType(), (String)"~", (String)"");
        }
        return new BatchMessage(this.getSegments(), messageType);
    }

    public String getReferencedControlNumber() throws InvalidMessageException {
        MSA msa = this.getMSASegment();
        if (msa == null) {
            throw new InvalidMessageException("An AckMessage must have an MSA segment");
        }
        return msa.getMessageControlID();
    }
}

