/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.conversion;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;

public class DateConverter
implements Converter {
    private String[] dateFormats = new String[]{"MM/dd/yyyy", "MMM dd, yyyy", "yyyyMMddHHmmssZ", "yyyyMMddHHmmss", "yyyyMMdd"};
    private Object defaultValue = null;
    private boolean useDefault = true;

    public DateConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public DateConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (value instanceof Date) {
            return value;
        }
        String str = value.toString();
        Date date = null;
        for (int i = 0; i < this.dateFormats.length; ++i) {
            date = this.parseDate(str, this.dateFormats[i]);
            if (date == null) continue;
            return date;
        }
        if (this.useDefault) {
            return this.defaultValue;
        }
        throw new ConversionException("Unable to convert to Date: " + str);
    }

    private Date parseDate(String value, String format) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            date = (Date)sdf.parseObject(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        return date;
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public void setUseDefault(boolean useDefault) {
        this.useDefault = useDefault;
    }
}

