/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.conversion;

import gov.va.med.fw.conversion.ConversionRequest;
import gov.va.med.fw.conversion.DateConverter;
import gov.va.med.fw.util.StringUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanConverter {
    protected static transient Log log = LogFactory.getLog(BeanConverter.class);
    protected static Map propertyDescriptorCache = new HashMap();

    public static void convertBean(ConversionRequest request) throws ConversionException {
        try {
            Object source = request.getSource();
            Object target = request.getTarget();
            Map sourceProp = request.getSourceProperties();
            Map targetProp = request.getTargetProperties();
            if (source == null) {
                throw new ConversionException("Source bean is null");
            }
            if (target == null) {
                throw new ConversionException("Target bean is null");
            }
            if (sourceProp == null || sourceProp.isEmpty()) {
                throw new ConversionException("Source property map is null or empty");
            }
            if (targetProp == null || targetProp.isEmpty()) {
                throw new ConversionException("Target property map is null or empty");
            }
            PropertyUtilsBean propUtils = BeanUtilsBean.getInstance().getPropertyUtils();
            for (String key : sourceProp.keySet()) {
                Object sourceValue;
                PropertyDescriptor propDesc;
                String sourceKey = (String)sourceProp.get(key);
                String targetKey = (String)targetProp.get(key);
                if (!StringUtils.isNotEmpty((String)sourceKey) || !StringUtils.isNotEmpty((String)targetKey) || (propDesc = propUtils.getPropertyDescriptor(source, sourceKey)) == null) continue;
                if (StringUtils.contains((String)targetKey, (String)"[") || StringUtils.contains((String)targetKey, (String)"]")) {
                    log.warn((Object)"Not supported! - ignoring the individual array element conversion");
                }
                if ((sourceValue = propUtils.getNestedProperty(source, sourceKey)) == null) continue;
                log.trace((Object)("Converting source value = " + sourceValue));
                log.trace((Object)("Converting target key   = " + targetKey));
                if (StringUtils.contains((String)targetKey, (String)".")) {
                    BeanConverter.createNestedObject(target, targetKey, sourceValue);
                }
                BeanUtils.copyProperty((Object)target, (String)targetKey, (Object)sourceValue);
            }
        }
        catch (Exception ex) {
            throw new ConversionException("Error occured while converting/copying source bean to target bean", (Throwable)ex);
        }
    }

    private static void createNestedObject(Object target, String nestedKey, Object incomingValue) throws Exception {
        String nestedProperty = null;
        PropertyDescriptor prop = null;
        Class<?> nestedClass = null;
        Object nestedObject = null;
        StringTokenizer tokens = new StringTokenizer(nestedKey, ".");
        PropertyUtilsBean propUtils = BeanUtilsBean.getInstance().getPropertyUtils();
        while (tokens.hasMoreTokens()) {
            nestedProperty = tokens.nextToken();
            log.trace((Object)("Nested property: " + nestedProperty));
            try {
                nestedObject = propUtils.getProperty(target, nestedProperty);
                if (nestedObject != null) {
                    target = nestedObject;
                    log.trace((Object)("Nested object is already set. Class name - " + nestedObject.getClass().getName()));
                    continue;
                }
            }
            catch (Exception e) {
                nestedObject = null;
            }
            prop = propUtils.getPropertyDescriptor(target, nestedProperty);
            if (prop != null && prop.getPropertyType().isArray()) {
                return;
            }
            if (nestedObject == null && prop != null && !BeanConverter.isEmpty(incomingValue)) {
                nestedClass = prop.getPropertyType();
                nestedObject = BeanConverter.createObject(nestedClass);
                BeanConverter.executeMethod(prop.getWriteMethod(), target, nestedObject);
            }
            target = nestedObject;
        }
    }

    public static Object createObject(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class " + (clazz == null ? "null" : clazz.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access class " + (clazz == null ? "null" : clazz.getName()), e);
        }
    }

    public static Object createObject(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        return BeanConverter.createObject(clazz);
    }

    private static void executeMethod(Method setMethod, Object dest, Object nestedObject) throws Exception {
        Object[] args = new Object[]{nestedObject};
        setMethod.invoke(dest, args);
    }

    private static boolean isEmpty(Object val) {
        return val != null ? StringUtils.isEmpty((String)val.toString()) : true;
    }

    static {
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean(new ConvertUtilsBean(), new PropertyUtilsBean()));
        ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();
        convertUtils.register((Converter)new DateConverter(null), Date.class);
    }
}

