/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.CacheStrategy;
import gov.va.med.fw.service.AbstractComponent;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ThreadLocalCacheStrategy
extends AbstractComponent
implements CacheStrategy {
    private static final long serialVersionUID = -2377444842284916518L;

    @Override
    public Object getItem(Object key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving a cached item keyed by " + key));
        }
        return TransactionSynchronizationManager.getResource((Object)key);
    }

    @Override
    public synchronized Object removeItem(Object key) {
        Object removed = null;
        if (this.containsItem(key)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing a cached item keyed by " + key));
            }
            removed = TransactionSynchronizationManager.unbindResource((Object)key);
        }
        return removed;
    }

    @Override
    public void cacheItem(Object key, Object value) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Storing a cached item " + value + " keyed by " + key));
        }
        TransactionSynchronizationManager.bindResource((Object)key, (Object)value);
    }

    @Override
    public boolean containsItem(Object key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Checking a cache for item keyed by " + key));
        }
        return TransactionSynchronizationManager.hasResource((Object)key);
    }
}

