/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.AbstractComponent;
import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.Validate;

public abstract class AbstractEntityCacheAdvice
extends AbstractComponent
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 3417988966012828069L;
    private EntityCacheManager cacheManager = null;
    private boolean resultCloned = true;
    private boolean returnCachedItem = false;

    protected AbstractEntityCacheAdvice() {
    }

    public boolean isResultCloned() {
        return this.resultCloned;
    }

    public void setResultCloned(boolean isResultCloned) {
        this.resultCloned = isResultCloned;
    }

    public boolean isReturnCachedItem() {
        return this.returnCachedItem;
    }

    public void setReturnCachedItem(boolean returnCachedItem) {
        this.returnCachedItem = returnCachedItem;
    }

    public void setCacheManager(EntityCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public EntityCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.isCached(invocation) ? this.getCachedItem(invocation) : this.processInvocation(invocation);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.cacheManager, (String)"A cache manager is required");
    }

    protected Object processInvocation(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        Object cached = this.cache(this.clone(result), invocation);
        return this.returnCachedItem ? cached : result;
    }

    protected Object cache(Object result, MethodInvocation invocation) {
        if (result instanceof AbstractEntity) {
            this.cacheManager.storeItem((AbstractEntity)result, this.getCachedKey(result, invocation));
        }
        return result;
    }

    protected Object getCachedKey(Object result, MethodInvocation invocation) {
        int size;
        Object key = null;
        Object[] args = invocation.getArguments();
        int n = size = args != null ? args.length : 0;
        if (size == 1) {
            key = args[0];
        } else if (size > 1) {
            StringBuffer info = new StringBuffer();
            for (int i = 0; i < size; ++i) {
                info.append(args[i].toString());
            }
            key = info.toString();
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("A key is required to cache " + result));
        }
        return key;
    }

    protected Object clone(Object item) {
        Object cloned = item;
        if (this.isResultCloned() && item instanceof Serializable) {
            cloned = SerializationUtils.clone((Serializable)((Serializable)item));
        }
        return cloned;
    }

    protected boolean isCached(EntityKey key) {
        boolean isCached = false;
        if (key != null) {
            isCached = this.cacheManager.getItem(key) != null;
        }
        return isCached;
    }

    protected AbstractEntity getCachedItem(EntityKey key) {
        AbstractEntity entity = null;
        if (key != null) {
            entity = this.cacheManager.getItem(key);
        }
        return entity;
    }

    protected abstract boolean isCached(MethodInvocation var1);

    protected abstract Object getCachedItem(MethodInvocation var1);
}

