/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessCompletedHandler;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.AbstractComponent;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class SimpleDataFileProcessCompletedHandler
extends AbstractComponent
implements DataProcessCompletedHandler {
    private boolean allowFileDeletion = true;
    private boolean shouldRenameFile;
    private String renameInputFileRoot;
    private String renameInputFileExtension;

    private final void fileProcessingComplete(File inputFile, List exceptionData) {
        if (inputFile != null) {
            if (this.shouldDeleteFile(exceptionData)) {
                if (this.allowFileDeletion && !inputFile.delete()) {
                    throw new IllegalStateException("Unable to delete input file: " + inputFile.getName());
                }
            } else if (this.shouldRenameFile(exceptionData) && !this.renameFile(inputFile)) {
                throw new IllegalStateException("Unable to rename input file: " + inputFile.getName());
            }
        }
    }

    protected boolean shouldDeleteFile(List exceptionData) {
        return exceptionData.isEmpty();
    }

    protected boolean shouldRenameFile(List exceptionData) {
        return this.shouldRenameFile;
    }

    protected boolean renameFile(File inputFile) {
        String inputFilePath = inputFile.getParent();
        StringBuffer inputFileNameRoot = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(inputFile.getName(), ".");
        int tokenCount = st.countTokens();
        for (int i = 1; i < tokenCount; ++i) {
            inputFileNameRoot.append(st.nextToken());
            if (i == tokenCount - 1) continue;
            inputFileNameRoot.append(".");
        }
        if (tokenCount == 1) {
            inputFileNameRoot.append(inputFile.getName());
        }
        String newFileName = null;
        newFileName = this.renameInputFileRoot != null ? this.renameInputFileRoot + this.renameInputFileExtension : inputFileNameRoot.toString() + this.renameInputFileExtension;
        File newFile = new File(inputFilePath + File.separator + newFileName);
        int i = 1;
        while (newFile.exists()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Can not rename file to " + newFile.getName() + " since it exists already.  Trying one up number extension"));
            }
            newFile = new File(inputFilePath + File.separator + newFileName + i++);
        }
        boolean result = inputFile.renameTo(newFile);
        inputFile.setLastModified(new Date().getTime());
        return result;
    }

    public String getRenameInputFileExtension() {
        return this.renameInputFileExtension;
    }

    public void setRenameInputFileExtension(String renameInputFileExtension) {
        this.renameInputFileExtension = renameInputFileExtension;
    }

    public String getRenameInputFileRoot() {
        return this.renameInputFileRoot;
    }

    public void setRenameInputFileRoot(String renameInputFileRoot) {
        this.renameInputFileRoot = renameInputFileRoot;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.renameInputFileRoot != null || this.renameInputFileExtension != null) {
            this.shouldRenameFile = true;
        }
    }

    public boolean isAllowFileDeletion() {
        return this.allowFileDeletion;
    }

    public void setAllowFileDeletion(boolean allowFileDeletion) {
        this.allowFileDeletion = allowFileDeletion;
    }

    @Override
    public void dataProcessingComplete(DataProcessExecutionContext context) {
        DataFileProcessExecutionContext ctxt = (DataFileProcessExecutionContext)context;
        this.fileProcessingComplete(ctxt.getCurrentFile(), ctxt.getExceptionData());
    }
}

