/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatisticsHandler;
import gov.va.med.fw.mail.MailService;
import gov.va.med.fw.service.AbstractComponent;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.mail.SimpleMailMessage;

public class ProcessStatisticsMailer
extends AbstractComponent
implements ProcessStatisticsHandler {
    public static String DEFAULT_SUBJECT_REPLACEMENT_TOKEN = "@subject@";
    private MailService mailService;
    private SimpleMailMessage messageTemplate;
    private String subjectReplacementToken = DEFAULT_SUBJECT_REPLACEMENT_TOKEN;
    private boolean ignoreEmptyStatistics = false;

    @Override
    public void processStatistics(ProcessStatistics processStatistics) {
        this.processStatistics(processStatistics, processStatistics.getProcessName());
    }

    @Override
    public void processStatisticsWithDynamicRecipients(ProcessStatistics processStatistics, List emailRecipients) {
        this.doProcessStatistics(processStatistics, processStatistics.getProcessName(), emailRecipients.toArray(new String[0]));
    }

    @Override
    public void processStatistics(ProcessStatistics processStatistics, String subjectReplacementValue) {
        this.doProcessStatistics(processStatistics, subjectReplacementValue, null);
    }

    protected void doProcessStatistics(ProcessStatistics processStatistics, String subjectReplacementValue, String[] dynamicEmailRecipients) {
        if (this.ignoreEmptyStatistics && processStatistics.getNumberOfTotalRecords() == 0) {
            return;
        }
        if (this.messageTemplate.getTo() != null || dynamicEmailRecipients != null) {
            SimpleMailMessage template = this.messageTemplate;
            if (StringUtils.isNotBlank((String)this.subjectReplacementToken) && StringUtils.isNotBlank((String)this.messageTemplate.getSubject()) && this.messageTemplate.getSubject().indexOf(this.subjectReplacementToken) != -1) {
                String subject;
                template = new SimpleMailMessage(this.messageTemplate);
                String filteredSubject = subject = template.getSubject().replaceFirst(this.subjectReplacementToken, subjectReplacementValue);
                if (StringUtils.isNotEmpty((String)subject)) {
                    filteredSubject = filteredSubject.replace("\r", "");
                    filteredSubject = filteredSubject.replace("\n", "");
                }
                template.setSubject(filteredSubject);
            }
            if (dynamicEmailRecipients != null) {
                template.setTo(dynamicEmailRecipients);
            }
            this.mailService.send(processStatistics.toFormattedMailString(), template);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Unable to email ProcessStatistics since there is no recipients configured/passed-in");
        }
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.mailService, (String)"A MailService is required");
        Validate.notNull((Object)this.messageTemplate, (String)"A messageTemplate is required");
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public SimpleMailMessage getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(SimpleMailMessage messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public String getSubjectReplacementToken() {
        return this.subjectReplacementToken;
    }

    public void setSubjectReplacementToken(String subjectReplacementToken) {
        this.subjectReplacementToken = subjectReplacementToken;
    }

    public boolean isIgnoreEmptyStatistics() {
        return this.ignoreEmptyStatistics;
    }

    public void setIgnoreEmptyStatistics(boolean ignoreEmptyStatistics) {
        this.ignoreEmptyStatistics = ignoreEmptyStatistics;
    }
}

