/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.ScheduledProcessTriggerEvent;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.QueueDescriptor;
import gov.va.med.fw.service.jms.QueueMessageProducerService;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerIdentity;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.quartz.Trigger;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;

public class BatchProcessInvoker
extends AbstractComponent {
    static String CONFIG_FILE = "config";
    static String CONFIG_SERVER = "server";
    static String CONFIG_CONTEXT = "context";
    static String CONFIG_FACTORY = "factory";
    static String CONFIG_QUEUE = "queue";
    public static final String EXECUTE_FROM_MANAGEMENT_PAGE_FLAG = "EXECUTE_FROM_MANAGEMENT_PAGE_FLAG";
    private TriggerIdentity.DestinationType defaultDestinationType = TriggerIdentity.DestinationType.BATCH_PROCESS;
    private TriggerRouter triggerRouter;
    private List undiscoverableBatchProcessDetails;
    private static Map batchProcessDetails = new TreeMap();

    public Collection getBatchProcessDetails() {
        return batchProcessDetails.values();
    }

    private void initializeBatchProcessDetails() {
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), JobDetailAwareTrigger.class);
        Iterator itr = beans != null ? beans.values().iterator() : null;
        JobDetailAwareTrigger trigger = null;
        BatchProcessDetail detail = null;
        while (itr != null && itr.hasNext()) {
            trigger = (JobDetailAwareTrigger)itr.next();
            if (trigger.getJobDetail() == null) continue;
            detail = new BatchProcessDetail();
            detail.setJobName(trigger.getJobDetail().getName());
            String executeFromManagementPage = (String)trigger.getJobDetail().getJobDataMap().get((Object)EXECUTE_FROM_MANAGEMENT_PAGE_FLAG);
            if (executeFromManagementPage != null) {
                detail.setExecutableFromManagementPage(new Boolean(executeFromManagementPage));
            }
            detail.setJobDescription(trigger.getJobDetail().getDescription());
            detail.setGroupName(trigger.getJobDetail().getGroup());
            detail.setDestinationType(this.defaultDestinationType);
            if (trigger instanceof Trigger) {
                detail.setTriggerName(((Trigger)trigger).getName());
                detail.setTriggerGroup(((Trigger)trigger).getGroup());
            }
            batchProcessDetails.put(detail.getJobName(), detail);
        }
        Iterator<Object> iterator = itr = this.undiscoverableBatchProcessDetails != null ? this.undiscoverableBatchProcessDetails.iterator() : null;
        while (itr != null && itr.hasNext()) {
            detail = (BatchProcessDetail)itr.next();
            batchProcessDetails.put(detail.getJobName(), detail);
        }
    }

    public void invokeBatchProcessWithEvent(String jobName) throws ServiceException {
        BatchProcessDetail detail = (BatchProcessDetail)batchProcessDetails.get(jobName);
        this.invokeBatchProcessWithEvent(detail);
    }

    public BatchProcessDetail getBatchProcessDetail(String jobName) {
        return (BatchProcessDetail)batchProcessDetails.get(jobName);
    }

    public void invokeBatchProcessWithEvent(BatchProcessDetail detail, Object[] invocationArgs) throws ServiceException {
        this.triggerRouter.processTriggerEvent(this.createTriggerEvent(detail, invocationArgs));
    }

    public void invokeBatchProcessWithEvent(BatchProcessDetail detail, ScheduledProcessInvocationContext invContext) throws ServiceException {
        this.triggerRouter.processTriggerEvent(this.createTriggerEvent(detail, invContext));
    }

    public void invokeBatchProcessWithEvent(BatchProcessDetail detail) throws ServiceException {
        this.invokeBatchProcessWithEvent(detail, (Object[])null);
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.triggerRouter, (String)"A TriggerRouter is required");
        this.initializeBatchProcessDetails();
    }

    protected TriggerEvent createTriggerEvent(BatchProcessDetail detail, Object[] invocationArgs) {
        return BatchProcessInvoker.createTriggerEvent(detail, null, invocationArgs, detail.getDestinationType() != null ? detail.getDestinationType() : this.defaultDestinationType);
    }

    protected TriggerEvent createTriggerEvent(BatchProcessDetail detail, ScheduledProcessInvocationContext invContext) {
        return BatchProcessInvoker.createTriggerEvent(detail, invContext, null, detail.getDestinationType() != null ? detail.getDestinationType() : this.defaultDestinationType);
    }

    protected static TriggerEvent createTriggerEvent(BatchProcessDetail detail, ScheduledProcessInvocationContext invContext, Object[] invocationArgs, TriggerIdentity.DestinationType dest) {
        if (invContext == null) {
            String userName;
            invContext = new ScheduledProcessInvocationContext();
            invContext.setJobDetailBeanName(detail.getJobName());
            invContext.setJobName(detail.getJobName());
            invContext.setJobGroup(detail.getGroupName());
            if (invocationArgs != null) {
                invContext.setInvocationArguments(invocationArgs.length == 1 ? invocationArgs[0] : invocationArgs);
            }
            if (StringUtils.isNotBlank((String)(userName = SecurityContextHelper.getUserName()))) {
                invContext.setExecutionContext(userName);
            }
        }
        return new ScheduledProcessTriggerEvent(invContext, TriggerEvent.createTriggerIdentity(dest));
    }

    public static void invokeBatchProcess(String connectionConfigFileName, BatchProcessDetail detail, Object[] executionArgs) {
        TriggerEvent triggerEvent = BatchProcessInvoker.createTriggerEvent(detail, null, executionArgs, detail.getDestinationType());
        QueueMessageProducerService messageProducer = new QueueMessageProducerService();
        messageProducer.setDescriptor(BatchProcessInvoker.getJMSDescriptor(connectionConfigFileName));
        try {
            messageProducer.send(triggerEvent, triggerEvent.getRoutingProperties());
        }
        catch (Exception e) {
            InvalidConfigurationException e2 = new InvalidConfigurationException("Unable to publish TriggerEvent for batch process: " + detail.getJobName());
            e2.initCause(e);
            throw e2;
        }
    }

    protected static QueueDescriptor getJMSDescriptor(String connectionConfigFileName) {
        ResourceBundle bundle = ResourceBundle.getBundle(connectionConfigFileName);
        QueueDescriptor jmsDescriptor = new QueueDescriptor();
        jmsDescriptor.setContextName(bundle.getString(CONFIG_CONTEXT));
        jmsDescriptor.setFactoryName(bundle.getString(CONFIG_FACTORY));
        ArrayList<String> primary = new ArrayList<String>();
        primary.add(bundle.getString(CONFIG_SERVER));
        jmsDescriptor.setProviderURLs(primary);
        jmsDescriptor.setQueueName(bundle.getString(CONFIG_QUEUE));
        return jmsDescriptor;
    }

    private static void fail() {
        System.err.println("\nUsage: java -Djob.name=a -Djob.group=b BatchProcessInvoker [arg1 arg2 ...argN]");
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String jobName = System.getProperty("job.name");
        String jobGroup = System.getProperty("job.group");
        if (StringUtils.isBlank((String)jobName) || StringUtils.isBlank((String)jobGroup)) {
            BatchProcessInvoker.fail();
        }
        BatchProcessDetail detail = new BatchProcessDetail();
        detail.setJobName(jobName);
        detail.setGroupName(jobGroup);
        detail.setDestinationType(TriggerIdentity.DestinationType.DEFAULT);
        String[] invocationArgs = null;
        if (args != null && args.length != 0) {
            invocationArgs = args;
        }
        BatchProcessInvoker.invokeBatchProcess(CONFIG_FILE, detail, invocationArgs);
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public List getUndiscoverableBatchProcessDetails() {
        return this.undiscoverableBatchProcessDetails;
    }

    public void setUndiscoverableBatchProcessDetails(List undiscoverableBatchProcessDetails) {
        this.undiscoverableBatchProcessDetails = undiscoverableBatchProcessDetails;
    }

    public TriggerIdentity.DestinationType getDefaultDestinationType() {
        return this.defaultDestinationType;
    }

    public void setDefaultDestinationType(TriggerIdentity.DestinationType defaultDestinationType) {
        this.defaultDestinationType = defaultDestinationType;
    }
}

