/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import java.util.List;

public abstract class AbstractDataFileSingleRowIncrementProcess
extends AbstractDataFileIncrementalProcess {
    private boolean continueParsingIfErrors = true;
    private boolean keepProcessedData = false;

    @Override
    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        block7: {
            if (acquiredData.isEmpty()) {
                return;
            }
            String rawData = context.getCurrentRowRawData();
            try {
                Object obj = acquiredData.get(0);
                if (this.processDataRecord(context, obj)) {
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    if (this.keepProcessedData) {
                        context.getProcessedData().add(obj);
                    }
                } else {
                    context.getProcessStatistics().incrementNumberOfErrorRecords();
                    context.getExceptionData().add(this.createExceptionObject(rawData));
                }
            }
            catch (RuntimeException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error processing data record: " + rawData), (Throwable)e);
                }
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                context.getExceptionData().add(this.createExceptionObject(rawData));
                if (this.continueParsingIfErrors) break block7;
                throw e;
            }
        }
    }

    protected Object createExceptionObject(String rawData) {
        return rawData;
    }

    protected abstract boolean processDataRecord(DataFileProcessExecutionContext var1, Object var2);

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.setIncrementSize(1);
    }

    public boolean isKeepProcessedData() {
        return this.keepProcessedData;
    }

    public void setKeepProcessedData(boolean keepProcessedData) {
        this.keepProcessedData = keepProcessedData;
    }

    @Override
    protected boolean shouldUpdateJobResult(DataFileProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(5);
    }
}

