/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataFileProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.parser.FileParserListener;
import java.util.List;

public abstract class AbstractDataFileListenerProcess
extends AbstractDataFileProcess
implements FileParserListener {
    public static final String ERROR_KEYWORD = "Error processing data: ";

    @Override
    protected DataProcessExecutionContext createDataProcessExecutionContext() {
        DataFileProcessExecutionContext context = (DataFileProcessExecutionContext)super.createDataProcessExecutionContext();
        context.setFileParserListener(this);
        return context;
    }

    @Override
    public abstract boolean acceptData(DataFileProcessExecutionContext var1, String var2, List var3);

    @Override
    public boolean isInterrupted(DataFileProcessExecutionContext context) {
        return super.isInterrupted(context);
    }

    @Override
    protected final void processData(DataProcessExecutionContext context, List acquiredData) {
        if (acquiredData == null || acquiredData.isEmpty()) {
            return;
        }
        this.processData((DataFileProcessExecutionContext)context, acquiredData);
    }

    @Override
    public final void processData(DataFileProcessExecutionContext context, List acquiredData) {
        this.processDataRecords(context, acquiredData);
        if (this.shouldUpdateJobResult(context)) {
            this.updateJobResult(context);
        }
    }

    public abstract void processDataRecords(DataFileProcessExecutionContext var1, List var2);

    @Override
    public boolean beanCreationFailure(DataFileProcessExecutionContext context, String nextRowRawData, Exception e) {
        context.getProcessStatistics().incrementNumberOfErrorRecords();
        context.getExceptionData().add(ERROR_KEYWORD + context.getCurrentRowRawData() + ".\n" + e.getMessage() + ".\n" + e.getStackTrace().toString());
        return true;
    }

    @Override
    public void beanCreationSuccess(DataFileProcessExecutionContext context, String nextRowRawData) {
    }

    protected boolean shouldUpdateJobResult(DataFileProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(5);
    }
}

