/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external.person;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.ExternalServiceImpl;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilitySummary;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.PersonService;
import gov.va.med.esr.service.external.person.PersonServiceInfo;
import gov.va.med.esr.service.external.person.SimpleEligibilitySummary;
import gov.va.med.esr.service.external.person.VPIDEntityKey;
import gov.va.med.esr.service.external.person.ejb.PersonServiceHome;
import gov.va.med.esr.service.external.person.ejb.RemotePersonService;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

public class PersonServiceImpl
extends ExternalServiceImpl
implements PersonService {
    private static final long serialVersionUID = 1267686755986748702L;

    public BusinessDelegateInfo getBusinessDelegateInterfaceInfo() {
        return new PersonServiceInfo();
    }

    protected EJBObject createEJB(EJBHome home) throws RemoteException, CreateException {
        return ((PersonServiceHome)home).create();
    }

    public void link(VPIDEntityKey deprecatedVPID, VPIDEntityKey survivingVPID) throws ESRException {
        if (!deprecatedVPID.isDeprecated()) {
            throw new ESRException("deprecatedVPID argument is not marked deprecated");
        }
        if (survivingVPID.isDeprecated()) {
            throw new ESRException("survivingVPID argument is marked deprecated");
        }
        try {
            ((RemotePersonService)this.getEJB()).link(deprecatedVPID, survivingVPID);
        }
        catch (Exception e) {
            throw new ESRException("Unable to handle link notification", e);
        }
    }

    public void move(String dfn, String stationNumber, VPIDEntityKey fromVpid, VPIDEntityKey toVpid) throws ESRException {
        if (fromVpid.isDeprecated()) {
            throw new ESRException("fromVpid VPID argument is marked deprecated");
        }
        if (toVpid.isDeprecated()) {
            throw new ESRException("toVpid VPID argument is marked deprecated");
        }
        try {
            ((RemotePersonService)this.getEJB()).move(dfn, stationNumber, fromVpid, toVpid);
        }
        catch (Exception e) {
            throw new ESRException("Unable to handle move  notification", e);
        }
    }

    public EligibilitySummary getEligibilitySummary(VPIDEntityKey vpid) throws ESRException {
        if (vpid == null) {
            throw new ESRException("VPID is null");
        }
        try {
            return ((RemotePersonService)this.getEJB()).getEligibilitySummary(vpid);
        }
        catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

    public SimpleEligibilitySummary getSimpleEligibilitySummary(String ssn) throws ESRException {
        try {
            return ((RemotePersonService)this.getEJB()).getSimpleEligibilitySummary(ssn);
        }
        catch (Exception e) {
            throw new ESRException("Unable to get SimpleEligibilitySummary", e);
        }
    }

    public EESummary getEESummary(EntityFinder arg) throws ESRException {
        if (arg == null) {
            throw new ESRException("arg is null");
        }
        try {
            return ((RemotePersonService)this.getEJB()).getEESummary(arg);
        }
        catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }

    public MSSummary getMSSummary(EntityFinder arg) throws ESRException {
        if (arg == null) {
            throw new ESRException("arg is null");
        }
        try {
            return ((RemotePersonService)this.getEJB()).getMSSummary(arg);
        }
        catch (Exception e) {
            throw new ESRException("Unable to get summary of EE data", e);
        }
    }
}

