/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.external.DemographicSummaryFactory;
import gov.va.med.esr.service.external.ExternalSummaryFactory;
import gov.va.med.esr.service.external.FinancialsSummaryFactory;
import gov.va.med.esr.service.external.MilitaryServiceFactory;
import gov.va.med.esr.service.external.ServiceConnectionAwardFactory;
import gov.va.med.esr.service.external.person.AddressInfo;
import gov.va.med.esr.service.external.person.AssociationInfo;
import gov.va.med.esr.service.external.person.BeneficiaryTravelInfo;
import gov.va.med.esr.service.external.person.CDConditionInfo;
import gov.va.med.esr.service.external.person.CDProcedureInfo;
import gov.va.med.esr.service.external.person.CancelDeclineInfo;
import gov.va.med.esr.service.external.person.CatastrophicDisabilityInfo;
import gov.va.med.esr.service.external.person.DeathRecondInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilityInfo;
import gov.va.med.esr.service.external.person.EligibilityVerificationInfo;
import gov.va.med.esr.service.external.person.EmailInfo;
import gov.va.med.esr.service.external.person.EnrollmentDeterminationInfo;
import gov.va.med.esr.service.external.person.ExternalPerson;
import gov.va.med.esr.service.external.person.FeeBasisInfo;
import gov.va.med.esr.service.external.person.FinancialStatementInfo;
import gov.va.med.esr.service.external.person.IncomeTestInfo;
import gov.va.med.esr.service.external.person.IncompetenceRulingInfo;
import gov.va.med.esr.service.external.person.IneligibilityFactorInfo;
import gov.va.med.esr.service.external.person.InsuranceInfo;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.MilitarySexualTraumaInfo;
import gov.va.med.esr.service.external.person.MonetaryBenefitAwardInfo;
import gov.va.med.esr.service.external.person.MonetaryBenefitInfo;
import gov.va.med.esr.service.external.person.NoseThroatRadiumInfo;
import gov.va.med.esr.service.external.person.PIIData;
import gov.va.med.esr.service.external.person.PhoneInfo;
import gov.va.med.esr.service.external.person.RelationInfo;
import gov.va.med.esr.service.external.person.SpecialFactorsInfo;
import gov.va.med.esr.service.external.person.SpinalCordInjuryInfo;
import gov.va.med.esr.service.external.person.collections.AddressCollection;
import gov.va.med.esr.service.external.person.collections.AssociationCollection;
import gov.va.med.esr.service.external.person.collections.BeneficiaryTravelCollection;
import gov.va.med.esr.service.external.person.collections.CDConditionCollection;
import gov.va.med.esr.service.external.person.collections.CDDiagnosisCollection;
import gov.va.med.esr.service.external.person.collections.CDProcedureCollection;
import gov.va.med.esr.service.external.person.collections.ConfidentialAddressCategoryCollection;
import gov.va.med.esr.service.external.person.collections.EligibilityCollection;
import gov.va.med.esr.service.external.person.collections.EmailCollection;
import gov.va.med.esr.service.external.person.collections.FeeBasisCollection;
import gov.va.med.esr.service.external.person.collections.InsuranceCollection;
import gov.va.med.esr.service.external.person.collections.MonetaryBenefitCollection;
import gov.va.med.esr.service.external.person.collections.PhoneCollection;
import gov.va.med.esr.service.external.person.collections.RaceCollection;
import gov.va.med.esr.service.external.person.collections.RelationCollection;
import gov.va.med.fw.service.AbstractComponent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExternalSummaryFactoryImpl
extends AbstractComponent
implements ExternalSummaryFactory {
    private PersonHelperService personHelperService = null;
    private FinancialsSummaryFactory financialsSummaryFactory = null;
    private DemographicSummaryFactory demographicSummaryFactory = null;
    private MilitaryServiceFactory militaryServiceFactory;
    private ServiceConnectionAwardFactory serviceConnectionAwardFactory;
    static /* synthetic */ Class class$gov$va$med$esr$common$model$ee$NoseThroatRadium;
    static /* synthetic */ Class class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma;
    static /* synthetic */ Class class$gov$va$med$esr$common$model$ee$SpinalCordInjury;

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public FinancialsSummaryFactory getFinancialsSummaryFactory() {
        return this.financialsSummaryFactory;
    }

    public void setFinancialsSummaryFactory(FinancialsSummaryFactory financialsSummaryFactory) {
        this.financialsSummaryFactory = financialsSummaryFactory;
    }

    public DemographicSummaryFactory getDemographicSummaryFactory() {
        return this.demographicSummaryFactory;
    }

    public void setDemographicSummaryFactory(DemographicSummaryFactory demographicSummaryFactory) {
        this.demographicSummaryFactory = demographicSummaryFactory;
    }

    public MilitaryServiceFactory getMilitaryServiceFactory() {
        return this.militaryServiceFactory;
    }

    public void setMilitaryServiceFactory(MilitaryServiceFactory militaryServiceFactory) {
        this.militaryServiceFactory = militaryServiceFactory;
    }

    public ServiceConnectionAwardFactory getServiceConnectionAwardFactory() {
        return this.serviceConnectionAwardFactory;
    }

    public void setServiceConnectionAwardFactory(ServiceConnectionAwardFactory serviceConnectionAwardFactory) {
        this.serviceConnectionAwardFactory = serviceConnectionAwardFactory;
    }

    private PIIData extractPII(Person person) {
        BirthRecord birthRec;
        PersonIdentityTraits traits;
        PIIData pii = new PIIData();
        Boolean veteranInd = person.isVeteran();
        if (veteranInd == null) {
            veteranInd = new Boolean(false);
        }
        pii.setVpid((traits = person.getIdentityTraits()).getVpid() != null ? traits.getVpid().getKeyValueAsString() : null);
        Name legalName = traits.getLegalName();
        if (legalName != null) {
            pii.setFirstName(legalName.getGivenName());
            pii.setLastName(legalName.getFamilyName());
            pii.setMiddleName(legalName.getMiddleName());
        }
        if ((birthRec = traits.getBirthRecord()) != null) {
            pii.setDob(birthRec.getBirthDate() != null ? birthRec.getBirthDate().toStandardFormat() : null);
        }
        pii.setGender(traits.getGender() != null ? traits.getGender().getDescription() : null);
        pii.setMaskedSsn(traits.getSsnText());
        return pii;
    }

    protected void applyCommonData(Person person, ExternalPerson result) {
        Boolean veteranInd = person.isVeteran();
        if (veteranInd == null) {
            veteranInd = new Boolean(false);
        }
        result.setVeteran(veteranInd);
        result.setPiiData(this.extractPII(person));
    }

    public EESummary buildEESummary(Person person) {
        RelationInfo[] relations;
        PhoneInfo[] phones;
        EmailInfo[] emails;
        String[] confidentialAddressTypes;
        AddressInfo[] addresses;
        if (person == null) {
            return null;
        }
        EESummary summary = new EESummary();
        this.setBaseFields(person, summary);
        this.applyNSTData(person, summary);
        this.applyBeneficiaryTravel(person, summary);
        this.setCDInfo(person, summary);
        this.applyEligibilityVerificationInfo(person, summary);
        this.applyMonetaryBenefitAward(person, summary);
        this.applySpecialFactors(person, summary);
        this.applyMilitarySexualTrauma(person, summary);
        this.applyEnrollmentDeterminationInfo(person, summary);
        this.applyCancelDecline(person, summary);
        summary.setMilitaryServiceInfo(this.militaryServiceFactory.getMilitaryServiceInfo(person));
        IncomeTestInfo incomeTest = this.financialsSummaryFactory.getIncomeTestInfo(person);
        summary.setIncomeTest(incomeTest);
        if (incomeTest != null && incomeTest.getIncomeYear() != null) {
            FinancialStatementInfo fStatement = this.financialsSummaryFactory.getFinancialStatement(person, incomeTest.getIncomeYear());
            summary.setFinancialStatement(fStatement);
        }
        summary.setServiceConnectionAward(this.serviceConnectionAwardFactory.buildServiceConnectionAward(person));
        this.applyIncompetenceRulingInfo(person, summary);
        this.applyDeathRecord(person, summary);
        this.applyIneligibilityFactor(person, summary);
        summary.setPrisonerOfWarInfo(this.militaryServiceFactory.getPOWInfo(person));
        summary.setPurpleHeart(this.militaryServiceFactory.getPurpleHeartInfo(person));
        this.applySpinalCardInjury(person, summary);
        AssociationInfo[] associations = this.demographicSummaryFactory.buildContacts(person);
        if (associations != null) {
            summary.setAssociations(new AssociationCollection(associations));
        }
        if ((addresses = this.demographicSummaryFactory.buildAddress(person)) != null) {
            summary.setAddresses(new AddressCollection(addresses));
        }
        if ((confidentialAddressTypes = this.demographicSummaryFactory.buildConfidentialAddressCategories(person)) != null) {
            summary.setConfidentialAddressCategories(new ConfidentialAddressCategoryCollection(confidentialAddressTypes));
        }
        if ((emails = this.demographicSummaryFactory.applyEmailData(person)) != null && emails.length > 0) {
            summary.setEmails(new EmailCollection(emails));
        }
        if ((phones = this.demographicSummaryFactory.buildPhones(person)) != null && phones.length > 0) {
            summary.setPhones(new PhoneCollection(phones));
        }
        if ((relations = this.demographicSummaryFactory.buildRelations(person)) != null && relations.length > 0) {
            summary.setRelations(new RelationCollection(relations));
        }
        summary.setEmploymentInfo(this.demographicSummaryFactory.buildEmployment(person));
        this.applyFeeBasis(person, summary);
        InsuranceInfo[] insurances = this.demographicSummaryFactory.buildInsurance(person);
        if (insurances != null && insurances.length > 0) {
            summary.setInsuranceList(new InsuranceCollection(insurances));
        }
        return summary;
    }

    public MSSummary buildMSSummary(Person person) {
        MilitaryService ms;
        if (person == null) {
            return null;
        }
        MSSummary summary = new MSSummary();
        this.applyCommonData(person, summary);
        if (person.getPrisonerOfWar() != null) {
            Indicator powIndicator = person.getPrisonerOfWar().getPowIndicator();
            summary.setPOWStatusIndicated(powIndicator != null ? powIndicator.toBoolean() : null);
        }
        if ((ms = person.getMilitaryService()) != null) {
            Set siteRecords = ms.getMilitaryServiceSiteRecords();
            Iterator itr = siteRecords != null ? siteRecords.iterator() : null;
            MilitaryServiceSiteRecord latestSiteRec = null;
            MilitaryServiceSiteRecord siteRec = null;
            while (itr != null && itr.hasNext()) {
                siteRec = (MilitaryServiceSiteRecord)itr.next();
                if (latestSiteRec == null) {
                    latestSiteRec = siteRec;
                    continue;
                }
                if (!latestSiteRec.getCreatedOn().before(siteRec.getCreatedOn())) continue;
                latestSiteRec = siteRec;
            }
            if (latestSiteRec != null) {
                summary.setPeriodOfServiceCode(latestSiteRec.getServicePeriod() != null ? latestSiteRec.getServicePeriod().getName() : null);
                Set episodes = latestSiteRec.getMilitaryServiceEpisodes();
                itr = episodes != null ? episodes.iterator() : null;
                MilitaryServiceEpisode latestEpisode = null;
                MilitaryServiceEpisode episode = null;
                while (itr != null && itr.hasNext()) {
                    episode = (MilitaryServiceEpisode)itr.next();
                    if (latestEpisode == null) {
                        latestEpisode = episode;
                        continue;
                    }
                    if (latestEpisode.getEndDate() == null || latestEpisode.getEndDate().compareTo(episode.getEndDate()) >= 0) continue;
                    latestEpisode = episode;
                }
                if (latestEpisode != null) {
                    summary.setLastServiceBranchCode(latestEpisode.getServiceBranch() != null ? latestEpisode.getServiceBranch().getDescription() : null);
                    summary.setLastServiceNumber(latestEpisode.getServiceNumber());
                    summary.setLastServiceEntryDate(latestEpisode.getStartDate() != null ? latestEpisode.getStartDate().toStandardFormat() : null);
                    summary.setLastServiceSeparationDate(latestEpisode.getEndDate() != null ? latestEpisode.getEndDate().toStandardFormat() : null);
                }
            }
        }
        return summary;
    }

    private void applyNSTData(Person person, EESummary summary) {
        NoseThroatRadium ntr = (NoseThroatRadium)this.getClinicalDetermination(class$gov$va$med$esr$common$model$ee$NoseThroatRadium == null ? (class$gov$va$med$esr$common$model$ee$NoseThroatRadium = ExternalSummaryFactoryImpl.class$("gov.va.med.esr.common.model.ee.NoseThroatRadium")) : class$gov$va$med$esr$common$model$ee$NoseThroatRadium, person);
        if (ntr == null) {
            return;
        }
        NoseThroatRadiumInfo ntrinfo = new NoseThroatRadiumInfo();
        ntrinfo.setVerificationDate(ntr.getVerificationDate());
        if (ntr.getVerificationMethod() != null) {
            ntrinfo.setVerificationMethod(ntr.getVerificationMethod().getDescription());
        }
        if (ntr.getVerificationFacility() != null) {
            ntrinfo.setVerificationFacility(ntr.getVerificationFacility().getSiteNumberAndName());
        }
        if (ntr.getDeterminationFacility() != null) {
            ntrinfo.setDeterminationFacility(ntr.getDeterminationFacility().getSiteNumberAndName());
        }
        if (ntr.getReceivingTreatment() != null) {
            ntrinfo.setReceivingTreatment(ntr.getReceivingTreatment().toString());
        }
        ntrinfo.setFromAviatorServiceBefore1955(ntr.getFromAviatorServiceBefore1955());
        ntrinfo.setFromSubmarinerServiceBefore1965(ntr.getFromSubmarinerServiceBefore1965());
        ntrinfo.setDiagnosedWithCancer(ntr.getDiagnosedWithCancer());
        ntrinfo.setDiagnosisVerifiedDate(ntr.getDiagnosisVerifiedDate());
        summary.setNoseThroatRadiumInfo(ntrinfo);
    }

    private void applyMilitarySexualTrauma(Person person, EESummary summary) {
        MilitarySexualTrauma mst = (MilitarySexualTrauma)this.getClinicalDetermination(class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma == null ? (class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma = ExternalSummaryFactoryImpl.class$("gov.va.med.esr.common.model.ee.MilitarySexualTrauma")) : class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma, person);
        if (mst == null) {
            return;
        }
        MilitarySexualTraumaInfo mstInfo = new MilitarySexualTraumaInfo();
        mstInfo.setDeterminationFacility(mst.getDeterminationFacility() != null ? mst.getDeterminationFacility().getSiteNumberAndName() : null);
        mstInfo.setStatus(mst.getStatus() != null ? mst.getStatus().getDescription() : null);
        mstInfo.setStatusChangeDate(mst.getStatusChangeDate());
        summary.setMilitarySexualTraumaInfo(mstInfo);
    }

    private void applySpinalCardInjury(Person person, EESummary summary) {
        SpinalCordInjury sc = (SpinalCordInjury)this.getClinicalDetermination(class$gov$va$med$esr$common$model$ee$SpinalCordInjury == null ? (class$gov$va$med$esr$common$model$ee$SpinalCordInjury = ExternalSummaryFactoryImpl.class$("gov.va.med.esr.common.model.ee.SpinalCordInjury")) : class$gov$va$med$esr$common$model$ee$SpinalCordInjury, person);
        if (sc == null) {
            return;
        }
        SpinalCordInjuryInfo scInfo = new SpinalCordInjuryInfo();
        scInfo.setDeterminationFacility(sc.getDeterminationFacility() != null ? sc.getDeterminationFacility().getSiteNumberAndName() : null);
        scInfo.setSpinalCordInjuryType(sc.getSpinalCordInjuryType() != null ? sc.getSpinalCordInjuryType().getDescription() : null);
        summary.setSpinalCordInjuryInfo(scInfo);
    }

    private void applyBeneficiaryTravel(Person person, EESummary summary) {
        Map travels = person.getBeneficiaryTravels();
        if (travels == null || travels.size() <= 0) {
            return;
        }
        BeneficiaryTravelInfo[] beneficiaryTravels = new BeneficiaryTravelInfo[travels.size()];
        Iterator travelIter = travels.values().iterator();
        int i = 0;
        while (travelIter.hasNext()) {
            BeneficiaryTravel travel = (BeneficiaryTravel)travelIter.next();
            BeneficiaryTravelInfo travelInfo = new BeneficiaryTravelInfo();
            travelInfo.setDateCertified(travel.getDateCertified());
            travelInfo.setAmountCertified(travel.getAmountCertified());
            travelInfo.setEligible(travel.getEligible());
            beneficiaryTravels[i] = travelInfo;
            ++i;
        }
        if (beneficiaryTravels != null && beneficiaryTravels.length > 0) {
            summary.setBeneficiaryTravels(new BeneficiaryTravelCollection(beneficiaryTravels));
        }
    }

    private void setCDInfo(Person person, EESummary summary) {
        int i;
        CatastrophicDisability cd = person.getCatastrophicDisability();
        if (cd == null) {
            return;
        }
        CatastrophicDisabilityInfo cdInfo = new CatastrophicDisabilityInfo();
        cdInfo.setReviewDate(cd.getReviewDate());
        cdInfo.setDeterminedBy(cd.getDeterminedBy());
        if (cd.getDeterminationFacility() != null) {
            cdInfo.setDeterminationFacility(cd.getDeterminationFacility().getSiteNumberAndName());
        }
        cdInfo.setDecisionDate(cd.getDecisionDate());
        if (cd.getDeterminationMethod() != null) {
            cdInfo.setDeterminationMethod(cd.getDeterminationMethod().getDescription());
        }
        cdInfo.setVeteranRequestedCDReviewDate(cd.getVeteranRequestedCDReviewDate());
        cdInfo.setVeteranWasNotifiedCDDate(cd.getVeteranWasNotifiedCDDate());
        cdInfo.setCatastrophicallyDisabled(cd.getCatastrophicallyDisabled());
        if (cd.getDiagnoses() != null) {
            Set diagnoses = cd.getDiagnoses();
            String[] diagArr = new String[diagnoses.size()];
            Iterator diagIter = diagnoses.iterator();
            i = 0;
            while (diagIter.hasNext()) {
                String d;
                CDDiagnosis cdDiagnosis = (CDDiagnosis)diagIter.next();
                Diagnosis diagnosis = cdDiagnosis.getDiagnosis();
                diagArr[i] = d = diagnosis.getDescription();
                ++i;
            }
            if (diagArr != null && diagArr.length > 0) {
                cdInfo.setDiagnoses(new CDDiagnosisCollection(diagArr));
            }
        }
        if (cd.getProcedures() != null) {
            Set procedures = cd.getProcedures();
            Iterator procedureItr = procedures.iterator();
            CDProcedureInfo[] procedureArr = new CDProcedureInfo[procedures.size()];
            i = 0;
            while (procedureItr.hasNext()) {
                CDProcedure p = (CDProcedure)procedureItr.next();
                CDProcedureInfo pInfo = new CDProcedureInfo();
                if (p.getProcedure() != null) {
                    pInfo.setProcedure(p.getProcedure().getDescription());
                }
                if (p.getAffectedExtremity() != null) {
                    pInfo.setAffectedExtremity(p.getAffectedExtremity().getDescription());
                }
                procedureArr[i] = pInfo;
                ++i;
            }
            if (procedureArr != null && procedureArr.length > 0) {
                cdInfo.setCdProcedures(new CDProcedureCollection(procedureArr));
            }
        }
        if (cd.getConditions() != null) {
            Set conditions = cd.getConditions();
            Iterator conditionsItr = conditions.iterator();
            CDConditionInfo[] conditionArr = new CDConditionInfo[conditions.size()];
            i = 0;
            while (conditionsItr.hasNext()) {
                CDCondition c = (CDCondition)conditionsItr.next();
                CDConditionInfo cInfo = new CDConditionInfo();
                if (c.getCondition() != null) {
                    cInfo.setCondition(c.getCondition().getName());
                }
                if (c.getPermanentIndicator() != null) {
                    cInfo.setPermanentIndicator(c.getPermanentIndicator().toBoolean());
                }
                cInfo.setScore(c.getScore());
                conditionArr[i] = cInfo;
                ++i;
            }
            if (conditionArr != null) {
                cdInfo.setCdConditions(new CDConditionCollection(conditionArr));
            }
        }
        summary.setCatastrophicDisabilityInfo(cdInfo);
    }

    private void applyEnrollmentDeterminationInfo(Person person, EESummary summary) {
        EligibilityInfo[] otherEligibilities;
        EligibilityInfo[] secEligibilities;
        EligibilityInfo[] primaryEligibilities;
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed == null) {
            return;
        }
        EnrollmentDeterminationInfo edInfo = new EnrollmentDeterminationInfo();
        if (ed.getPriorityGroup() != null) {
            edInfo.setPriorityGroup(ed.getPriorityGroup().getDescription());
        }
        if (ed.getPrioritySubGroup() != null) {
            edInfo.setPrioritySubGroup(ed.getPrioritySubGroup().getDescription());
        }
        if (ed.getCalculationSource() != null) {
            edInfo.setCalculationSource(ed.getCalculationSource().getDescription());
        }
        if (ed.getEnrollmentStatus() != null) {
            edInfo.setEnrollmentStatus(ed.getEnrollmentStatus().getName());
        }
        edInfo.setEnrollmentDate(ed.getEffectiveDate());
        edInfo.setEndDate(ed.getEndDate());
        if (ed.getFacilityReceived() != null) {
            edInfo.setFacilityReceived(ed.getFacilityReceived().getSiteNumberAndName());
        }
        edInfo.setEnrollmentDate(ed.getEnrollmentDate());
        edInfo.setEndDate(ed.getEndDate());
        HashSet<Eligibility> pEligibilitySet = new HashSet<Eligibility>();
        if (ed.getPrimaryEligibility() != null) {
            pEligibilitySet.add(ed.getPrimaryEligibility());
        }
        if ((primaryEligibilities = this.getEligibilities(pEligibilitySet)) != null && primaryEligibilities.length == 1) {
            edInfo.setPrimaryEligibility(primaryEligibilities[0]);
        }
        if ((secEligibilities = this.getEligibilities(ed.getSecondaryEligibilities())) != null && secEligibilities.length > 0) {
            edInfo.setSecondaryEligibilities(new EligibilityCollection(secEligibilities));
        }
        if ((otherEligibilities = this.getEligibilities(ed.getOtherEligibilities())) != null && otherEligibilities.length > 0) {
            edInfo.setOtherEligibilities(new EligibilityCollection(otherEligibilities));
        }
        summary.setEnrollmentDeterminationInfo(edInfo);
    }

    private EligibilityInfo[] getEligibilities(Set eligibilities) {
        if (eligibilities == null && eligibilities.size() <= 0) {
            return null;
        }
        Iterator eligIterator = eligibilities.iterator();
        EligibilityInfo[] eInfos = new EligibilityInfo[eligibilities.size()];
        int i = 0;
        while (eligIterator.hasNext()) {
            Eligibility e = (Eligibility)eligIterator.next();
            EligibilityInfo eInfo = new EligibilityInfo();
            if (e.getType() != null) {
                eInfo.setType(e.getType().getDescription());
            }
            eInfo.setIndicator(e.getIndicator());
            eInfos[i] = eInfo;
            ++i;
        }
        return eInfos;
    }

    private void applyEligibilityVerificationInfo(Person person, EESummary summary) {
        EligibilityVerification ev = person.getEligibilityVerification();
        if (ev == null) {
            return;
        }
        EligibilityVerificationInfo evInfo = new EligibilityVerificationInfo();
        evInfo.setVerificationMethod(ev.getVerificationMethod());
        if (ev.getEligibilityStatus() != null) {
            evInfo.setEligibilityStatus(ev.getEligibilityStatus().getDescription());
        }
        if (ev.getEligibilityStatusDate() != null) {
            evInfo.setEligibilityStatusDate(ev.getEligibilityStatusDate().getStandardFormat());
        }
        summary.setEligibilityVerificationInfo(evInfo);
    }

    private void applyMonetaryBenefitAward(Person person, EESummary summary) {
        MonetaryBenefitAward mAward = person.getMonetaryBenefitAward();
        if (mAward == null) {
            return;
        }
        MonetaryBenefitAwardInfo mAwardInfo = new MonetaryBenefitAwardInfo();
        mAwardInfo.setCheckAmount(mAward.getCheckAmount());
        Set mBenefits = mAward.getMonetaryBenefits();
        int setSize = 0;
        Iterator mBenefitsItr = null;
        if (mBenefits != null) {
            mBenefitsItr = mBenefits.iterator();
            setSize = mBenefits.size();
        }
        MonetaryBenefitInfo[] mBenefitInfos = new MonetaryBenefitInfo[setSize];
        int i = 0;
        while (mBenefitsItr != null && mBenefitsItr.hasNext()) {
            MonetaryBenefit mBenefit = (MonetaryBenefit)mBenefitsItr.next();
            MonetaryBenefitInfo mBenefitInfo = new MonetaryBenefitInfo();
            if (mBenefit.getMonetaryBenefitIndicator() != null) {
                mBenefitInfo.setMonetaryBenefitIndicator(mBenefit.getMonetaryBenefitIndicator().toBoolean());
            }
            mBenefitInfo.setType(mBenefit.getType() != null ? mBenefit.getType().getDescription() : null);
            mBenefitInfos[i] = mBenefitInfo;
            ++i;
        }
        if (mBenefitInfos != null && mBenefitInfos.length > 0) {
            mAwardInfo.setMonetaryBenefits(new MonetaryBenefitCollection(mBenefitInfos));
        }
        summary.setMonetaryBenefitAwardInfo(mAwardInfo);
    }

    private void applySpecialFactors(Person person, EESummary summary) {
        Set specialFactors = person.getSpecialFactors();
        if (specialFactors == null) {
            return;
        }
        SpecialFactorsInfo specialFactorInfo = new SpecialFactorsInfo();
        Iterator sfIterator = specialFactors.iterator();
        while (sfIterator.hasNext()) {
            EnvironmentalContaminationExposure ec;
            SpecialFactor sf = (SpecialFactor)sfIterator.next();
            if (sf instanceof AgentOrangeExposure) {
                AgentOrangeExposure ao = (AgentOrangeExposure)sf;
                if (ao.getAgentOrangeExposureIndicator() != null) {
                    specialFactorInfo.setAgentOrangeInd(ao.getAgentOrangeExposureIndicator().toBoolean());
                }
                if (ao.getLocation() == null) continue;
                specialFactorInfo.setAgentOrangeLocation(ao.getLocation().getDescription());
                continue;
            }
            if (sf instanceof RadiationExposure) {
                RadiationExposure re = (RadiationExposure)sf;
                if (re.getRadiationExposureIndicator() != null) {
                    specialFactorInfo.setRadiationExposureInd(re.getRadiationExposureIndicator().toBoolean());
                }
                if (re.getExposureMethod() == null) continue;
                specialFactorInfo.setRadiationExposureMethod(re.getExposureMethod().getDescription());
                continue;
            }
            if (!(sf instanceof EnvironmentalContaminationExposure) || (ec = (EnvironmentalContaminationExposure)sf).getEnvironmentalContaminationExposureIndicator() == null) continue;
            specialFactorInfo.setEnvContaminantsInd(ec.getEnvironmentalContaminationExposureIndicator().toBoolean());
        }
        summary.setSpecialFactors(specialFactorInfo);
    }

    private void setBaseFields(Person person, EESummary summary) {
        Set races;
        summary.setSensitivityChangeDate(person.getSensitivityChangeDate());
        if (person.getSensitivityChangeSite() != null) {
            summary.setSensitivityChangeSite(person.getSensitivityChangeSite().getSiteNumberAndName());
        }
        if (person.getSensitivityChangeSource() != null) {
            summary.setSensitivityChangeSource(person.getSensitivityChangeSource().getDescription());
        }
        if ((races = person.getRaces()) != null) {
            String[] raceInfos = new String[races.size()];
            Iterator raceIter = races.iterator();
            int i = 0;
            while (raceIter.hasNext()) {
                Race race = (Race)raceIter.next();
                raceInfos[i] = race.getRaceType().getName();
                ++i;
            }
            if (raceInfos != null && raceInfos.length > 0) {
                summary.setRaces(new RaceCollection(raceInfos));
            }
        }
        if (person.getMaritalStatus() != null) {
            summary.setMaritalStatus(person.getMaritalStatus().getName());
        }
        if (person.getReligion() != null) {
            summary.setReligion(person.getReligion().getName());
        }
        if (person.getEthnicity() != null && person.getEthnicity().getEthnicityType() != null) {
            summary.setEthnicity(person.getEthnicity().getEthnicityType().getName());
        }
        if (person.getApplication() != null) {
            summary.setApplicationDate(person.getApplication().getApplicationDate());
        }
        summary.setAppointmentRequestDate(person.getAppointmentRequestDate());
        summary.setAppointmentRequestResponse(person.getAppointmentRequestResponse());
        summary.setClaimFolderNumber(person.getClaimFolderNumber());
        if (person.getClaimFolderLocation() != null) {
            summary.setClaimFolderLocation(person.getClaimFolderLocation().getSiteNumberAndName());
        }
        summary.setVeteran(person.getVeteran());
        if (person.getPreferredFacility() != null) {
            summary.setPreferredFacility(person.getPreferredFacility().getSiteNumberAndName());
        }
        summary.setUserEnrolleeValidThrough(person.getUserEnrolleeValidThrough());
        summary.setUserEnrolleeSite(person.getUserEnrolleeSite() != null ? person.getUserEnrolleeSite().getSiteNumberAndName() : null);
        if (person.getShad() != null && person.getShad().getShadIndicator() != null) {
            summary.setShadIndicator(person.getShad().getShadIndicator().toBoolean());
        }
        summary.setEligibleForMedicaid(person.getMedicaidFactor() != null ? person.getMedicaidFactor().getEligibleForMedicaid() : null);
    }

    private void applyDeathRecord(Person person, EESummary eeSummary) {
        DeathRecord dr = person.getDeathRecord();
        if (dr == null) {
            return;
        }
        DeathRecondInfo drInfo = new DeathRecondInfo();
        drInfo.setDataSource(dr.getDataSource() != null ? dr.getDataSource().getDescription() : null);
        drInfo.setDeathDate(dr.getDeathDate() != null ? dr.getDeathDate().getStandardFormat() : null);
        drInfo.setDeathLastModified(dr.getDeathLastModified());
        drInfo.setDeathReportDate(dr.getDeathReportDate());
        drInfo.setFacilityReceived(dr.getFacilityReceived() != null ? dr.getFacilityReceived().getSiteNumberAndName() : null);
        eeSummary.setDeathRecond(drInfo);
    }

    private void applyIneligibilityFactor(Person person, EESummary eeSummary) {
        IneligibilityFactor ieFactor = person.getIneligibilityFactor();
        if (ieFactor == null) {
            return;
        }
        IneligibilityFactorInfo iefInfo = new IneligibilityFactorInfo();
        iefInfo.setFacilityReceived(ieFactor.getFacilityReceived() != null ? ieFactor.getFacilityReceived().getSiteNumberAndName() : null);
        iefInfo.setIneligibleDate(ieFactor.getIneligibleDate());
        iefInfo.setReason(ieFactor.getReason());
        iefInfo.setVaroDecision(ieFactor.getVaroDecision());
        eeSummary.setIneligibilityFactor(iefInfo);
    }

    private void applyIncompetenceRulingInfo(Person person, EESummary eeSummary) {
        IncompetenceRuling ruling = person.getIncompetenceRuling();
        if (ruling == null) {
            return;
        }
        IncompetenceRulingInfo rulingInfo = new IncompetenceRulingInfo();
        rulingInfo.setIncompetent(ruling.getIncompetent());
        eeSummary.setIncompetenceRulingInfo(rulingInfo);
    }

    private void applyCancelDecline(Person person, EESummary summary) {
        CancelDecline cd = person.getCancelDecline();
        if (cd == null) {
            return;
        }
        CancelDeclineInfo cdInfo = new CancelDeclineInfo();
        cdInfo.setCancelDeclineIndicator(cd.getCancelDeclineIndicator());
        cdInfo.setReason(cd.getReason() != null ? cd.getReason().getDescription() : null);
        cdInfo.setRemarks(cd.getRemarks());
        summary.setCancelDeclineInfo(cdInfo);
    }

    private void applyFeeBasis(Person person, EESummary summary) {
        Set feeBaseSet = person.getFeeBasis();
        if (feeBaseSet != null && feeBaseSet.size() > 0) {
            Iterator itr = feeBaseSet != null ? feeBaseSet.iterator() : null;
            int count = 0;
            FeeBasisInfo[] feeBasisInfoArray = new FeeBasisInfo[feeBaseSet.size()];
            while (itr != null && itr.hasNext()) {
                FeeBasis feeBasis = (FeeBasis)itr.next();
                if (feeBasis == null) continue;
                FeeBasisInfo feeBasisInfo = new FeeBasisInfo();
                feeBasisInfo.setAuthorizationFromDate(feeBasis.getAuthorizationFromDate());
                feeBasisInfo.setAuthorizationToDate(feeBasis.getAuthorizationToDate());
                feeBasisInfo.setReportDate(feeBasis.getReportDate());
                feeBasisInfo.setReportSite(feeBasis.getReportSite() != null ? feeBasis.getReportSite().getSiteNumberAndName() : null);
                feeBasisInfo.setTreatmentType(feeBasis.getTreatmentType() != null ? feeBasis.getTreatmentType().getDescription() : null);
                feeBasisInfo.setProgram(feeBasis.getProgram() != null ? feeBasis.getProgram().getDescription() : null);
                feeBasisInfoArray[count] = feeBasisInfo;
                ++count;
            }
            if (feeBasisInfoArray != null && feeBasisInfoArray.length > 0) {
                summary.setFeeBasisList(new FeeBasisCollection(feeBasisInfoArray));
            }
        }
    }

    public ClinicalDetermination getClinicalDetermination(Class classObject, Person person) {
        if (person == null) {
            return null;
        }
        Set clinicalDeterminations = person.getClinicalDeterminations();
        ClinicalDetermination clinicalDetermination = null;
        if (clinicalDeterminations != null && clinicalDeterminations.size() > 0) {
            Iterator iterClinicalDeterminations = clinicalDeterminations.iterator();
            while (iterClinicalDeterminations.hasNext()) {
                ClinicalDetermination temp = (ClinicalDetermination)iterClinicalDeterminations.next();
                if (temp == null || !temp.getClass().isAssignableFrom(classObject)) continue;
                clinicalDetermination = temp;
                break;
            }
        }
        return clinicalDetermination;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

