/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.webservices.client.vadir;

import gov.va.med.esr.webservices.client.vadir.VadirWSClient;
import gov.va.schema.militaryhistory.MilitaryHistory;
import gov.va.schema.militaryhistory.ServicePeriod;
import gov.va.schema.militaryhistoryservice.GetMilitaryHistory;
import gov.va.schema.militaryhistoryservice.GetMilitaryHistoryResponse;
import gov.va.schema.militaryhistoryservice.SearchCriteria;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Repository;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.core.WebServiceTemplate;

@Repository(value="vadirWSClient")
public class VadirWSClientImpl
implements VadirWSClient {
    @Autowired
    private WebServiceTemplate vadirWebServiceTemplate;

    public MilitaryHistory getMilitaryHistory(SearchCriteria searchCriteria) throws WebServiceClientException {
        GetMilitaryHistory request = new GetMilitaryHistory();
        request.setCriteria(searchCriteria);
        Object resultObj = this.vadirWebServiceTemplate.marshalSendAndReceive((Object)request);
        if (!(resultObj instanceof GetMilitaryHistoryResponse)) {
            throw new RuntimeException("Unexpected type returned from web service: " + resultObj.getClass());
        }
        GetMilitaryHistoryResponse response = (GetMilitaryHistoryResponse)resultObj;
        return response.getGetMilitaryHistoryReturn();
    }

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("/spring/applicationContext-vadir.xml");
        VadirWSClientImpl client = (VadirWSClientImpl)appContext.getBean("vadirWSClient");
        DatatypeFactory dtf = DatatypeFactory.newInstance();
        try {
            SearchCriteria sc = new SearchCriteria();
            sc.setSSN("810907001");
            sc.setLastName("JOHNSON");
            sc.setDateOfBirth(dtf.newXMLGregorianCalendar("1952-03-10"));
            sc.setICN("1234567890");
            MilitaryHistory mh = client.getMilitaryHistory(sc);
            if (mh == null) {
                System.out.println("No results found.");
            } else {
                System.out.println(ToStringBuilder.reflectionToString((Object)mh, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
                System.out.println("\nService Periods:");
                for (ServicePeriod period : mh.getVADIR().getServicePeriods()) {
                    System.out.println(ToStringBuilder.reflectionToString((Object)period, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

