/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.jms.vadir;

import gov.va.med.esr.jms.vadir.StubTranslationService;
import gov.va.med.esr.jms.vadir.inboundRequest.VadirServiceMilitaryHistoryRequest;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.webservices.client.vadir.VadirWSClient;
import gov.va.schema.militaryhistoryservice.SearchCriteria;
import java.io.Serializable;
import java.util.GregorianCalendar;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.stereotype.Component;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.WebServiceTransformerException;

@Component
public class VadirRequestJMSListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(VadirRequestJMSListener.class);
    @Autowired
    private VadirWSClient client;
    @Resource(name="vadirOutboundJMSTemplate")
    private JmsTemplate jmsTemplate;
    @Autowired
    private StubTranslationService stubTranslationService;

    public void onMessage(Message message) {
        log.trace("Received JMS message {}", (Object)message);
        if (!(message instanceof ObjectMessage)) {
            this.sendErrorResponse(0L, "Message must be of type " + ObjectMessage.class.getName());
            return;
        }
        ObjectMessage om = (ObjectMessage)message;
        Serializable o = null;
        try {
            o = om.getObject();
        }
        catch (JMSException e) {
            log.error("Unexpected exception while reading JMS message", (Throwable)e);
            this.sendErrorResponse(0L, "Unexpected exception while reading JMS message: " + e.getMessage());
            return;
        }
        if (!(o instanceof VadirServiceMilitaryHistoryRequest)) {
            this.sendErrorResponse(0L, "Message must contain a " + VadirServiceMilitaryHistoryRequest.class.getName() + ", but instead contained a " + o.getClass().getName());
            return;
        }
        VadirServiceMilitaryHistoryRequest vsr = (VadirServiceMilitaryHistoryRequest)o;
        gov.va.schema.militaryhistory.MilitaryHistory mh = null;
        try {
            mh = this.getMilitaryHistoryFromVadir(vsr);
        }
        catch (WebServiceClientException e) {
            this.sendResponse(new VadirServiceResponseWrapper(vsr.getRequestId(), vsr.getPersonId(), 2, e.getMessage()));
            return;
        }
        if (mh == null) {
            log.debug("No results found.");
            this.sendResponse(new VadirServiceResponseWrapper(vsr.getRequestId(), vsr.getPersonId(), -1));
        } else {
            MilitaryHistory esrMilitaryHistory = this.stubTranslationService.translate(mh);
            this.sendResponse(new VadirServiceResponseWrapper(vsr.getRequestId(), vsr.getPersonId(), (Serializable)esrMilitaryHistory));
        }
    }

    private void sendResponse(VadirServiceResponseWrapper r) {
        log.debug("Sending response {}", (Object)r);
        this.jmsTemplate.send((MessageCreator)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void sendErrorResponse(long requestId, String error) {
        this.sendResponse(new VadirServiceResponseWrapper(requestId, 1L, (Serializable)((Object)error)));
    }

    private gov.va.schema.militaryhistory.MilitaryHistory getMilitaryHistoryFromVadir(VadirServiceMilitaryHistoryRequest vsr) throws WebServiceClientException {
        SearchCriteria sc = new SearchCriteria();
        if (vsr.getDateOfBirth() != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(vsr.getDateOfBirth());
            try {
                sc.setDateOfBirth(DatatypeFactory.newInstance().newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE));
            }
            catch (DatatypeConfigurationException e) {
                throw new WebServiceTransformerException("Problem instantiating a " + DatatypeFactory.class.getSimpleName());
            }
        }
        sc.setFirstName(vsr.getFirstName());
        sc.setGender(vsr.getGender());
        sc.setICN(vsr.getIcn());
        sc.setLastName(vsr.getLastName());
        sc.setSSN(vsr.getSsn());
        gov.va.schema.militaryhistory.MilitaryHistory mh = this.client.getMilitaryHistory(sc);
        return mh;
    }
}

