/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.jms.vadir;

import gov.va.med.esr.jms.vadir.StubTranslationService;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.BIRLS;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.VADIR;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.springframework.stereotype.Service;

@Service
public class StubTranslationService {
    public MilitaryHistory translate(gov.va.schema.militaryhistory.MilitaryHistory mh) {
        MilitaryHistory result = new MilitaryHistory();
        result.setBirls(this.translate(mh.getBIRLS()));
        result.setIcn(mh.getICN());
        result.setQueryId(mh.getQueryId());
        result.setReturnStatus(mh.getReturnStatus());
        result.setVadir(this.translate(mh.getVADIR()));
        return result;
    }

    private VADIR translate(gov.va.schema.militaryhistory.VADIR vadir) {
        VADIR result = new VADIR();
        result.setOefOifIndicator(vadir.getOefOifIndicator());
        result.setRetirementStatusIndicator(vadir.getRetirementStatusIndicator());
        result.setServicePeriods(this.convertList(vadir.getServicePeriods(), (ItemTranslator)new ServicePeriodTranslator(this, null)));
        result.setVaId(vadir.getVaId());
        return result;
    }

    private BIRLS translate(gov.va.schema.militaryhistory.BIRLS birls) {
        BIRLS result = new BIRLS();
        result.setDisabilityInd(birls.getDisabilityInd());
        result.setMedalOfHonorInd(birls.getMedalOfHonorInd());
        result.setPeriodOfService(this.convertList(birls.getPeriodOfService(), (ItemTranslator)new PeriodOfServiceTranslator(this, null)));
        result.setPurpleHeartInd(birls.getPurpleHeartInd());
        result.setRecurServiceNumber(birls.getRecurServiceNumber());
        result.setVadsInd(birls.getVADSInd());
        result.setVerifiedSvcDataInd(birls.getVerifiedSvcDataInd());
        return result;
    }

    private Date convertCal(XMLGregorianCalendar endDate) {
        return endDate == null ? null : endDate.toGregorianCalendar().getTime();
    }

    private <T, U> List<U> convertList(List<T> source, ItemTranslator<T, U> translator) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (T item : source) {
            result.add(translator.translate(item));
        }
        return result;
    }

    static /* synthetic */ Date access$200(StubTranslationService x0, XMLGregorianCalendar x1) {
        return x0.convertCal(x1);
    }

    static /* synthetic */ List access$400(StubTranslationService x0, List x1, ItemTranslator x2) {
        return x0.convertList(x1, x2);
    }
}

