/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.person.delegate;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.caip.client.businessdelegate.BusinessDelegatePOJO;
import gov.va.med.caip.client.businessdelegate.BusinessDelegateRemoteEJB;
import gov.va.med.caip.client.exceptions.CaipException;
import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.caip.client.location.ServiceFacadeRemoteEJB;
import gov.va.med.person.delegate.PSDelegateInfo;
import gov.va.med.person.exceptions.InvalidCriteriaException;
import gov.va.med.person.exceptions.NoRecordFoundException;
import gov.va.med.person.exceptions.PSException;
import gov.va.med.person.facade.ejb.PSBeanHome;
import gov.va.med.person.facade.ejb.PSBeanRemote;
import gov.va.med.person.idmgmt.AuditResult;
import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.MatchCriteria;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.exceptions.ThresholdExceededException;
import gov.va.med.person.service.IPersonService;
import gov.va.med.person.service.IServiceStatus;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.ejb.CreateException;
import org.apache.log4j.Logger;

public class PSDelegate
implements IPersonService,
BusinessDelegateRemoteEJB,
BusinessDelegatePOJO {
    private static final Logger logger = Logger.getLogger(PSDelegate.class);
    private ServiceFacadeRemoteEJB facade;
    private PSBeanHome home;
    private static final String INVALIDCRITERIA_EXCEPTION = "InvalidCriteriaException caught in PSDelegate";
    private static final String REMOTE_EXCEPTION = "RemoteException caught in PSDelegate";
    private static final String CREATE_EXCEPTION = "CreateException caught in PSDelegate";

    public IQualifiedIdentifier create(IPersonIdentity personIdentity) throws PSException, CaipInvocationException {
        IQualifiedIdentifier vpid = null;
        try {
            vpid = this.getBean().create(personIdentity);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return vpid;
    }

    public IPersonIdentity[] obtain(MatchCriteria criteria) throws InvalidCriteriaException, PSException, ThresholdExceededException {
        IPersonIdentity[] identities = null;
        try {
            identities = this.getBean().obtain(criteria);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identities;
    }

    public int obtainCount(MatchCriteria criteria) throws InvalidCriteriaException, PSException, CaipInvocationException {
        int count;
        try {
            count = this.getBean().obtainCount(criteria);
        }
        catch (InvalidCriteriaException e) {
            logger.error((Object)INVALIDCRITERIA_EXCEPTION, (Throwable)e);
            throw new PSException(INVALIDCRITERIA_EXCEPTION, (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return count;
    }

    public IPersonIdentity obtain(IQualifiedIdentifier localIdentifier) throws NoRecordFoundException, PSException, CaipInvocationException {
        try {
            return this.getBean().obtain(localIdentifier);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public IPersonIdentity obtain(IQualifiedIdentifier localIdentifier, boolean returnHistory) throws NoRecordFoundException, PSException, CaipInvocationException {
        IPersonIdentity identity = null;
        try {
            identity = this.getBean().obtain(localIdentifier, returnHistory);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identity;
    }

    public IPersonIdentity obtain(IQualifiedIdentifier localIdentifier, String stationNumber) throws NoRecordFoundException, PSException, CaipInvocationException {
        try {
            IPersonIdentity identity = this.getBean().obtain(localIdentifier, stationNumber);
            return identity;
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public IPersonIdentity obtain(IQualifiedIdentifier localIdentifier, String stationNumber, boolean returnHistory) throws NoRecordFoundException, PSException, CaipInvocationException {
        IPersonIdentity identity = null;
        try {
            identity = this.getBean().obtain(localIdentifier, stationNumber, returnHistory);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identity;
    }

    public HashMap obtain(IQualifiedIdentifier[] vpids) throws PSException, ThresholdExceededException, CaipInvocationException {
        HashMap identity = null;
        try {
            identity = this.getBean().obtain(vpids);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identity;
    }

    public HashMap obtain(IQualifiedIdentifier[] vpids, String stationNumber) throws ThresholdExceededException, CaipInvocationException {
        HashMap identity = null;
        try {
            identity = this.getBean().obtain(vpids, stationNumber);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException ce) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)ce);
        }
        return identity;
    }

    public IPersonIdentity[] obtain(IPersonIdentity criteria, String matchType) throws InvalidCriteriaException, PSException, ThresholdExceededException {
        IPersonIdentity[] identities = null;
        try {
            identities = this.getBean().obtain(criteria, matchType);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identities;
    }

    public IPersonIdentity obtainCorrelation(IQualifiedIdentifier sourceId) throws NoRecordFoundException, IllegalArgumentException, PSException {
        IPersonIdentity correlation = null;
        try {
            correlation = this.getBean().obtainCorrelation(sourceId);
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                if ((cause = cause.getCause()) instanceof IllegalArgumentException) {
                    logger.error((Object)"IllegalArgumentException: ", cause);
                    throw (IllegalArgumentException)cause;
                }
            } else if (cause instanceof IllegalArgumentException) {
                logger.error((Object)"IllegalArgumentException: ", cause);
                throw (IllegalArgumentException)cause;
            }
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return correlation;
    }

    public IPersonIdentity obtainCorrelation(IQualifiedIdentifier sourceId, boolean returnHistory) throws NoRecordFoundException, IllegalArgumentException, PSException {
        IPersonIdentity correlation = null;
        try {
            correlation = this.getBean().obtainCorrelation(sourceId, returnHistory);
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                if ((cause = cause.getCause()) instanceof IllegalArgumentException) {
                    logger.error((Object)"IllegalArgumentException: ", cause);
                    throw (IllegalArgumentException)cause;
                }
            } else if (cause instanceof IllegalArgumentException) {
                logger.error((Object)"IllegalArgumentException: ", cause);
                throw (IllegalArgumentException)cause;
            }
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return correlation;
    }

    public HashMap obtainCorrelation(IQualifiedIdentifier[] sourceIds) throws NoRecordFoundException, IllegalArgumentException, PSException, ThresholdExceededException {
        HashMap correlations = null;
        try {
            correlations = this.getBean().obtainCorrelation(sourceIds);
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                if ((cause = cause.getCause()) instanceof IllegalArgumentException) {
                    logger.error((Object)"IllegalArgumentException: ", cause);
                    throw (IllegalArgumentException)cause;
                }
            } else if (cause instanceof IllegalArgumentException) {
                logger.error((Object)"IllegalArgumentException: ", cause);
                throw (IllegalArgumentException)cause;
            }
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return correlations;
    }

    public IPersonIdentity[] obtainHistory(IQualifiedIdentifier localIdentifier) throws PSException, CaipInvocationException {
        return this.obtainHistory(localIdentifier, false);
    }

    public IPersonIdentity[] obtainHistory(IQualifiedIdentifier localIdentifier, boolean includeDeprecated) throws PSException, CaipInvocationException {
        IPersonIdentity[] identities = null;
        try {
            identities = this.getBean().obtainHistory(localIdentifier, includeDeprecated);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identities;
    }

    public IPersonIdentity[] obtainHistory(IQualifiedIdentifier localIdentifier, Date effective, Date expiration) throws PSException, CaipInvocationException {
        IPersonIdentity[] identities = null;
        try {
            identities = this.getBean().obtainHistory(localIdentifier, effective, expiration);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identities;
    }

    public IQualifiedIdentifier[] obtainSOI(IQualifiedIdentifier localIdentifier) throws PSException, CaipInvocationException {
        IQualifiedIdentifier[] identifiers = null;
        try {
            identifiers = this.getBean().obtainSOI(localIdentifier);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identifiers;
    }

    public IQualifiedIdentifier[] obtainSOI(IQualifiedIdentifier localIdentifier, Collection categories) throws PSException, CaipInvocationException {
        IQualifiedIdentifier[] identifiers = null;
        try {
            identifiers = this.getBean().obtainSOI(localIdentifier, categories);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identifiers;
    }

    public IQualifiedIdentifier obtainVPID(IQualifiedIdentifier localIdentifier) throws PSException, CaipInvocationException {
        IQualifiedIdentifier identifier = null;
        try {
            identifier = this.getBean().obtainVPID(localIdentifier);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return identifier;
    }

    public void update(IPersonIdentity personIdentity) throws PSException, CaipInvocationException {
        try {
            this.getBean().update(personIdentity);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public IQualifiedIdentifier[] obtainVpidsBySsnVerificationStatus(ISSN[] ssns) throws PSException, CaipInvocationException {
        try {
            return this.getBean().obtainVpidsBySsnVerificationStatus(ssns);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public IQualifiedIdentifier[] obtainVpidsBySsnVerificationStatus(ISSN[] ssns, String stationNumber) throws PSException, CaipInvocationException {
        IQualifiedIdentifier[] qiArray = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" ***PSDelegate.obtainVpidsBySsnVerificationStatus: ");
            }
            qiArray = this.getBean().obtainVpidsBySsnVerificationStatus(ssns, stationNumber);
            return qiArray;
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public void notifyPsdOfAdrUpdate(String vpid) throws PSException, CaipInvocationException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" ***PSDelegate.notifyPsdOfAdrUpdate for VPID: " + vpid));
            }
            this.getBean().notifyPsdOfAdrUpdate(vpid);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public AuditResult[] obtainAuditResults(IQualifiedIdentifier vpidId) throws PSException, CaipInvocationException {
        AuditResult[] auditResults = null;
        try {
            auditResults = this.getBean().obtainAuditResults(vpidId);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return auditResults;
    }

    public AuditResult[] obtainAuditResults(IQualifiedIdentifier vpidId, String stationId) throws PSException, CaipInvocationException {
        AuditResult[] auditResults = null;
        try {
            auditResults = this.getBean().obtainAuditResults(vpidId, stationId);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
        return auditResults;
    }

    public void setServiceFacade(ServiceFacadeRemoteEJB serviceFacade) throws CaipException {
        this.facade = serviceFacade;
    }

    public BusinessDelegateInfo getBusinessDelegateInterfaceInfo() {
        return new PSDelegateInfo();
    }

    private PSBeanRemote getBean() throws CreateException, RemoteException {
        if (this.home == null) {
            this.home = (PSBeanHome)this.facade.getEjbHomeReference();
        }
        return this.home.create();
    }

    public IServiceStatus getStatus() throws PSException, CaipInvocationException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" ***PSDelegate.obtainVpidsBySsnVerificationStatus: ");
            }
            return this.getBean().getStatus();
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }

    public String execute(String requestXML) throws PSException, CaipInvocationException {
        try {
            return this.getBean().execute(requestXML);
        }
        catch (RemoteException e) {
            logger.error((Object)REMOTE_EXCEPTION, (Throwable)e);
            throw new PSException(REMOTE_EXCEPTION, (Throwable)e);
        }
        catch (CreateException e) {
            logger.error((Object)CREATE_EXCEPTION, (Throwable)e);
            throw new PSException(CREATE_EXCEPTION, (Throwable)e);
        }
    }
}

