/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.trigger;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PartialPersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FilterSitesPersonTriggerEvent
extends PartialPersonTriggerEvent {
    private static final long serialVersionUID = 3106640807175287612L;
    private Map entityKeysAndSites = new HashMap();

    public FilterSitesPersonTriggerEvent(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType, CommonTrigger.DispatchType dispatchType, PersonTrigger.DataType dataType) {
        super(destinationType, targetType, dispatchType, dataType);
    }

    public FilterSitesPersonTriggerEvent(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType, CommonTrigger.DispatchType dispatchType, PersonTrigger.DataType dataType, Map entityKeysAndSites) {
        this(destinationType, targetType, dispatchType, dataType);
        this.setEntityKeysAndSites(entityKeysAndSites);
    }

    public Map getEntityKeysAndSites() {
        return this.entityKeysAndSites;
    }

    public void setEntityKeysAndSites(Map entityKeysAndSites) {
        this.entityKeysAndSites = entityKeysAndSites;
    }

    @Override
    public Set getFilterSites() {
        if (super.getFilterSites() != null) {
            return this.getFilterSites();
        }
        if (this.entityKeysAndSites != null) {
            HashSet<VAFacility> entityKeySites = new HashSet<VAFacility>();
            for (VAFacility entityKeySite : this.entityKeysAndSites.values()) {
                entityKeySites.add(entityKeySite);
            }
            return entityKeySites;
        }
        return null;
    }

    @Override
    protected void preTrigger() {
        super.preTrigger();
        if (this.entityKeysAndSites.isEmpty()) {
            return;
        }
        HashMap keysAndSites = new HashMap(this.entityKeysAndSites.size());
        for (Map.Entry entry : this.entityKeysAndSites.entrySet()) {
            Object key = entry.getKey();
            Object facility = entry.getValue();
            if (key instanceof EntityKey) {
                keysAndSites.put(key, facility);
                continue;
            }
            if (key instanceof AbstractKeyedEntity) {
                EntityKey entityKey = ((AbstractKeyedEntity)key).getEntityKey();
                if (entityKey != null) {
                    keysAndSites.put(entityKey, facility);
                    continue;
                }
                throw new IllegalStateException("FilterSitesPersonTriggerEvent contains an AbstractKeyedEntity with a null EntityKey " + this.entityKeysAndSites);
            }
            throw new IllegalStateException("FilterSitesPersonTriggerEvent contains an item that is not an EntityKey nor is it  instance of AbstractKeyedEntity " + this.entityKeysAndSites);
        }
        this.entityKeysAndSites.clear();
        this.entityKeysAndSites.putAll(keysAndSites);
    }
}

