/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.cases.Assignment;
import gov.va.med.esr.common.model.cases.Status;
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.cases.WorkflowPerson;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.MilitaryServiceQueryStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.lookup.WkfIssueType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.persistent.person.PersonDAO;
import gov.va.med.esr.common.persistent.workflow.WorkflowDAO;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.WorkItemsSummary;
import gov.va.med.esr.service.WorkflowSearchCriteria;
import gov.va.med.esr.service.WorkflowSearchResultBean;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class WorkflowServiceImpl
extends AbstractRuleAwareServiceImpl
implements WorkflowService {
    private static final long serialVersionUID = -6095296322006464695L;
    private WorkflowDAO workflowDAO;
    private PersonDAO personDAO;
    private static final String VOA_EVENT = "VOA event";

    @Override
    public WorkflowCase getWorkItem(Person person, WkfCaseType wkfCaseType, boolean create) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person is required to create workflow case");
        Validate.notNull((Object)((Object)wkfCaseType), (String)"WorkflowCaseType is required to create workflow case");
        WorkflowCase wkfCase = null;
        WorkflowPerson workflowPerson = null;
        WorkflowSearchCriteria workflowSeachCriteria = new WorkflowSearchCriteria();
        workflowSeachCriteria.setPersonId(person.getEntityKey().getKeyValueAsString());
        workflowSeachCriteria.setItemType(wkfCaseType);
        workflowSeachCriteria.setOpenItems(true);
        try {
            List workItems = this.getWorkflowDAO().find(workflowSeachCriteria);
            if (workItems != null && workItems.size() > 0) {
                if (workItems.size() == 1) {
                    WorkflowSearchResultBean bean = (WorkflowSearchResultBean)workItems.get(0);
                    EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)bean.getWorkflowCaseID(), WorkflowCase.class);
                    wkfCase = (WorkflowCase)this.getWorkflowDAO().getByKey(entityKey);
                } else if (workItems.size() > 1) {
                    throw new ServiceException("Multiple Workflow Items found");
                }
            }
            if (wkfCase == null && create) {
                EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(person.getEntityKey().getKeyValueAsString()), WorkflowPerson.class);
                workflowPerson = (WorkflowPerson)((Object)this.getWorkflowDAO().getByKey(entityKey));
                wkfCase = new WorkflowCase();
                wkfCase.setPerson(workflowPerson);
                FunctionalGroup groupType = this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode());
                wkfCase.setGroupType(groupType);
                wkfCase.setRequestSource(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
                WkfCaseType caseType = this.getLookupService().getWkfCaseTypeByCode(wkfCaseType.getCode());
                wkfCase.setCaseType(caseType);
                Status wkfStatus = new Status();
                WkfCaseStatusType wkfCaseStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.NEW.getName());
                wkfStatus.setStatusValue(wkfCaseStatusType);
                wkfCase.setStatus(wkfStatus);
                Assignment assignment = new Assignment();
                wkfCase.setAssignment(assignment);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("WorkItem search failed");
        }
        return wkfCase;
    }

    @Override
    public List<WorkflowCase> getOpenWorkItemLst(Person person, WkfCaseType wkfCaseType) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person is required to create workflow case");
        Validate.notNull((Object)((Object)wkfCaseType), (String)"WorkflowCaseType is required to create workflow case");
        ArrayList<WorkflowCase> lst = new ArrayList<WorkflowCase>();
        Object wkfCase = null;
        Object workflowPerson = null;
        WorkflowSearchCriteria workflowSeachCriteria = new WorkflowSearchCriteria();
        workflowSeachCriteria.setPersonId(person.getEntityKey().getKeyValueAsString());
        workflowSeachCriteria.setItemType(wkfCaseType);
        workflowSeachCriteria.setOpenItems(true);
        try {
            List workItems = this.getWorkflowDAO().find(workflowSeachCriteria);
            if (workItems != null && workItems.size() > 0) {
                for (int i = 0; i < workItems.size(); ++i) {
                    WorkflowSearchResultBean bean = (WorkflowSearchResultBean)workItems.get(i);
                    EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)bean.getWorkflowCaseID(), WorkflowCase.class);
                    lst.add((WorkflowCase)this.getWorkflowDAO().getByKey(entityKey));
                }
            }
        }
        catch (DAOException e) {
            throw new ServiceException("WorkItem search failed");
        }
        return lst;
    }

    @Override
    public WorkflowCase getMostRecentWorkflowItem(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person is required to create workflow case");
        WorkflowCase wkfCase = null;
        try {
            wkfCase = this.getWorkflowDAO().getMostRecentlyCreatedWorkflowItem(person.getPersonEntityKey());
        }
        catch (DAOException e) {
            throw new ServiceException("WorkItem search failed");
        }
        return wkfCase;
    }

    @Override
    public WorkflowCase create(WorkflowCase workflowCase) throws ServiceException {
        try {
            List workflowCases = this.getWorkflowDAO().getMatchingOpenCasesForAWorkItem(workflowCase);
            if (workflowCases != null && workflowCases.size() > 0) {
                for (WorkflowCase wfCaseFromDB : workflowCases) {
                    if (WkfCaseStatusType.CLOSED.getName().equals(wfCaseFromDB.getStatus())) continue;
                    this.close(wfCaseFromDB);
                }
            }
            this.updateStatus(workflowCase);
            this.getWorkflowDAO().update(workflowCase);
            return workflowCase;
        }
        catch (DAOException e) {
            throw new ServiceException("Workflow Case creation failed", (Throwable)e);
        }
    }

    @Override
    public void autoCreateCase(Person person, FunctionalGroup groupType, WkfCaseType wkfCaseType, WkfIssueType wkfIssueType, String errorMessage) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person can not null");
        Validate.notNull((Object)((Object)groupType), (String)"GroupType can not null");
        Validate.notNull((Object)((Object)wkfCaseType), (String)"Workload Case Type can not be null");
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(person.getEntityKey().getKeyValueAsString()), WorkflowPerson.class);
        WorkflowPerson workflowPerson = null;
        try {
            workflowPerson = (WorkflowPerson)((Object)this.getWorkflowDAO().getByKey(entityKey));
        }
        catch (DAOException e) {
            throw new ServiceException("Could not retrive Person for key " + person.getEntityKey().getKeyValueAsString());
        }
        WorkflowCase wkfCase = new WorkflowCase();
        wkfCase.setPerson(workflowPerson);
        wkfCase.setGroupType(groupType);
        wkfCase.setCaseType(wkfCaseType);
        wkfCase.setIssueType(wkfIssueType);
        wkfCase.setErrorMessage(errorMessage);
        wkfCase.setRequestSource(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
        Status wkfStatus = new Status();
        WkfCaseStatusType wkfCaseStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.NEW.getName());
        wkfStatus.setStatusValue(wkfCaseStatusType);
        wkfCase.setStatus(wkfStatus);
        Assignment assignment = new Assignment();
        wkfCase.setAssignment(assignment);
        this.create(wkfCase);
    }

    @Override
    public void autoCreateCase(WorkflowCaseInfo workflowCaseInfo) throws ServiceException {
        WorkflowCase wkfCase = this.createCaseFromInfo(workflowCaseInfo);
        this.create(wkfCase);
    }

    private WorkflowCase createCaseFromInfo(WorkflowCaseInfo workflowCaseInfo) throws ServiceException {
        EntityKey entityKey = EntityKeyFactory.createEntityKey((Serializable)new BigDecimal(workflowCaseInfo.getPersonEntityKey().getKeyValueAsString()), WorkflowPerson.class);
        WorkflowPerson workflowPerson = null;
        try {
            workflowPerson = (WorkflowPerson)((Object)this.getWorkflowDAO().getByKey(entityKey));
        }
        catch (DAOException e) {
            throw new ServiceException("Could not retrive Person for key " + workflowCaseInfo.getPersonEntityKey().getKeyValueAsString());
        }
        WorkflowCase wkfCase = new WorkflowCase();
        wkfCase.setPerson(workflowPerson);
        FunctionalGroup groupType = workflowCaseInfo.getGroupType();
        if (groupType == null) {
            groupType = this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.DQ.getName());
        }
        wkfCase.setGroupType(groupType);
        WkfCaseType caseType = workflowCaseInfo.getCaseType();
        if (caseType == null) {
            caseType = this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_APPLICATION_EXCEPTION.getName());
        }
        wkfCase.setCaseType(caseType);
        WkfIssueType issueType = workflowCaseInfo.getIssueType();
        wkfCase.setIssueType(issueType);
        Status wkfStatus = new Status();
        WkfCaseStatusType wkfCaseStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.NEW.getName());
        wkfStatus.setStatusValue(wkfCaseStatusType);
        wkfCase.setStatus(wkfStatus);
        Assignment assignment = new Assignment();
        wkfCase.setAssignment(assignment);
        wkfCase.setErrorMessage(workflowCaseInfo.getErrorMessage());
        if (workflowCaseInfo.getRequestSource() == null) {
            wkfCase.setRequestSource(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
        } else {
            wkfCase.setRequestSource(workflowCaseInfo.getRequestSource());
        }
        return wkfCase;
    }

    @Override
    public WorkflowCase updateWorkItem(WorkflowCase workflowCase) throws ServiceException {
        WorkflowCase onFileWorkflowCase = this.find(workflowCase.getEntityKey());
        this.ensureEntityChanged((AbstractEntity)workflowCase, (AbstractEntity)onFileWorkflowCase);
        try {
            this.getWorkflowDAO().evict(onFileWorkflowCase);
        }
        catch (DAOException e) {
            throw new ServiceException("Workflow Case update failed", (Throwable)e);
        }
        UserPrincipal currentUser = SecurityContextHelper.getCurrentUser();
        String userName = currentUser == null ? null : currentUser.getName();
        Assignment assignment = this.getAssignment(workflowCase);
        WkfCaseStatusType onfileStatus = onFileWorkflowCase.getStatus().getStatusValue();
        WkfCaseStatusType currentStatus = workflowCase.getStatus().getStatusValue();
        if (StringUtils.isEmpty((String)assignment.getAssignedTo()) && !currentStatus.getCode().equals(onfileStatus.getCode())) {
            assignment.setAssignedBy(userName);
            assignment.setAssignedTo(userName);
            assignment.setAssignmentDate(DateUtils.getCurrentDate());
        }
        return this.update(workflowCase);
    }

    @Override
    public WorkflowCase update(WorkflowCase workflowCase) throws ServiceException {
        try {
            this.updateStatus(workflowCase);
            this.getWorkflowDAO().update(workflowCase);
            return workflowCase;
        }
        catch (DAOException e) {
            throw new ServiceException("Workflow Case update failed", (Throwable)e);
        }
    }

    @Override
    public void close(List caseIds) throws ServiceException {
        WkfCaseStatusType closedStatus = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.CLOSED.getName());
        UserPrincipal currentUser = SecurityContextHelper.getCurrentUser();
        String userName = currentUser == null ? null : currentUser.getName();
        List cases = this.find(caseIds);
        for (WorkflowCase wfCase : cases) {
            if (!wfCase.isOpen()) continue;
            Status newStatus = wfCase.getStatus();
            if (newStatus == null) {
                newStatus = new Status();
                wfCase.setStatus(newStatus);
            }
            newStatus.setStatusValue(closedStatus);
            Assignment assignment = wfCase.getAssignment();
            if (assignment == null) {
                assignment = new Assignment();
                wfCase.setAssignment(assignment);
            }
            if (userName != null && StringUtils.isEmpty((String)assignment.getAssignedTo())) {
                assignment.setAssignedBy(userName);
                assignment.setAssignedTo(userName);
                assignment.setAssignmentDate(DateUtils.getCurrentDate());
            }
            this.update(wfCase);
        }
    }

    @Override
    public void close(WorkflowCase wfCase) throws ServiceException {
        ArrayList<BigDecimal> caseIds = new ArrayList<BigDecimal>();
        caseIds.add((BigDecimal)wfCase.getEntityKey().getKeyValue());
        this.close(caseIds);
    }

    @Override
    public void assign(List caseIds, UserPrincipal assignedBy, UserPrincipal assinedTo) throws ServiceException {
        this.assign(caseIds, assignedBy, assinedTo, null);
    }

    @Override
    public void assign(List caseIds, UserPrincipal assignedBy, UserPrincipal assinedTo, FunctionalGroup toGroup) throws ServiceException {
        List cases = this.find(caseIds);
        for (WorkflowCase wfCase : cases) {
            if (!wfCase.isOpen()) continue;
            Assignment currentAssignment = wfCase.getAssignment();
            if (currentAssignment == null) {
                currentAssignment = new Assignment();
                wfCase.setAssignment(currentAssignment);
            }
            if (assinedTo != null && assinedTo.getName().equals(currentAssignment.getAssignedTo())) continue;
            currentAssignment.setAssignedBy(assignedBy.getName());
            currentAssignment.setAssignedTo(assinedTo == null ? null : assinedTo.getName());
            currentAssignment.setAssignmentDate(DateUtils.getCurrentDate());
            Status status = wfCase.getStatus();
            WkfCaseStatusType wkfStatusType = status.getStatusValue();
            if (assinedTo != null) {
                if (WkfCaseStatusType.NEW.getCode().equals(wkfStatusType.getCode()) || WkfCaseStatusType.INPROCESS.getCode().equals(wkfStatusType.getCode())) {
                    wkfStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.ASSIGNED.getCode());
                    status.setStatusValue(wkfStatusType);
                }
            } else if (!WkfCaseStatusType.NEW.getCode().equals(wkfStatusType.getCode())) {
                wkfStatusType = this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.NEW.getCode());
                status.setStatusValue(wkfStatusType);
            }
            if (toGroup != null && !toGroup.equals((Object)wfCase.getGroupType())) {
                wfCase.setGroupType(toGroup);
            }
            this.update(wfCase);
        }
    }

    @Override
    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        return this.searchwithPSIM(searchQueryInfo);
    }

    public List searchwithPSIM(SearchQueryInfo searchQueryInfo) throws ServiceException {
        List workItems = null;
        try {
            WorkflowSearchCriteria searchCriteria = (WorkflowSearchCriteria)searchQueryInfo;
            ArrayList vpids = null;
            Map identiyTraitsByVPID = null;
            if (StringUtils.isNotEmpty((String)searchCriteria.getSsn()) || StringUtils.isNotEmpty((String)searchCriteria.getFamilyName()) && StringUtils.isNotEmpty((String)searchCriteria.getGivenName())) {
                identiyTraitsByVPID = this.searchPSIM(searchCriteria);
                if (identiyTraitsByVPID != null && identiyTraitsByVPID.size() > 0) {
                    vpids = new ArrayList(identiyTraitsByVPID.keySet());
                } else {
                    searchQueryInfo.setTotalNumberOfEntries(0);
                    searchQueryInfo.setSearchTypePerformed("readAll");
                    return new ArrayList();
                }
            }
            if (vpids != null && vpids.size() > 0) {
                searchCriteria.setVpids(vpids);
                searchCriteria.setPersonIds(new ArrayList(this.getPersonDAO().getIdsByVPIDs(vpids).values()));
            }
            workItems = this.getWorkflowDAO().find(searchCriteria);
            ArrayList<BigDecimal> personIds = new ArrayList<BigDecimal>();
            for (int i = 0; workItems != null && i < workItems.size(); ++i) {
                WorkflowSearchResultBean wkfBean = (WorkflowSearchResultBean)workItems.get(i);
                personIds.add(wkfBean.getPersonId());
            }
            Map vpidMap = null;
            if (personIds != null && personIds.size() > 0) {
                vpidMap = this.personDAO.getVPIDsbyIds(personIds);
            }
            for (int i = 0; workItems != null && i < workItems.size(); ++i) {
                WorkflowSearchResultBean wkfBean = (WorkflowSearchResultBean)workItems.get(i);
                BigDecimal personId = wkfBean.getPersonId();
                String vpid = (String)vpidMap.get(personId);
                if (vpid == null) continue;
                String shortVpid = vpid.substring(6, 23);
                wkfBean.setShortVPID(shortVpid);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Workflow Search Failed", (Throwable)e);
        }
        return workItems;
    }

    @Override
    public WorkflowCase find(EntityKey entityKey) throws ServiceException {
        try {
            WorkflowCase wfCase = (WorkflowCase)this.getWorkflowDAO().getByKey(entityKey);
            if (wfCase != null) {
                VPIDEntityKey vpidEntityKey = wfCase.getVPIDEntityKey();
                PersonIdentityTraits identiyTraits = this.getPsDelegateService().getIdentityTraits(vpidEntityKey);
                this.mergeIdentityTraitInfo(wfCase, identiyTraits);
            }
            return wfCase;
        }
        catch (DAOException e) {
            throw new ServiceException("WorkflowCase retrival Failed ", (Throwable)e);
        }
    }

    public List find(List caseIds) throws ServiceException {
        ArrayList<WorkflowCase> cases = new ArrayList<WorkflowCase>();
        try {
            for (BigDecimal caseId : caseIds) {
                WorkflowCase wfCase = (WorkflowCase)this.getWorkflowDAO().getByKey(EntityKeyFactory.createEntityKey((Serializable)caseId, WorkflowCase.class));
                if (wfCase == null) continue;
                cases.add(wfCase);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("WorkflowCase retrival Failed ", (Throwable)e);
        }
        return cases;
    }

    @Override
    public int getOpenCasesCount(PersonEntityKey personEntityKey) throws ServiceException {
        Validate.notNull((Object)personEntityKey, (String)"Person Entity Key is required to get the count");
        try {
            return this.getWorkflowDAO().getOpenCasesCount(personEntityKey);
        }
        catch (DAOException e) {
            throw new ServiceException("Get Open Cases Count for Veteran Failed", (Throwable)e);
        }
    }

    @Override
    public void processWorkflowEvent(Person person, Clock.Type clock) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson((PersonEntityKey)person.getEntityKey());
        if (clock != null && Clock.Type.WF_72_HOUR_CLOCK.getName().equals(clock.getName())) {
            if (onFile.getMilitaryService() != null && onFile.getMilitaryService().getMilitaryServiceQueryStatus() != null) {
                MilitaryServiceQueryStatus status = onFile.getMilitaryService().getMilitaryServiceQueryStatus();
                if (MilitaryServiceQueryStatus.QUERIED_PENDING_RESPONSE.getCode().equals(status.getCode())) {
                    WkfCaseType type = this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_MILITARY_SERVICE.getCode());
                    FunctionalGroup group = this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode());
                    WorkflowCaseInfo info = new WorkflowCaseInfo();
                    info.setPersonEntityKey(onFile.getPersonEntityKey());
                    info.setErrorMessage("Military Service Query Pending - No Response within 3 Days.");
                    info.setGroupType(group);
                    info.setCaseType(type);
                    this.autoCreateCase(info);
                    status = this.getLookupService().getMilitaryServiceQueryStatusByCode(MilitaryServiceQueryStatus.QUERIED_NO_DATA_RECEIVED.getCode());
                    onFile.getMilitaryService().setMilitaryServiceQueryStatus(status);
                    this.getPersonService().save(onFile);
                }
            }
            if (person.getCreatedBy().equals(VOA_EVENT)) {
                boolean isEnrollStatusPending = false;
                String statusCd = onFile.getEnrollmentDetermination().getEnrollmentStatus().getCode();
                this.logger.info((Object)("status code for VOA wf item is :" + statusCd));
                isEnrollStatusPending = EnrollmentStatus.CODE_PENDING.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_ELIGIBILITY_STATUS_IS_UNVERIFIED.getCode().equals(statusCd) || EnrollmentStatus.CODE_PENDING_PURPLE_HEART_UNCONFIRMED.getCode().equals(statusCd);
                this.logger.info((Object)("Is VOA still in pending state? :" + isEnrollStatusPending));
                if (isEnrollStatusPending) {
                    this.autoCreateCase(person, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "VOA Submission with Determined Enrollment Status of PENDING");
                    this.logger.info((Object)"VOA still in pending state - workflow created");
                    this.getPersonService().save(onFile);
                }
            }
        }
    }

    @Override
    public WorkItemsSummary getWorkItemsSummaryForUser(UserPrincipal user) throws ServiceException {
        WorkItemsSummary workItemsSummary = new WorkItemsSummary();
        String userName = user.getName();
        FunctionalGroup fg = ((ESRUserPrincipalImpl)user).getFunctionalGroup();
        try {
            WorkflowSearchCriteria workflowSearchCriteria = new WorkflowSearchCriteria();
            workflowSearchCriteria.setAssignedTo(userName);
            workflowSearchCriteria.setOpenItems(true);
            workItemsSummary.setMyCaseCount(this.getWorkflowDAO().getWorkItemsCount(workflowSearchCriteria));
            workflowSearchCriteria.setOverdueItems(true);
            workItemsSummary.setMyOverdueCaseCount(this.getWorkflowDAO().getWorkItemsCount(workflowSearchCriteria));
            if (fg != null) {
                workflowSearchCriteria.setFunctionalGroup(fg);
            }
            workflowSearchCriteria.setAssignedTo(null);
            workflowSearchCriteria.setOverdueItems(false);
            workflowSearchCriteria.setAssignedItems(true);
            workItemsSummary.setAssignedCaseCount(this.getWorkflowDAO().getWorkItemsCount(workflowSearchCriteria));
            workflowSearchCriteria.setOverdueItems(true);
            workItemsSummary.setAssignedOverdueCaseCount(this.getWorkflowDAO().getWorkItemsCount(workflowSearchCriteria));
            workflowSearchCriteria.setOverdueItems(false);
            workflowSearchCriteria.setAssignedItems(false);
            workflowSearchCriteria.setUnassignedItems(true);
            workItemsSummary.setUnassignedCaseCount(this.getWorkflowDAO().getWorkItemsCount(workflowSearchCriteria));
            workflowSearchCriteria.setOverdueItems(true);
            workItemsSummary.setUnassignedOverdueCaseCount(this.getWorkflowDAO().getWorkItemsCount(workflowSearchCriteria));
            return workItemsSummary;
        }
        catch (Exception e) {
            throw new ServiceException("Summary count query failed", (Throwable)e);
        }
    }

    private void mergeIdentityTraitInfo(WorkflowCase workflowCase, PersonIdentityTraits identityTraits) {
        if (identityTraits != null) {
            WorkflowPerson person = workflowCase.getPerson();
            person.setPersonTraits(identityTraits);
        }
    }

    private Map searchPSIM(WorkflowSearchCriteria searchCriteria) throws ServiceException {
        String ssn = searchCriteria.getSsn();
        String firstName = searchCriteria.getGivenName();
        String lastName = searchCriteria.getFamilyName();
        HashMap<String, PersonIdentityTraits> traitsKeyedByVPID = new HashMap<String, PersonIdentityTraits>();
        if (StringUtils.isNotEmpty((String)ssn) || StringUtils.isNotEmpty((String)firstName) || StringUtils.isNotEmpty((String)lastName)) {
            Set matchingTraits;
            PersonIdentityTraits searchCriteriaForTraits = new PersonIdentityTraits();
            if (StringUtils.isNotEmpty((String)firstName) || StringUtils.isNotEmpty((String)lastName)) {
                Name legalName = new Name();
                legalName.setFamilyName(StringUtils.trimToNull((String)searchCriteria.getFamilyName()));
                legalName.setGivenName(StringUtils.trimToNull((String)searchCriteria.getGivenName()));
                legalName.setType(this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getName()));
                searchCriteriaForTraits.addName(legalName);
            }
            if (StringUtils.isNotEmpty((String)ssn)) {
                SSN ssnObj = new SSN();
                ssnObj.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
                ssnObj.setSsnText(StringUtils.trimToNull((String)SSN.formatSSN(searchCriteria.getSsn())));
                searchCriteriaForTraits.setSsn(ssnObj);
            }
            Iterator itr = (matchingTraits = this.getPsDelegateService().attendedSearch(searchCriteriaForTraits, true)) != null ? matchingTraits.iterator() : null;
            PersonIdentityTraits match = null;
            while (itr != null && itr.hasNext()) {
                match = (PersonIdentityTraits)((Object)itr.next());
                traitsKeyedByVPID.put(match.getVpid().getVPID(), match);
            }
        }
        return traitsKeyedByVPID;
    }

    private void updateStatus(WorkflowCase wkfCase) throws ServiceException {
        Assignment assignment = wkfCase.getAssignment();
        if (assignment.getAssignedTo() != null) {
            Status curStatus = wkfCase.getStatus();
            if (WkfCaseStatusType.NEW.getName().equals(curStatus.getStatusValue().getCode())) {
                curStatus.setStatusValue(this.getLookupService().getWkfCaseStatusTypeByCode(WkfCaseStatusType.ASSIGNED.getName()));
            }
            if (assignment.getAssignmentDate() == null) {
                assignment.setAssignmentDate(DateUtils.getCurrentDate());
            }
        } else {
            assignment.setAssignmentDate(null);
        }
        if (wkfCase.getRequestSource() == null) {
            wkfCase.setRequestSource(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
        }
    }

    public WorkflowDAO getWorkflowDAO() {
        return this.workflowDAO;
    }

    public void setWorkflowDAO(WorkflowDAO workflowDAO) {
        this.workflowDAO = workflowDAO;
    }

    public PersonDAO getPersonDAO() {
        return this.personDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    private Assignment getAssignment(WorkflowCase wkfCase) {
        Assignment assignment = wkfCase.getAssignment();
        if (assignment == null) {
            assignment = new Assignment();
            wkfCase.setAssignment(assignment);
        }
        return assignment;
    }
}

