/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.VHICCardInfoService;
import gov.va.med.esr.service.external.VHICCardDetailInfo;
import gov.va.med.esr.service.external.VHICCardInfo;
import gov.va.med.fw.service.ServiceException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

public class VHICCardInfoServiceImpl
implements VHICCardInfoService {
    private static final long serialVersionUID = -8408702241918806208L;
    private VHICCardInfo vhicCardInfo = new VHICCardInfo();
    private String vpid = null;
    private PersonHelperService personHelperService = null;

    @Override
    public VHICCardInfo getVhicCardInfo() {
        return this.vhicCardInfo;
    }

    @Override
    public void setVhicCardInfo(VHICCardInfo vhicCardInfo) {
        this.vhicCardInfo = vhicCardInfo;
    }

    @Override
    public VHICCardInfo getVHICCardStatusFromVHIC() throws ServiceException {
        this.vhicCardInfo.setTotalCardsMailed(3);
        this.vhicCardInfo.setTotalCardsRequested(2);
        this.vhicCardInfo.setCurrentVHICCardNumber("2323232323");
        this.vhicCardInfo.setCurrentVHICCardStatus("Hold");
        String vhicId = this.getPersonHelperService().getVhicIdByVPID(this.vpid);
        ArrayList<VHICCardDetailInfo> vhicCardDetailInfos = new ArrayList<VHICCardDetailInfo>();
        try {
            VHICCardDetailInfo vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("12121212");
            String string = "January 8, 2015";
            Date date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "January 8, 2014";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Hold");
            vhicCardDetailInfo.setCardStatus("Submitted");
            this.vhicCardInfo.setCurrentVhicCardDetailInfo(vhicCardDetailInfo);
            vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("22222222");
            string = "July 2, 2014";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "July 2, 2013";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Hold");
            vhicCardDetailInfo.setCardStatus("Submitted");
            vhicCardDetailInfos.add(vhicCardDetailInfo);
            vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("3333333");
            string = "January 2, 2016";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "June 2, 2014";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Hold");
            vhicCardDetailInfo.setCardStatus("Submitted");
            vhicCardDetailInfos.add(vhicCardDetailInfo);
            vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("4444444");
            string = "October 2, 2017";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "May 2, 2014";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Hold");
            vhicCardDetailInfo.setCardStatus("Submitted");
            vhicCardDetailInfos.add(vhicCardDetailInfo);
            vhicCardDetailInfo = new VHICCardDetailInfo();
            vhicCardDetailInfo.setCardNumber("5555555");
            string = "December 2, 2013";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setCardExpiredDate(date);
            string = "July 3, 2010";
            date = new SimpleDateFormat("MMMM d, yyyy", Locale.ENGLISH).parse(string);
            vhicCardDetailInfo.setStatusDate(date);
            vhicCardDetailInfo.setReason("Cancelled");
            vhicCardDetailInfo.setCardStatus("Expired");
            vhicCardDetailInfos.add(vhicCardDetailInfo);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof VHICCardDetailInfo ? ((VHICCardDetailInfo)pObject1).getStatusDate() : null;
                    Date date2 = pObject2 instanceof VHICCardDetailInfo ? ((VHICCardDetailInfo)pObject2).getStatusDate() : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(vhicCardDetailInfos, comparator);
            this.vhicCardInfo.setVhicCardDetailInfoList(vhicCardDetailInfos);
        }
        catch (Exception ex) {
            throw new ServiceException("Error calling getVHICCardInfo", (Throwable)ex);
        }
        return this.vhicCardInfo;
    }

    @Override
    public void resetVhicCardInfo(String newVpid) {
        if (this.isVpidDifferent(newVpid)) {
            this.vhicCardInfo.setCurrentVHICCardNumber("No Data");
            this.vhicCardInfo.setCurrentVHICCardStatus("No Data");
            this.vhicCardInfo.setCurrentVhicCardDetailInfo(new VHICCardDetailInfo());
            this.vhicCardInfo.setVhicCardDetailInfoList(new ArrayList<VHICCardDetailInfo>());
            this.vhicCardInfo.setTotalCardsRequested(0);
            this.vhicCardInfo.setTotalCardsMailed(0);
        }
        this.setVpid(newVpid);
    }

    @Override
    public String getCurVhicCardID() {
        return this.vhicCardInfo.getCurrentVHICCardNumber();
    }

    @Override
    public String getCurVhicCardStatus() {
        return this.vhicCardInfo.getCurrentVHICCardStatus();
    }

    public String getVpid() {
        return this.vpid;
    }

    public void setVpid(String vpid) {
        this.vpid = vpid;
    }

    public boolean isVpidDifferent(String newVpid) {
        return !newVpid.equals(this.vpid);
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }
}

