/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PurpleHeartService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PurpleHeartServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements PurpleHeartService {
    private static final long serialVersionUID = 7820675252292861686L;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private RegistryService registryService = null;

    @Override
    public Person updatePurpleHeart(Person incoming) throws ServiceException {
        return this.updatePurpleHeart(incoming, null);
    }

    @Override
    public Person updatePurpleHeart(Person incoming, Clock.Type clockType) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A incoming person must not be null");
        PersonService personService = this.getPersonService();
        Person result = personService.getPerson((PersonEntityKey)incoming.getEntityKey());
        if (clockType == null) {
            this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        }
        result = this.getPurpleHeartRuleService().managePurpleHeart(incoming, result, clockType);
        result = this.getEligibilityEnrollmentService().assessEEImpact(result, false, clockType);
        this.getEventRuleService().handleCommonPostEvents(result, true);
        PurpleHeart incomingPurpleHeart = incoming.getPurpleHeart();
        if (incomingPurpleHeart != null && result != null && incomingPurpleHeart.getRegistryTrait() == null) {
            RegistryType regType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_PH_REGISTRY.getCode());
            this.getRegistryService().linkPersonRegistry(incomingPurpleHeart, result.getPurpleHeart(), incoming, result, regType, true);
        }
        return personService.save(result);
    }

    public void addPurpleHeartRegistryInfo(Person incoming) throws ServiceException {
    }

    @Override
    public HistoricalInfo getPurpleHeartHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.getHistoryDAO().getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getPurpleHeartHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.getHistoryDAO().getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }
}

