/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.messaging.SiteIdentityGroup;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.service.EnvironmentParamService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.impl.IdmWebServiceDelegate;
import gov.va.med.fw.model.AuditInfo;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.MissingCapabilityException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.TimeoutServiceException;
import gov.va.med.fw.util.StopWatchLogger;
import gov.va.med.fw.util.TimeoutException;
import gov.va.med.person.exceptions.NoRecordFoundException;
import gov.va.med.person.exceptions.PSException;
import gov.va.med.person.idmgmt.IPersonIdentity;
import gov.va.med.person.idmgmt.IQualifiedIdentifier;
import gov.va.med.person.idmgmt.common.ISSN;
import gov.va.med.person.idmgmt.db.hb.SSN;
import gov.va.med.person.idmgmt.exceptions.NPIException;
import gov.va.med.person.idmgmt.exceptions.PSIMException;
import gov.va.med.person.idmgmt.exceptions.VPIDException;
import gov.va.med.person.idmgmt.factory.QualifiedIdentifierFactory;
import gov.va.med.person.idmgmt.types.ImpreciseDate;
import gov.va.med.person.idmgmt.types.MultipleBirthIndicator;
import gov.va.med.person.service.IPersonService;
import gov.va.med.ps.model.PatientIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class PSDelegateServiceImpl
extends AbstractComponent
implements PSDelegateService {
    private static final String PSIM_UPDATE_STATUS_ACCEPTED = "A";
    private static final String PSIM_UPDATE_STATUS_PENDING = "P";
    private static final int DEFAULT_BATCH_SIZE = 25;
    private String esrStationNumber;
    private boolean isDataClean = true;
    private String processingId;
    private IPersonService PSIMSOADelegateService;
    private IdmWebServiceDelegate idmServiceDelegate = null;
    private static final long serialVersionUID = 9208990301858042789L;
    private LookupService lookupService;
    private EnvironmentParamService environmentParamService;

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.lookupService);
        Validate.notNull((Object)this.esrStationNumber);
        Validate.notNull((Object)this.processingId);
        Validate.notNull((Object)this.PSIMSOADelegateService);
        Validate.notNull((Object)this.environmentParamService);
    }

    @Override
    public VPIDEntityKey getVPID(String dfn, String stationNumber) throws ServiceException {
        try {
            FullyQualifiedIdentity fqi = new FullyQualifiedIdentity(dfn, stationNumber);
            PersonIdentityTraits pit = this.idmServiceDelegate.search(fqi, false);
            VPIDEntityKey vpid = pit.getVpid();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Idm Web Service returned: " + vpid));
            }
            return vpid != null && vpid.getKeyValue() != null ? CommonEntityKeyFactory.createVPIDEntityKey(vpid.getVPID()) : null;
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get VPID", (Throwable)e);
        }
    }

    @Override
    public PersonIdentityTraits getIdentityTraitsWithCompositeCall(String dfn, String stationNumber) throws ServiceException {
        try {
            FullyQualifiedIdentity id = new FullyQualifiedIdentity(dfn, stationNumber);
            PersonIdentityTraits identityTraits = this.getIdmServiceDelegate().searchWithCompositeCall(id, true, null);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IdM Web Service returned: " + (Object)((Object)identityTraits)));
            }
            return identityTraits;
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get IdentityTraits from Idm WebService for IQI with station: " + stationNumber + " and dfn:" + dfn + " calling searchWithCompositeCall() with " + this.esrStationNumber + " station number.", (Throwable)e);
        }
    }

    @Override
    public PersonIdentityTraits getIdentityTraitsWithCompositeCall(VPIDEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        return this.doGetIdentityTraits(key, true);
    }

    @Override
    public PersonIdentityTraits getIdentityTraits(VPIDEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        return this.doGetIdentityTraits(key, false);
    }

    private PersonIdentityTraits doGetIdentityTraits(VPIDEntityKey key, boolean compositeCall) throws ServiceException {
        PersonIdentityTraits traits = null;
        try {
            FullyQualifiedIdentity id = new FullyQualifiedIdentity(key.getShortVPID());
            traits = compositeCall ? this.getIdmServiceDelegate().searchWithCompositeCall(id, false, null) : this.getIdmServiceDelegate().search(id, false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("IdM Web Service returned: " + (Object)((Object)traits)));
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e2) {
            NoRecordFoundException e2;
            if (e2 instanceof VPIDException) {
                if (!this.isDataClean) {
                    traits = this.createdCannedTraitsWhenDataIsNotClean(key.getKeyValueAsString());
                } else {
                    e2 = new NoRecordFoundException("Unable to get IdentityTraits due to invalid VPID: " + key.getKeyValueAsString(), (Throwable)e2);
                }
            }
            throw new ServiceException("Unable to get IdentityTraits from Idm Web Service for VPID: " + key.getKeyValueAsString(), (Throwable)e2);
        }
        return traits;
    }

    @Override
    public Map getIdentityTraits(Collection vpidEntityKeys) throws ServiceException {
        int batchSize = vpidEntityKeys != null ? vpidEntityKeys.size() : 0;
        Iterator itr = vpidEntityKeys != null ? vpidEntityKeys.iterator() : null;
        IQualifiedIdentifier identifier = null;
        IQualifiedIdentifier[] identifiers = null;
        String vpid = null;
        int totalCount = 0;
        int currentBatchCount = 0;
        int currentBatchSize = 0;
        Object input = null;
        HashMap<String, PersonIdentityTraits> result = new HashMap<String, PersonIdentityTraits>();
        StopWatchLogger watch = new StopWatchLogger("PSIM obtain");
        while (itr != null && itr.hasNext()) {
            if (identifiers == null) {
                currentBatchSize = batchSize - totalCount > 25 ? 25 : batchSize - totalCount;
                identifiers = new IQualifiedIdentifier[currentBatchSize];
            }
            try {
                input = itr.next();
                vpid = input instanceof VPIDEntityKey ? ((VPIDEntityKey)input).getVPID() : (String)input;
                identifier = this.getVpidQualifiedIdentifier(vpid);
                identifiers[currentBatchCount++] = identifier;
                ++totalCount;
                if (currentBatchCount != currentBatchSize) continue;
                watch.start();
                HashMap psData = this.getPSIMSOADelegateService().obtain(identifiers);
                if (psData != null) {
                    watch.stopAndLog("returned a collection of " + psData.size() + " person trait info");
                    for (Map.Entry entry : psData.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key instanceof IQualifiedIdentifier && value instanceof IPersonIdentity) {
                            IQualifiedIdentifier id = (IQualifiedIdentifier)key;
                            IPersonIdentity personInfo = (IPersonIdentity)value;
                            result.put(id.getIdentifier(), this.convertTraits(personInfo, CommonEntityKeyFactory.createVPIDEntityKey(id.getIdentifier())));
                            continue;
                        }
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error((Object)("Failed to obtain a person identity with VPID " + (key instanceof IQualifiedIdentifier ? ((IQualifiedIdentifier)key).getIdentifier() : null)));
                        this.logger.error((Object)("Exception message " + (value instanceof Exception ? ((Exception)value).getMessage() : null)));
                    }
                }
                identifiers = null;
                currentBatchCount = 0;
            }
            catch (TimeoutException ex) {
                throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to get multiple Identity Trait's from PSIM", (Throwable)e);
            }
            finally {
                watch.reset();
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Number of VPID's input: " + batchSize));
            this.logger.info((Object)("Number of VPID's processed: " + totalCount));
        }
        return result;
    }

    @Override
    public Map getSubmittedIdentityTraits(Collection vpidEntityKeys) throws ServiceException {
        int batchSize = vpidEntityKeys != null ? vpidEntityKeys.size() : 0;
        Iterator itr = vpidEntityKeys != null ? vpidEntityKeys.iterator() : null;
        IQualifiedIdentifier identifier = null;
        IQualifiedIdentifier[] identifiers = null;
        String vpid = null;
        int totalCount = 0;
        int currentBatchCount = 0;
        int currentBatchSize = 0;
        Object input = null;
        HashMap<String, PersonIdentityTraits> result = new HashMap<String, PersonIdentityTraits>();
        StopWatchLogger watch = new StopWatchLogger("PSIM obtain");
        while (itr != null && itr.hasNext()) {
            if (identifiers == null) {
                currentBatchSize = batchSize - totalCount > 25 ? 25 : batchSize - totalCount;
                identifiers = new IQualifiedIdentifier[currentBatchSize];
            }
            try {
                input = itr.next();
                vpid = input instanceof VPIDEntityKey ? ((VPIDEntityKey)input).getVPID() : (String)input;
                identifier = this.getVpidQualifiedIdentifierWithStationNumber(vpid);
                identifiers[currentBatchCount++] = identifier;
                ++totalCount;
                if (currentBatchCount != currentBatchSize) continue;
                watch.start();
                HashMap psData = this.getPSIMSOADelegateService().obtainCorrelation(identifiers);
                if (psData != null) {
                    watch.stopAndLog("returned a collection of " + psData.size() + " person trait info");
                    for (Map.Entry entry : psData.entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (key instanceof IQualifiedIdentifier && value instanceof IPersonIdentity) {
                            IQualifiedIdentifier id = (IQualifiedIdentifier)key;
                            IPersonIdentity personInfo = (IPersonIdentity)value;
                            result.put(id.getIdentifier(), this.convertTraits(personInfo, CommonEntityKeyFactory.createVPIDEntityKey(id.getIdentifier())));
                            continue;
                        }
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error((Object)("Failed to obtain a person identity with VPID " + (key instanceof IQualifiedIdentifier ? ((IQualifiedIdentifier)key).getIdentifier() : null)));
                        this.logger.error((Object)("Exception message " + (value instanceof Exception ? ((Exception)value).getMessage() : null)));
                    }
                }
                identifiers = null;
                currentBatchCount = 0;
            }
            catch (TimeoutException ex) {
                throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
            }
            catch (Exception e) {
                throw new ServiceException("Unable to get multiple Identity Trait's from PSIM", (Throwable)e);
            }
            finally {
                watch.reset();
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Number of VPID's input: " + batchSize));
            this.logger.info((Object)("Number of VPID's processed: " + totalCount));
        }
        return result;
    }

    @Override
    public Set attendedSearch(PersonIdentityTraits traits, boolean enforceESRSecurity) throws ServiceException {
        if (enforceESRSecurity) {
            String specialCapability = Capability.LIMITED_SEARCH.getCode();
            if (traits.containsOnlyFullName()) {
                specialCapability = Capability.SEARCH_NAME_ONLY.getCode();
            } else if (traits.containsOnlySSN()) {
                specialCapability = Capability.SEARCH_SSN_ONLY.getCode();
            }
            if (!SecurityContextHelper.getSecurityContext().getUserPrincipal().isPermissionGranted(specialCapability)) {
                throw new MissingCapabilityException((Lookup)this.lookupService.getCapabilityByCode(specialCapability));
            }
        }
        return this.search(traits, false, true);
    }

    @Override
    public Set unattendedSearch(PersonIdentityTraits traits) throws ServiceException {
        if (traits.containsOnlySSN()) {
            throw new UnsupportedOperationException("Unattended Search with only SSN is not supported.  ESR is throwing this exception because PSIM is only logging an error and not throwing an exception.");
        }
        return this.search(traits, false, false);
    }

    @Override
    public Set getSites(VPIDEntityKey key) throws ServiceException {
        HashSet<SiteIdentity> siteIdentities = new HashSet<SiteIdentity>();
        if (key == null) {
            return siteIdentities;
        }
        try {
            SiteIdentity site = null;
            VAFacility facility = null;
            SiteIdentityGroup group = new SiteIdentityGroup();
            group.setPersonKey(key);
            List sites = this.idmServiceDelegate.getCorrelationsByVPID(key);
            for (PatientIdentifier pid : sites) {
                if (!"PI".equalsIgnoreCase(pid.getIdentityType()) || !"USVHA".equalsIgnoreCase(pid.getAssigningAuthority()) || "200ESR".equalsIgnoreCase(pid.getStationNumber())) continue;
                facility = this.lookupService.getVaFacilityByCode(pid.getStationNumber());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("[ facility Identifier : " + facility.getIdentifier() + ", " + "Station #: " + facility.getStationNumber() + "]"));
                }
                if (this.isSupportedInEnvironment(facility)) {
                    if (!facility.getType().getIsMedicalTreating()) continue;
                    site = new SiteIdentity();
                    group.addSiteIdentity(site);
                    site.setDfn(pid.getIdentity());
                    site.setVaFacility(facility);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[Site dfn: " + pid.getIdentity() + ", " + "facility Identifier : " + facility.getIdentifier() + ", " + "Station #: " + pid.getStationNumber() + "]"));
                    }
                    siteIdentities.add(site);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Site for facility with station #: " + facility.getStationNumber() + " excluded from list for VPID: " + key.getKeyValueAsString() + " because not supported by environment."));
            }
            return siteIdentities;
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (UnknownLookupTypeException tex) {
            this.logger.error((Object)("Type exception Error during lookup " + (Object)((Object)tex)));
            throw new ServiceException("Unable to look up station number: ", (Throwable)((Object)tex));
        }
        catch (UnknownLookupCodeException lex) {
            this.logger.error((Object)("Code exception Error during lookup " + (Object)((Object)lex)));
            throw new ServiceException("Unable to look up station number: ", (Throwable)((Object)lex));
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get sites from Idm Web Service for VPID: " + key.getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public boolean isSupportedInEnvironment(VAFacility facility) throws ServiceException {
        return this.environmentParamService.isSupportedFacility(facility);
    }

    private Set search(PersonIdentityTraits criteria, boolean compositeCall, boolean attendedSearch) throws ServiceException {
        return this.doSearch(criteria, compositeCall, attendedSearch);
    }

    protected Set doSearch(PersonIdentityTraits traits, boolean compositeCall, boolean attendedSearch) throws ServiceException {
        try {
            if (traits == null) {
                return null;
            }
            if (compositeCall) {
                return this.getIdmServiceDelegate().searchWithCompositeCall(traits, null);
            }
            return this.getIdmServiceDelegate().search(traits, attendedSearch);
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private PersonIdentityTraits convertTraits(IPersonIdentity source, VPIDEntityKey passedInVPID) throws ServiceException {
        String gender;
        ISSN psimSSN;
        IQualifiedIdentifier ssn;
        PersonIdentityTraits target = new PersonIdentityTraits();
        if (source == null) {
            return target;
        }
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setChangeDate(source.getAuditEventTimestamp());
        auditInfo.setChangeUser(source.getAuditUserId());
        if (PSIM_UPDATE_STATUS_ACCEPTED.equalsIgnoreCase(source.getUpdateStatus())) {
            auditInfo.setStatus("ACCEPTED");
        } else if (PSIM_UPDATE_STATUS_PENDING.equalsIgnoreCase(source.getUpdateStatus())) {
            auditInfo.setStatus("PENDING");
        } else if (StringUtils.isNotBlank((String)source.getUpdateStatus())) {
            auditInfo.setStatus("REJECTED-" + source.getUpdateStatus());
        }
        target.setAuditInfo(auditInfo);
        int numNames = source.getNumberOfNames();
        Name name = null;
        for (int i = 0; i < numNames; ++i) {
            name = new Name();
            name.setGivenName(source.getFirstName(i));
            name.setMiddleName(source.getMiddleName(i));
            name.setFamilyName(source.getLastName(i));
            name.setType(this.lookupService.getNameTypeByCode(source.getNameType(i)));
            name.setPrefix(source.getPrefix(i));
            name.setSuffix(source.getSuffix(i));
            target.addName(name);
        }
        target.setMothersMaidenName(source.getMothersMaidenName());
        String pobCity = source.getPlaceOfBirthCity();
        String pobState = source.getPlaceOfBirthState();
        String pobCountry = source.getPlaceOfBirthCountry();
        MultipleBirthIndicator isMultipleBirth = source.getMultiBirth();
        ImpreciseDate psimImpreciseBirthDate = source.getDateOfBirth();
        if (psimImpreciseBirthDate != null || pobCity != null || pobState != null || pobCountry != null || isMultipleBirth != null) {
            BirthRecord dob = new BirthRecord();
            if (psimImpreciseBirthDate != null && !StringUtils.isBlank((String)psimImpreciseBirthDate.getDate())) {
                dob.setBirthDate(new gov.va.med.esr.common.infra.ImpreciseDate(psimImpreciseBirthDate.getDate()));
            }
            dob.setCity(pobCity);
            dob.setState(pobState);
            if (pobCountry != null) {
                try {
                    dob.setCountry(this.lookupService.getCountryByCode(pobCountry).getShortName());
                }
                catch (ServiceException e) {
                    dob.setCountry(pobCountry);
                }
            }
            if (isMultipleBirth != null) {
                if ("Y".equalsIgnoreCase(isMultipleBirth.getValue())) {
                    dob.setMultipleBirth(new Boolean("TRUE"));
                } else if ("N".equalsIgnoreCase(isMultipleBirth.getValue())) {
                    dob.setMultipleBirth(new Boolean("FALSE"));
                }
            }
            target.setBirthRecord(dob);
        }
        IQualifiedIdentifier iQualifiedIdentifier = ssn = (psimSSN = source.getSSN()) != null ? psimSSN.getSSN() : null;
        if (ssn != null) {
            String psimSSNTypeCode = StringUtils.isNotBlank((String)psimSSN.getSsnType()) ? psimSSN.getSsnType() : SSNType.CODE_ACTIVE.getCode();
            String psimPseudoSSNReasonCode = psimSSN.getPseudoSSNReason();
            gov.va.med.esr.common.model.person.SSN traitSsn = new gov.va.med.esr.common.model.person.SSN();
            traitSsn.setType(this.getLookupService().getSSNTypeByCode(psimSSNTypeCode));
            traitSsn.setSsnText(ssn.getIdentifier());
            traitSsn.setSsaSentDate(psimSSN.getSentToSSA());
            traitSsn.setSsaReceivedDate(psimSSN.getReceivedFromSSA());
            traitSsn.setSsaVerificationDate(psimSSN.getVerifiedBySSA());
            if (StringUtils.isNotBlank((String)psimPseudoSSNReasonCode)) {
                traitSsn.setPseudoSSNReason(this.getLookupService().getPseudoSSNReasonByCode(psimPseudoSSNReasonCode));
            }
            if (StringUtils.isNotBlank((String)psimSSN.getSsnVerificationStatus())) {
                traitSsn.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(psimSSN.getSsnVerificationStatus()));
            }
            if (StringUtils.isNotBlank((String)psimSSN.getPseudoSSNReason())) {
                traitSsn.setPseudoSSNReason(this.getLookupService().getPseudoSSNReasonByCode(psimSSN.getPseudoSSNReason()));
            }
            if (StringUtils.isNotBlank((String)psimSSN.getSsnChangeSource())) {
                traitSsn.setSourceOfChange(this.getLookupService().getSSNChangeSourceByCode(psimSSN.getSsnChangeSource()));
            }
            if (StringUtils.isNotBlank((String)psimSSN.getSsaVerificationCode())) {
                traitSsn.setSsaMessage(this.getLookupService().getSSAMessageByCode(psimSSN.getSsaVerificationCode()));
            }
            target.setSsn(traitSsn);
        }
        target.setGender((gender = source.getGender()) != null ? this.lookupService.getGenderByCode(gender) : null);
        target.setVpid(CommonEntityKeyFactory.createVPIDEntityKey(VPIDEntityKeyImpl.getLongVPID(source.getVPID().getIdentifier())));
        if (passedInVPID != null && !target.getVpid().getShortVPID().equals(passedInVPID.getShortVPID())) {
            target.setRetrievedWithDeprecatedVPID(true);
        }
        target.setHasPendingUpdates(source.isUpdatePending());
        target.setDeprecated(source.isDeprecated());
        return target;
    }

    @Override
    public PersonIdentityTraits extractIdentityTraits(Person person) {
        return person.getIdentityTraits();
    }

    @Override
    public List getIdentityTraitsUpdateHistory(VPIDEntityKey key) throws ServiceException {
        IPersonIdentity[] items = this.doGetIdentityTraitsUpdateHistory(key);
        ListOrderedMap traitMap = new ListOrderedMap();
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; ++i) {
                IPersonIdentity psimTraits = items[i];
                if (psimTraits.getAuditEventTimestamp() == null) continue;
                traitMap.put((Object)psimTraits.getAuditEventTimestamp(), (Object)this.convertTraits(psimTraits, null));
            }
        }
        return new ArrayList(traitMap.values());
    }

    private IPersonIdentity[] doGetIdentityTraitsUpdateHistory(VPIDEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        try {
            IQualifiedIdentifier vpid = this.getVpidQualifiedIdentifierWithoutStationNumber(key.getVPID());
            return this.getPSIMSOADelegateService().obtainHistory(vpid);
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to retrieve history of identity traits updates for VPID: " + key.getVPID(), (Throwable)e);
        }
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public EnvironmentParamService getEnvironmentParamService() {
        return this.environmentParamService;
    }

    public void setEnvironmentParamService(EnvironmentParamService environmentParamService) {
        this.environmentParamService = environmentParamService;
    }

    public String getEsrStationNumber() {
        return this.esrStationNumber;
    }

    public void setEsrStationNumber(String esrStationNumber) {
        this.esrStationNumber = esrStationNumber;
    }

    public boolean isDataClean() {
        return this.isDataClean;
    }

    public void setIsDataClean(boolean isDataClean) {
        this.isDataClean = isDataClean;
    }

    public String getProcessingId() {
        return this.processingId;
    }

    public void setProcessingId(String processingId) {
        this.processingId = processingId;
    }

    public IPersonService getPSIMSOADelegateService() {
        return this.PSIMSOADelegateService;
    }

    public void setPSIMSOADelegateService(IPersonService delegateService) {
        this.PSIMSOADelegateService = delegateService;
    }

    public Set getVPIDsBySSAVerificationStatuses(Set SSAVerificationStatuses) throws ServiceException {
        HashSet<VPIDEntityKey> results = new HashSet<VPIDEntityKey>();
        if (SSAVerificationStatuses == null || SSAVerificationStatuses.isEmpty()) {
            return results;
        }
        SSN[] criteria = new SSN[SSAVerificationStatuses.size()];
        SSN item = null;
        Iterator itr = SSAVerificationStatuses.iterator();
        int i = 0;
        String oneCriteria = null;
        while (itr.hasNext()) {
            oneCriteria = (String)itr.next();
            item = new SSN();
            item.setSsnVerificationStatus(oneCriteria);
            item.setSsnType(SSNType.CODE_ACTIVE.getCode());
            criteria[i++] = item;
        }
        try {
            IQualifiedIdentifier[] vpids = this.getPSIMSOADelegateService().obtainVpidsBySsnVerificationStatus((ISSN[])criteria, this.esrStationNumber);
            if (vpids != null && vpids.length > 0) {
                for (i = 0; i < vpids.length; ++i) {
                    results.add(CommonEntityKeyFactory.createVPIDEntityKey(vpids[i].getIdentifier()));
                }
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (PSException e) {
            throw new ServiceException("Unable to get VPIDs by SSA Verification Status", (Throwable)e);
        }
        return results;
    }

    protected IQualifiedIdentifier getVpidQualifiedIdentifier(String vpid) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create((String)vpid, (String)"NI");
    }

    protected IQualifiedIdentifier getVpidQualifiedIdentifierWithStationNumber(String vpid) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create((String)vpid, (String)"PI", (String)"USVHA", (String)this.esrStationNumber);
    }

    protected IQualifiedIdentifier getVpidQualifiedIdentifierWithoutStationNumber(String vpid) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create((String)vpid, (String)"NI", (String)"USVHA", null);
    }

    protected IQualifiedIdentifier getSsnQualifiedIdentifier(String ssn) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create((String)ssn, (String)"SS");
    }

    protected IQualifiedIdentifier getDfnQualifiedIdentifierWithStationNumber(String dfn, String stationNumber) throws PSIMException, VPIDException, NPIException {
        return QualifiedIdentifierFactory.create((String)dfn, (String)"PI", (String)"USVHA", (String)stationNumber);
    }

    @Override
    public PersonIdentityTraits getSubmittedIdentityTraits(VPIDEntityKey key) throws ServiceException {
        PersonIdentityTraits submittedTraits = this.doGetSubmittedIdentityTraitsByIdmWS(key, false);
        return submittedTraits;
    }

    private PersonIdentityTraits doGetSubmittedIdentityTraitsByIdmWS(VPIDEntityKey key, boolean returnHistory) throws ServiceException {
        if (key == null) {
            return null;
        }
        PersonIdentityTraits identityTraits = null;
        try {
            identityTraits = this.idmServiceDelegate.getESRCorrelation(key);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Idm WebService returned: " + (Object)((Object)identityTraits)));
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get submitted IdentityTraits from PSIM for key: " + key.getKeyValueAsString(), (Throwable)e);
        }
        return identityTraits;
    }

    private IPersonIdentity doGetSubmittedIdentityTraits(VPIDEntityKey key, boolean returnHistory) throws ServiceException {
        if (key == null) {
            return null;
        }
        IPersonIdentity identityTraits = null;
        try {
            IQualifiedIdentifier identifier = this.getVpidQualifiedIdentifierWithStationNumber(key.getVPID());
            identityTraits = this.getPSIMSOADelegateService().obtainCorrelation(identifier, returnHistory);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("PSIM returned: " + identityTraits));
            }
            if (identityTraits.isDeprecated() && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("PSIM returned a deprecated obtainCorrelation (getIdentityTraits) result for VPID: " + identityTraits.getVPID().getIdentifier()));
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get submitted IdentityTraits from PSIM for key: " + key.getKeyValueAsString(), (Throwable)e);
        }
        return identityTraits;
    }

    @Override
    public List getSubmittedIdentityTraitsUpdateHistory(VPIDEntityKey key) throws ServiceException {
        ListOrderedMap traitMap = new ListOrderedMap();
        IPersonIdentity submittedTraits = this.doGetSubmittedIdentityTraits(key, true);
        if (submittedTraits != null) {
            if (submittedTraits.getAuditEventTimestamp() != null) {
                traitMap.put((Object)submittedTraits.getAuditEventTimestamp(), (Object)this.convertTraits(submittedTraits, key));
            }
            try {
                IPersonIdentity[] history = submittedTraits.getHistory();
                if (history != null) {
                    IPersonIdentity historyTraits = null;
                    for (int i = 0; i < history.length; ++i) {
                        historyTraits = history[i];
                        if (historyTraits.getAuditEventTimestamp() == null) continue;
                        traitMap.put((Object)historyTraits.getAuditEventTimestamp(), (Object)this.convertTraits(historyTraits, null));
                    }
                }
            }
            catch (PSIMException e) {
                throw new ServiceException("Unable to navigate through submitted identitityTraits history", (Throwable)e);
            }
        }
        return new ArrayList(traitMap.values());
    }

    private PersonIdentityTraits createdCannedTraitsWhenDataIsNotClean(String invalidVPID) throws ServiceException {
        if (this.isDataClean) {
            return null;
        }
        this.logger.error((Object)("VPIDException (invalid VPID) received from PSIM...but since data is not clean, returning canned traits for VPID: " + invalidVPID));
        PersonIdentityTraits traits = new PersonIdentityTraits();
        Name name = new Name();
        name.setFamilyName("Invalid VPID");
        name.setType(this.lookupService.getNameTypeByCode(NameType.LEGAL_NAME.getCode()));
        traits.addName(name);
        BirthRecord record = new BirthRecord();
        record.setBirthDate(new gov.va.med.esr.common.infra.ImpreciseDate("194712"));
        record.setCity("Orlando");
        record.setState("FL");
        record.setMultipleBirth(Boolean.TRUE);
        traits.setBirthRecord(record);
        gov.va.med.esr.common.model.person.SSN traitSsn = new gov.va.med.esr.common.model.person.SSN();
        traitSsn.setType(this.lookupService.getSSNTypeByCode(SSNType.CODE_ACTIVE.getCode()));
        traitSsn.setSsnText("999999999");
        traits.setSsn(traitSsn);
        traits.setVpid(CommonEntityKeyFactory.createVPIDEntityKey("Invalid_VPID"));
        return traits;
    }

    @Override
    public String getIDState(VPIDEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        PersonIdentityTraits traits = null;
        try {
            FullyQualifiedIdentity id = new FullyQualifiedIdentity(key.getShortVPID());
            traits = this.getIdmServiceDelegate().search(id, false);
            if (traits != null) {
                return traits.getIDState();
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e2) {
            NoRecordFoundException e2;
            if (e2 instanceof VPIDException) {
                e2 = new NoRecordFoundException("Unable to get IdentityTraits due to invalid VPID: " + key.getKeyValueAsString(), (Throwable)e2);
            }
            throw new ServiceException("Unable to get IdentityTraits from PSIM for VPID: " + key.getKeyValueAsString(), (Throwable)e2);
        }
        return null;
    }

    @Override
    public String requestIDStateChange(VPIDEntityKey key, EnrollmentStatus status) throws ServiceException {
        try {
            PersonIdentityTraits traits = this.getIdentityTraits(key);
            String requestXML = this.requestXMLByTraits(traits);
            String responseXML = this.getPSIMSOADelegateService().execute(requestXML);
            return this.getIdStateFromResponseXML(responseXML);
        }
        catch (Exception e) {
            throw new ServiceException("Error request IDState change VPID = " + key.getKeyValueAsString() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private String requestXMLByTraits(PersonIdentityTraits traits) {
        String XMLString = "<PSIM_REQUEST type='ADDPREFTF'> <ARGUMENT name='profile'> <PROFILE type=''> <ATTRIBUTE type='MMN'>  <VALUE>" + traits.getMothersMaidenName() + "</VALUE>" + "</ATTRIBUTE> <ATTRIBUTE type='GENDER'> <VALUE>" + (Object)((Object)traits.getGender()) + "</VALUE> " + "</ATTRIBUTE> <ATTRIBUTE type='DOB'> <VALUE>" + traits.getBirthRecord().getBirthDate() + "</VALUE> " + "</ATTRIBUTE> <NAME type='L'> <LASTNAME>" + traits.getLegalName().getFamilyName() + "</LASTNAME> " + "<FIRSTNAME>" + traits.getLegalName().getGivenName() + "</FIRSTNAME> " + "<MIDDLENAME>" + traits.getLegalName().getMiddleName() + "</MIDDLENAME> " + "<SUFFIX>" + traits.getLegalName().getSuffix() + "</SUFFIX> </NAME> <NAME type='A'> " + "<IDENTIFIER type='SS' subtype='ALIAS'> <ID> ??????????? </ID> <SOURCE>SSA</SOURCE> " + "<ISSUER>USSSA</ISSUER> </IDENTIFIER> <LASTNAME>PSIMTESTALIAS</LASTNAME> " + "<FIRSTNAME>FOURALIAS</FIRSTNAME> <MIDDLENAME></MIDDLENAME> <SUFFIX></SUFFIX> " + "</NAME> <ADDRESS type='POB'> <CITY>PROVIDENCE</CITY> <STATE>VA</STATE> </ADDRESS> " + "<IDENTIFIER type='SS' subtype='LEGAL'> <ID>" + traits.getSsnText() + "</ID> <ISSUER>USSSA</ISSUER> </IDENTIFIER> " + "<IDENTIFIER type='NI'> <ID>1008522837V021968</ID> </IDENTIFIER> </PROFILE> </ARGUMENT> " + "<ARGUMENT name='preferredFacilityNumber'> <VALUE>500</VALUE> </ARGUMENT> " + "<ARGUMENT name='patientVeteran'> <VALUE>Y</VALUE> </ARGUMENT> " + "<ARGUMENT name='patientServiceConnected'> <VALUE>Y</VALUE> </ARGUMENT> " + "<ARGUMENT name='patientType'> <VALUE>1</VALUE> </ARGUMENT> </PSIM_REQUEST>";
        return XMLString;
    }

    private String getIdStateFromResponseXML(String responseXML) throws Exception {
        String idState = null;
        if (responseXML.indexOf("type='ERROR'") != -1) {
            String errorText = responseXML.substring(responseXML.indexOf("<TEXT>") + "<TEXT>".length(), responseXML.indexOf("</TEXT>")).trim();
            String onlyErrText = errorText.substring(errorText.indexOf("<![CDATA[") + "<![CDATA[".length(), errorText.indexOf("]]>"));
            throw new Exception(onlyErrText);
        }
        idState = responseXML.substring(responseXML.indexOf("<STATUS>") + 8, responseXML.indexOf("</STATUS>"));
        return idState;
    }

    public IdmWebServiceDelegate getIdmServiceDelegate() {
        return this.idmServiceDelegate;
    }

    public void setIdmServiceDelegate(IdmWebServiceDelegate idmServiceDelegate) {
        this.idmServiceDelegate = idmServiceDelegate;
    }

    @Override
    public String getVhicId(VPIDEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        String vhicId = null;
        try {
            List ids = this.idmServiceDelegate.getCorrelationsByVPID(key);
            for (PatientIdentifier pid : ids) {
                if (!"PI".equalsIgnoreCase(pid.getIdentityType()) || !"USVHA".equalsIgnoreCase(pid.getAssigningAuthority()) || !"742V1".equalsIgnoreCase(pid.getStationNumber()) || (vhicId = pid.getIdentity()) == null || vhicId.length() <= 0) continue;
                return vhicId;
            }
        }
        catch (TimeoutException ex) {
            throw new TimeoutServiceException(ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new ServiceException("Unable to get sites from Idm Web Service for VPID: " + key.getKeyValueAsString(), (Throwable)e);
        }
        return vhicId;
    }
}

